/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.professions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.CraftingRequirementsCfg;
import studio.magemonkey.fusion.data.professions.ProfessionConditions;
import studio.magemonkey.fusion.data.recipes.CalculatedRecipe;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.data.recipes.Recipe;
import studio.magemonkey.fusion.data.recipes.RecipeItem;
import studio.magemonkey.fusion.util.ExperienceManager;
import studio.magemonkey.fusion.util.InvalidPatternItemException;

public class CalculatedProfession {
    private final ProfessionConditions conditions;
    private final ItemStack icon;
    private final boolean canJoin;

    public CalculatedProfession(ProfessionConditions conditions, ItemStack icon, boolean canJoin) {
        this.conditions = conditions;
        this.icon = icon;
        this.canJoin = canJoin;
    }

    public static CalculatedProfession create(ProfessionConditions conditions, Collection<ItemStack> items, Player player, CraftingTable craftingTable) throws InvalidPatternItemException {
        try {
            String requirementLine;
            StringBuilder lore = new StringBuilder(512);
            ItemStack defaultIcon = craftingTable.getIconItem().create();
            List resultLore = defaultIcon.getItemMeta().getLore();
            if (resultLore != null && !resultLore.isEmpty()) {
                resultLore.forEach(str -> lore.append((String)str).append('\n'));
                lore.append('\n');
            }
            if (!(requirementLine = CraftingRequirementsCfg.getCraftingRequirementLine("professions")).isEmpty()) {
                lore.append(requirementLine).append('\n');
            }
            boolean canJoin = true;
            String permissionLine = CraftingRequirementsCfg.getLearned("professions", true);
            String moneyLine = null;
            if (conditions.getMoneyCost() != 0.0) {
                if (!CodexEngine.get().getVault().canPay((OfflinePlayer)player, conditions.getMoneyCost())) {
                    canJoin = false;
                }
                moneyLine = CraftingRequirementsCfg.getMoney("recipes", CodexEngine.get().getVault().getBalance((OfflinePlayer)player), conditions.getMoneyCost());
            }
            String expLine = null;
            if (conditions.getExpCost() != 0) {
                if (ExperienceManager.getTotalExperience(player) < conditions.getExpCost()) {
                    canJoin = false;
                }
                expLine = CraftingRequirementsCfg.getExp("recipes", ExperienceManager.getTotalExperience(player), conditions.getExpCost());
            }
            List<Map.Entry<Boolean, String>> conditionLines = conditions.getConditionLines(player);
            for (Map.Entry<Boolean, String> entry : conditionLines) {
                if (entry.getKey().booleanValue()) continue;
                canJoin = false;
                break;
            }
            List<Pair<ItemStack, Integer>> eqItems = Recipe.getItems(items);
            HashSet<RecipeItem> localPattern = new HashSet<RecipeItem>(conditions.getRequiredItems());
            Iterator it = localPattern.iterator();
            while (it.hasNext()) {
                int rest;
                int patternAmount;
                int eqAmount;
                RecipeItem recipeItem = (RecipeItem)it.next();
                ItemStack itemStack = recipeItem.getItemStack();
                ItemStack recipeItemStackOne = itemStack.clone();
                recipeItemStackOne.setAmount(1);
                Pair<ItemStack, Integer> eqEntry = null;
                for (Pair<ItemStack, Integer> entry : eqItems) {
                    ItemStack item = ((ItemStack)entry.getKey()).clone();
                    if (!CalculatedRecipe.isSimilar(recipeItemStackOne, item)) continue;
                    eqEntry = entry;
                    break;
                }
                if ((eqAmount = eqEntry != null ? (Integer)eqEntry.getValue() : 0) < (patternAmount = recipeItem.getAmount())) {
                    canJoin = false;
                    lore.append(CraftingRequirementsCfg.getIngredientLine("recipes", recipeItem, eqAmount, patternAmount)).append('\n');
                    continue;
                }
                if (eqAmount == patternAmount) {
                    eqItems.remove(eqEntry);
                }
                if ((rest = eqAmount - patternAmount) > 0 && eqEntry != null) {
                    eqItems.add((Pair<ItemStack, Integer>)Pair.of((Object)((ItemStack)eqEntry.getKey()), (Object)rest));
                }
                it.remove();
                lore.append(CraftingRequirementsCfg.getIngredientLine("recipes", recipeItem, eqAmount, patternAmount)).append('\n');
            }
            String canJoinLine = CraftingRequirementsCfg.getCanJoin(canJoin);
            lore.append('\n');
            if (moneyLine != null) {
                lore.append(moneyLine).append('\n');
            }
            if (expLine != null) {
                lore.append(expLine).append('\n');
            }
            if (!conditionLines.isEmpty()) {
                for (Map.Entry entry : conditionLines) {
                    lore.append('\n').append((String)entry.getValue());
                }
            }
            lore.append("\n").append(permissionLine);
            lore.append('\n').append(canJoinLine);
            ItemStack icon = defaultIcon.clone();
            ItemMeta itemMeta = icon.getItemMeta();
            itemMeta.setLore(Arrays.asList(StringUtils.split((String)lore.toString(), (char)'\n')));
            icon.setItemMeta(itemMeta);
            return new CalculatedProfession(conditions, icon, canJoin);
        }
        catch (Exception e) {
            Fusion.getInstance().error("The profession-item seems not to be recognized. Please check your setup on the following profession '" + craftingTable.getName() + "':");
            Fusion.getInstance().error("Pattern Items: ");
            for (Object patternItem : conditions.getRequiredItemNames()) {
                Fusion.getInstance().error("- " + String.valueOf(patternItem));
            }
            Fusion.getInstance().error("Error on creating CalculatedProfession: " + e.getMessage());
            throw new InvalidPatternItemException(e);
        }
    }

    @Generated
    public ProfessionConditions getConditions() {
        return this.conditions;
    }

    @Generated
    public ItemStack getIcon() {
        return this.icon;
    }

    @Generated
    public boolean isCanJoin() {
        return this.canJoin;
    }
}

