/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.player;

import lombok.Generated;

public class PlayerRecipeLimit {
    private final String recipeName;
    private int limit;
    private long cooldownTimestamp;

    public PlayerRecipeLimit(String recipeName, int limit, long cooldownTimestamp) {
        this.recipeName = recipeName;
        this.limit = limit;
        this.cooldownTimestamp = cooldownTimestamp;
    }

    public void incrementLimit(int amount) {
        this.limit += amount;
    }

    public void updateCooldown(int seconds) {
        this.cooldownTimestamp = System.currentTimeMillis() + (long)seconds * 1000L;
    }

    public boolean hasCooldown() {
        return this.cooldownTimestamp > System.currentTimeMillis();
    }

    public void resetLimit() {
        this.limit = 0;
        this.cooldownTimestamp = -1L;
    }

    @Generated
    public String getRecipeName() {
        return this.recipeName;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public long getCooldownTimestamp() {
        return this.cooldownTimestamp;
    }
}

