/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.commands;

import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.container.Job;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.CommandType;
import studio.magemonkey.codex.api.DelayedCommand;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.api.items.exception.CodexItemException;
import studio.magemonkey.codex.util.DeserializationWorker;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.cfg.editors.EditorCriteria;
import studio.magemonkey.fusion.cfg.editors.EditorRegistry;
import studio.magemonkey.fusion.data.professions.ProfessionConditions;
import studio.magemonkey.fusion.data.professions.pattern.Category;
import studio.magemonkey.fusion.data.recipes.Recipe;
import studio.magemonkey.fusion.data.recipes.RecipeItem;
import studio.magemonkey.fusion.gui.editors.Editor;
import studio.magemonkey.fusion.gui.editors.browse.BrowseEditor;
import studio.magemonkey.fusion.gui.editors.professions.ProfessionEditor;
import studio.magemonkey.fusion.util.ChatUT;
import studio.magemonkey.fusion.util.TabCacher;

public class FusionEditorCommand
implements CommandExecutor,
TabCompleter {
    private static Map<UUID, EditorCriteria> editorCriteria = new HashMap<UUID, EditorCriteria>();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        Editor editor = EditorRegistry.getCurrentEditor(player);
        if (args.length == 0) {
            if (editor != null) {
                editor.open(player);
                return true;
            }
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"/fusion-editor <profession|browse>")});
            return true;
        }
        if (editor == null || !editorCriteria.containsKey(player.getUniqueId())) {
            block4 : switch (args[0].toLowerCase()) {
                case "profession": {
                    if (args.length < 2) {
                        CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"/fusion-editor profession <professionName> [profession to copy]")});
                        return true;
                    }
                    String professionName = args[1];
                    switch (args.length) {
                        case 2: {
                            if (ProfessionsCfg.getMap().containsKey(professionName)) {
                                EditorRegistry.getProfessionEditor(player, professionName).open(player);
                                CodexEngine.get().getMessageUtil().sendMessage("editor.editProfession", (CommandSender)player, new MessageData[]{new MessageData("profession", (Object)professionName)});
                                break block4;
                            }
                            if (!ProfessionsCfg.createNewProfession(professionName, null)) break block4;
                            EditorRegistry.getProfessionEditor(player, professionName).open(player);
                            CodexEngine.get().getMessageUtil().sendMessage("editor.createdNewProfession", (CommandSender)player, new MessageData[]{new MessageData("profession", (Object)professionName)});
                            break block4;
                        }
                        case 3: {
                            String refProfession = args[2];
                            if (ProfessionsCfg.getMap().containsKey(professionName)) {
                                CodexEngine.get().getMessageUtil().sendMessage("editor.professionAlreadyExists", (CommandSender)player, new MessageData[]{new MessageData("profession", (Object)professionName)});
                                return true;
                            }
                            if (!ProfessionsCfg.getMap().containsKey(refProfession)) {
                                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidProfession", (CommandSender)player, new MessageData[]{new MessageData("profession", (Object)refProfession)});
                                return true;
                            }
                            if (!ProfessionsCfg.createNewProfession(professionName, refProfession)) break block4;
                            EditorRegistry.getProfessionEditor(player, professionName).open(player);
                            CodexEngine.get().getMessageUtil().sendMessage("editor.copyProfession", (CommandSender)player, new MessageData[]{new MessageData("oldProfession", (Object)refProfession), new MessageData("newProfession", (Object)professionName)});
                            break block4;
                        }
                    }
                    CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"/fusion-editor profession <professionName> [profession to copy]")});
                    break;
                }
                case "browse": {
                    EditorRegistry.getBrowseEditor(player).open(player);
                }
            }
            return true;
        }
        EditorCriteria criteria = editorCriteria.get(player.getUniqueId());
        if (editor instanceof ProfessionEditor) {
            ProfessionEditor professionEditor = (ProfessionEditor)editor;
            switch (criteria) {
                case Profession_Edit_Name: {
                    this.updateProfessionName(professionEditor, args);
                    break;
                }
                case Profession_Edit_Icon: {
                    this.updateProfessionIcon(professionEditor, args);
                    break;
                }
                case Profession_Category_Add: 
                case Profession_Category_Edit: {
                    this.updateCategory(professionEditor, args, criteria);
                    break;
                }
                case Pattern_Edit_Name: {
                    this.updatePatternItemName(professionEditor, args);
                    break;
                }
                case Pattern_Edit_Lore: {
                    this.addPatternItemLore(professionEditor, args);
                    break;
                }
                case Pattern_Edit_Pattern: {
                    this.updatePatternItem(professionEditor, args);
                    break;
                }
                case Pattern_Add_Commands: {
                    this.addPatternItemCommand(professionEditor, args);
                    break;
                }
                case Pattern_Add_Enchants: {
                    this.addPatternEnchants(professionEditor, args);
                    break;
                }
                case Pattern_Add_Flags: {
                    this.addPatternFlags(professionEditor, args);
                    break;
                }
                case Profession_Recipe_Edit_Name: {
                    this.updateRecipeName(professionEditor, args);
                    break;
                }
                case Profession_Recipe_Add_Commands: {
                    this.addRecipeCommand(professionEditor, args);
                    break;
                }
                case Profession_Recipe_Add_Items: {
                    this.addRecipeItem(professionEditor, args);
                    break;
                }
                case Profession_Recipe_Add: {
                    this.addNewRecipe(professionEditor, args);
                    break;
                }
                case Profession_Recipe_Edit_ResultItem: 
                case Profession_Recipe_Add_Ingredients: 
                case Profession_Recipe_Edit_Ingredients: {
                    this.updateRecipeItems(professionEditor, args, criteria);
                    break;
                }
                case Profession_Recipe_Edit_Permission: {
                    this.updateRecipePermission(professionEditor, args);
                    break;
                }
                case Profession_Recipe_Add_Conditions: {
                    this.addRecipeConditions(professionEditor, args);
                    break;
                }
                case RecipeIcon_Edit_Name: {
                    this.updateRecipeIconName(professionEditor, args);
                    break;
                }
                case RecipeIcon_Edit_Lore: {
                    this.addRecipeIconLore(professionEditor, args);
                    break;
                }
                case RecipeIcon_Edit_Color: {
                    this.updateRecipeIconColor(professionEditor, args);
                    break;
                }
                case RecipeIcon_Add_Commands: {
                    this.addRecipeIconCommand(professionEditor, args);
                    break;
                }
                case RecipeIcon_Add_Enchants: {
                    this.addRecipeIconEnchants(professionEditor, args);
                    break;
                }
                case RecipeIcon_Add_Flags: {
                    this.addRecipeIconFlags(professionEditor, args);
                    break;
                }
                default: {
                    editor.open(player);
                    break;
                }
            }
        } else if (editor instanceof BrowseEditor) {
            BrowseEditor browseEditor = (BrowseEditor)editor;
            switch (criteria) {
                case Browse_Edit_Name: {
                    this.updateBrowseName(browseEditor, args);
                    break;
                }
                case Browse_Add_Profession: {
                    this.addNewProfession(browseEditor, args);
                    break;
                }
                case Pattern_Edit_Name: {
                    this.updatePatternItemName(browseEditor, args);
                    break;
                }
                case Pattern_Edit_Lore: {
                    this.addPatternItemLore(browseEditor, args);
                    break;
                }
                case Pattern_Edit_Pattern: {
                    this.updatePatternItem(browseEditor, args);
                    break;
                }
                case Pattern_Add_Commands: {
                    this.addPatternItemCommand(browseEditor, args);
                    break;
                }
                case Pattern_Add_Enchants: {
                    this.addPatternEnchants(browseEditor, args);
                    break;
                }
                case Pattern_Add_Flags: {
                    this.addPatternFlags(browseEditor, args);
                    break;
                }
                case Browse_Profession_Add_Ingredients: {
                    this.addBrowseIngredient(browseEditor, args);
                    break;
                }
                case Browse_Profession_Add_Conditions: {
                    this.addBrowseConditions(browseEditor, args);
                    break;
                }
                default: {
                    editor.open(player);
                }
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        ArrayList<String> entries = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return null;
        }
        Player player = (Player)sender;
        Editor editor = EditorRegistry.getCurrentEditor(player);
        if (editor == null || !editorCriteria.containsKey(player.getUniqueId())) {
            if (args.length == 1) {
                if ("profession".startsWith(args[0].toLowerCase())) {
                    entries.add("profession");
                }
                if ("browse".startsWith(args[0].toLowerCase())) {
                    entries.add("browse");
                }
            } else if (args.length == 2) {
                if ("profession".equalsIgnoreCase(args[0])) {
                    if ("<new profession>".startsWith(args[1].toLowerCase())) {
                        entries.add("<new profession>");
                    }
                    entries.addAll(TabCacher.getTabs(player.getUniqueId(), "professions", args[1]));
                }
            } else if (args.length == 3 && "profession".equalsIgnoreCase(args[0]) && !TabCacher.getTabs(player.getUniqueId(), "professions", args[2]).contains(args[1])) {
                entries.add("<profession to copy>");
                entries.addAll(TabCacher.getTabs(player.getUniqueId(), "professions", args[2]));
            }
            return entries;
        }
        if (editor instanceof ProfessionEditor) {
            ProfessionEditor professionEditor = (ProfessionEditor)editor;
            EditorCriteria criteria = editorCriteria.get(player.getUniqueId());
            switch (criteria) {
                case Profession_Edit_Name: 
                case Pattern_Edit_Name: {
                    if (args.length != 1) break;
                    entries.add("<newName>");
                    entries.add(professionEditor.getTable().getInventoryName());
                    break;
                }
                case Profession_Edit_Icon: {
                    if (args.length != 1) break;
                    entries.addAll(TabCacher.getTabs(TabCacher.GlobalUUID, "items", args[0]));
                    break;
                }
                case Profession_Category_Add: 
                case Profession_Category_Edit: {
                    if (args.length == 1) {
                        if (criteria == EditorCriteria.Profession_Category_Add) {
                            entries.add("<categoryName>");
                            break;
                        }
                        if (!professionEditor.getCategoryEditor().getLastEditedCategoryName().startsWith(args[0])) break;
                        entries.add(professionEditor.getCategoryEditor().getLastEditedCategoryName());
                        break;
                    }
                    if (args.length != 2) break;
                    entries.addAll(TabCacher.getTabs(TabCacher.GlobalUUID, "items", args[1]));
                    break;
                }
                case Profession_Recipe_Add: {
                    if (args.length == 1) {
                        entries.add("<recipeName>");
                        break;
                    }
                    if (args.length == 2) {
                        entries.addAll(TabCacher.getTabs(TabCacher.GlobalUUID, "items", args[1]));
                        break;
                    }
                    if (args.length != 3) break;
                    entries.add("<amount>");
                    entries.add("1");
                    entries.add("5");
                    entries.add("32");
                    entries.add("64");
                    break;
                }
                case Pattern_Edit_Pattern: 
                case Profession_Recipe_Add_Items: 
                case Profession_Recipe_Edit_ResultItem: 
                case Profession_Recipe_Add_Ingredients: 
                case Profession_Recipe_Edit_Ingredients: {
                    if (args.length == 1) {
                        entries.addAll(TabCacher.getTabs(TabCacher.GlobalUUID, "items", args[0]));
                        break;
                    }
                    if (args.length != 2) break;
                    entries.add("<amount>");
                    entries.add("1");
                    entries.add("5");
                    entries.add("32");
                    entries.add("64");
                    break;
                }
                case Profession_Recipe_Edit_Name: {
                    if (args.length != 1) break;
                    entries.add("<newRecipeName>");
                    entries.add(professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipeName());
                    break;
                }
                case Pattern_Add_Commands: 
                case Profession_Recipe_Add_Commands: 
                case RecipeIcon_Add_Commands: {
                    if (args.length == 1) {
                        if ("console".startsWith(args[0].toUpperCase())) {
                            entries.add("console");
                        }
                        if ("player".startsWith(args[0].toUpperCase())) {
                            entries.add("player");
                        }
                        if ("op".startsWith(args[0].toUpperCase())) {
                            entries.add("op");
                        }
                    } else if (args.length == 2) {
                        entries.add("0");
                        entries.add("<delay>");
                    } else if (args.length == 3) {
                        entries.add("<command without / >");
                    }
                    if (args.length < 3) break;
                    entries.add("{player}");
                    break;
                }
                case Profession_Recipe_Add_Conditions: 
                case Browse_Profession_Add_Conditions: {
                    entries.addAll(TabCacher.getConditionsTabs(args));
                    break;
                }
                case Pattern_Edit_Lore: 
                case RecipeIcon_Edit_Lore: {
                    if (args.length != 1) break;
                    entries.add("<lore>");
                    break;
                }
                case Pattern_Add_Enchants: 
                case RecipeIcon_Add_Enchants: {
                    entries.addAll(TabCacher.getEnchantmentsTab(args));
                    break;
                }
                case Pattern_Add_Flags: 
                case RecipeIcon_Add_Flags: {
                    entries.addAll(TabCacher.getFlagsTab(args));
                    break;
                }
                case RecipeIcon_Edit_Name: {
                    if (args.length != 1) break;
                    entries.add("<newName>");
                    entries.add(professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipeIconEditor().getRecipe().getSettings().getName());
                    break;
                }
                case RecipeIcon_Edit_Color: {
                    if (args.length != 1) break;
                    entries.add("0,0,0");
                    entries.add("255,255,255");
                    entries.add("0,0,255");
                    entries.add("255,0,0");
                }
            }
        } else if (editor instanceof BrowseEditor) {
            BrowseEditor browseEditor = (BrowseEditor)editor;
            EditorCriteria criteria = editorCriteria.get(player.getUniqueId());
            switch (criteria) {
                case Browse_Edit_Name: {
                    if (args.length != 1) break;
                    entries.add("<newName>");
                    entries.add(browseEditor.getName());
                    break;
                }
                case Browse_Add_Profession: {
                    if (args.length != 1) break;
                    entries.addAll(TabCacher.getTabs(TabCacher.GlobalUUID, "professions", args[0]));
                    break;
                }
                case Pattern_Edit_Name: {
                    if (args.length != 1) break;
                    entries.add("<newName>");
                    entries.add(browseEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().getName());
                    break;
                }
                case Pattern_Edit_Lore: {
                    if (args.length != 1) break;
                    entries.add("<lore>");
                    break;
                }
                case Pattern_Edit_Pattern: 
                case Browse_Profession_Add_Ingredients: {
                    if (args.length == 1) {
                        entries.addAll(TabCacher.getTabs(TabCacher.GlobalUUID, "items", args[0]));
                        break;
                    }
                    if (args.length != 2) break;
                    entries.add("<amount>");
                    entries.add("1");
                    entries.add("5");
                    entries.add("32");
                    entries.add("64");
                    break;
                }
                case Pattern_Add_Commands: {
                    if (args.length == 1) {
                        if ("console".startsWith(args[0].toUpperCase())) {
                            entries.add("console");
                        }
                        if ("player".startsWith(args[0].toUpperCase())) {
                            entries.add("player");
                        }
                        if ("op".startsWith(args[0].toUpperCase())) {
                            entries.add("op");
                        }
                    } else if (args.length == 2) {
                        entries.add("0");
                        entries.add("<delay>");
                    } else if (args.length == 3) {
                        entries.add("<command without / >");
                    }
                    if (args.length < 3) break;
                    entries.add("{player}");
                    break;
                }
                case Browse_Profession_Add_Conditions: {
                    entries.addAll(TabCacher.getConditionsTabs(args));
                    break;
                }
                case Pattern_Add_Enchants: {
                    entries.addAll(TabCacher.getEnchantmentsTab(args));
                    break;
                }
                case Pattern_Add_Flags: {
                    entries.addAll(TabCacher.getFlagsTab(args));
                }
            }
        }
        return entries;
    }

    private boolean isValidItem(String item) {
        try {
            Material.valueOf((String)item.toUpperCase());
            return true;
        }
        catch (IllegalArgumentException e) {
            try {
                return CodexEngine.get().getItemManager().getItemType(item) != null;
            }
            catch (CodexItemException ignored) {
                return false;
            }
        }
    }

    public static void suggestUsage(Player player, EditorCriteria criteria, String suggestCommand) {
        if (criteria == null) {
            return;
        }
        editorCriteria.put(player.getUniqueId(), criteria);
        switch (criteria) {
            case Profession_Edit_Name: 
            case Pattern_Edit_Name: 
            case RecipeIcon_Edit_Name: 
            case Browse_Edit_Name: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.editorUsage", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<newName>")});
                break;
            }
            case Profession_Recipe_Add_Items: 
            case Profession_Recipe_Add_Ingredients: 
            case Profession_Recipe_Edit_Ingredients: 
            case Browse_Profession_Add_Ingredients: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.editorUsage", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<item> <amount>")});
                break;
            }
            case Profession_Category_Add: 
            case Profession_Category_Edit: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.editorUsage", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<categoryName> <categoryIcon>")});
                break;
            }
            case Profession_Recipe_Add_Conditions: 
            case Browse_Profession_Add_Conditions: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.editorUsage", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<conditionKey> <conditionValue> <level>")});
                break;
            }
            case Pattern_Add_Commands: 
            case Profession_Recipe_Add_Commands: 
            case RecipeIcon_Add_Commands: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.editorUsage", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<caster> <delay> <command without />")});
                break;
            }
            case Profession_Edit_Icon: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.editorUsage", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<icon>")});
                break;
            }
            case Pattern_Edit_Pattern: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.editorUsage", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<item> <amount>")});
                break;
            }
            case Pattern_Edit_Lore: 
            case RecipeIcon_Edit_Lore: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.editorUsage", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<lore>")});
                break;
            }
            case Profession_Recipe_Add: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.editorUsage", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<recipeName> <resultItem> <amount>")});
                break;
            }
            case Profession_Recipe_Edit_ResultItem: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.editorUsage", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<resultItem> <amount>")});
                break;
            }
            case Profession_Recipe_Edit_Name: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.editorUsage", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<newRecipeName>")});
                break;
            }
            case Browse_Add_Profession: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.editorUsage", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<professionName>")});
                break;
            }
            case Pattern_Add_Enchants: 
            case RecipeIcon_Add_Enchants: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.editorUsage", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<enchantment> [level]")});
                break;
            }
            case Pattern_Add_Flags: 
            case RecipeIcon_Add_Flags: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.editorUsage", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<flag>")});
                break;
            }
            case RecipeIcon_Edit_Color: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.editorUsage", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<color>")});
            }
        }
        FusionEditorCommand.sendSuggestMessage(player, suggestCommand);
        player.closeInventory();
    }

    private static void sendSuggestMessage(Player player, String suggestedCommand) {
        BaseComponent[] components;
        if (suggestedCommand == null) {
            return;
        }
        for (BaseComponent component : components = CodexEngine.get().getMessageUtil().getMessageAsComponent("editor.editorClick", new MessageData[0])) {
            component.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, suggestedCommand));
        }
        player.spigot().sendMessage(components);
    }

    private void updateProfessionName(ProfessionEditor professionEditor, String[] args) {
        StringBuilder professionNameBuilder = new StringBuilder();
        for (String arg : args) {
            professionNameBuilder.append(arg).append(" ");
        }
        String professionName = professionNameBuilder.toString().trim();
        String oldName = professionEditor.getTable().getName();
        Player player = professionEditor.getPlayer();
        professionEditor.getTable().setInventoryName(professionName);
        CodexEngine.get().getMessageUtil().sendMessage("editor.professionRenamed", (CommandSender)player, new MessageData[]{new MessageData("oldName", (Object)oldName), new MessageData("newName", (Object)professionName)});
        professionEditor.reload(true);
    }

    private void updateProfessionIcon(ProfessionEditor professionEditor, String[] args) {
        String icon = args[0];
        String oldIcon = professionEditor.getTable().getIconItem().getID();
        Player player = professionEditor.getPlayer();
        if (!this.isValidItem(icon)) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidItem", (CommandSender)player, new MessageData[]{new MessageData("item", (Object)icon)});
            return;
        }
        try {
            professionEditor.getTable().setIconItem(CodexEngine.get().getItemManager().getItemType(icon));
        }
        catch (CodexItemException e) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidItem", (CommandSender)player, new MessageData[]{new MessageData("item", (Object)icon)});
            return;
        }
        CodexEngine.get().getMessageUtil().sendMessage("editor.professionIconChanged", (CommandSender)player, new MessageData[]{new MessageData("oldIcon", (Object)oldIcon), new MessageData("newIcon", (Object)icon)});
        professionEditor.reload(true);
    }

    private void updateCategory(ProfessionEditor professionEditor, String[] args, EditorCriteria criteria) {
        if (args.length < 2) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)professionEditor.getPlayer(), new MessageData[]{new MessageData("syntax", (Object)"<categoryName> <categoryIcon>")});
            return;
        }
        String categoryName = args[0];
        String categoryIcon = args[1];
        Player player = professionEditor.getPlayer();
        if (!this.isValidItem(categoryIcon)) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidItem", (CommandSender)player, new MessageData[]{new MessageData("item", (Object)categoryIcon)});
            return;
        }
        if (criteria == EditorCriteria.Profession_Category_Add) {
            professionEditor.getTable().getCategories().put(categoryName, new Category(Map.of("name", categoryName, "icon", categoryIcon, "order", professionEditor.getTable().getCategories().size() + 1)));
            CodexEngine.get().getMessageUtil().sendMessage("editor.categoryAdded", (CommandSender)player, new MessageData[]{new MessageData("category", (Object)categoryName), new MessageData("profession", (Object)professionEditor.getTable().getName())});
        } else {
            if (!professionEditor.getTable().getCategories().containsKey(categoryName)) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.categoryNotFound", (CommandSender)player, new MessageData[]{new MessageData("category", (Object)categoryName)});
                return;
            }
            professionEditor.getTable().getCategories().get(categoryName).setName(categoryName);
            ItemType oldIcon = professionEditor.getTable().getCategories().get(categoryName).getIconItem();
            try {
                professionEditor.getTable().getCategories().get(categoryName).setIconItem(CodexEngine.get().getItemManager().getItemType(categoryIcon));
            }
            catch (CodexItemException e) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidItem", (CommandSender)player, new MessageData[]{new MessageData("item", (Object)categoryIcon)});
                professionEditor.getTable().getCategories().get(categoryName).setIconItem(oldIcon);
                return;
            }
            CodexEngine.get().getMessageUtil().sendMessage("editor.categoryEdited", (CommandSender)player, new MessageData[]{new MessageData("category", (Object)categoryName), new MessageData("profession", (Object)professionEditor.getTable().getName())});
        }
        professionEditor.getCategoryEditor().reload(true);
    }

    private void updatePatternItemName(Editor editor, String[] args) {
        StringBuilder builder = new StringBuilder();
        for (String arg : args) {
            builder.append(arg).append(" ");
        }
        String name = builder.toString().trim();
        if (editor instanceof ProfessionEditor) {
            ProfessionEditor professionEditor = (ProfessionEditor)editor;
            String oldName = professionEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().getName();
            player = professionEditor.getPlayer();
            professionEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().name(name);
            CodexEngine.get().getMessageUtil().sendMessage("editor.patternItemRenamed", (CommandSender)player, new MessageData[]{new MessageData("oldName", (Object)oldName), new MessageData("newName", (Object)name)});
            professionEditor.getPatternItemsEditor().getPatternItemEditor().reload(true);
        } else if (editor instanceof BrowseEditor) {
            BrowseEditor browseEditor = (BrowseEditor)editor;
            String oldName = browseEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().getName();
            player = browseEditor.getPlayer();
            browseEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().name(name);
            CodexEngine.get().getMessageUtil().sendMessage("editor.patternItemRenamed", (CommandSender)player, new MessageData[]{new MessageData("oldName", (Object)oldName), new MessageData("newName", (Object)name)});
            browseEditor.getPatternItemsEditor().getPatternItemEditor().reload(true);
        }
    }

    private void updatePatternItem(Editor editor, String[] args) {
        if (editor instanceof ProfessionEditor) {
            ProfessionEditor professionEditor = (ProfessionEditor)editor;
            Player player = professionEditor.getPlayer();
            if (args.length < 2) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)professionEditor.getPlayer(), new MessageData[]{new MessageData("syntax", (Object)"<item> <amount>")});
                return;
            }
            try {
                Material material = Material.valueOf((String)args[0].toUpperCase());
                int amount = Integer.parseInt(args[1]);
                professionEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().material(material);
                professionEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().amount(amount);
                professionEditor.getPatternItemsEditor().getPatternItemEditor().reload(true);
                CodexEngine.get().getMessageUtil().sendMessage("editor.patternItemUpdated", (CommandSender)player, new MessageData[]{new MessageData("item", (Object)args[0]), new MessageData("amount", (Object)amount)});
            }
            catch (Exception e) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidItem", (CommandSender)player, new MessageData[]{new MessageData("item", (Object)args[0])});
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidNumber", (CommandSender)player, new MessageData[]{new MessageData("number", (Object)args[1])});
            }
        } else if (editor instanceof BrowseEditor) {
            BrowseEditor browseEditor = (BrowseEditor)editor;
            Player player = browseEditor.getPlayer();
            if (args.length < 2) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)browseEditor.getPlayer(), new MessageData[]{new MessageData("syntax", (Object)"<item> <amount>")});
                return;
            }
            try {
                Material material = Material.valueOf((String)args[0].toUpperCase());
                int amount = Integer.parseInt(args[1]);
                browseEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().material(material);
                browseEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().amount(amount);
                browseEditor.getPatternItemsEditor().getPatternItemEditor().reload(true);
                CodexEngine.get().getMessageUtil().sendMessage("editor.patternItemUpdated", (CommandSender)player, new MessageData[]{new MessageData("item", (Object)args[0]), new MessageData("amount", (Object)amount)});
            }
            catch (Exception e) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidItem", (CommandSender)player, new MessageData[]{new MessageData("item", (Object)args[0])});
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidNumber", (CommandSender)player, new MessageData[]{new MessageData("number", (Object)args[1])});
            }
        }
    }

    private void addPatternItemLore(Editor editor, String[] args) {
        if (editor instanceof ProfessionEditor) {
            ProfessionEditor professionEditor = (ProfessionEditor)editor;
            Player player = professionEditor.getPlayer();
            if (args.length < 1) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)args)});
                return;
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                builder.append(args[i]);
                if (i >= args.length - 1) continue;
                builder.append(" ");
            }
            professionEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().newLoreLine(builder.toString());
            professionEditor.getPatternItemsEditor().getPatternItemEditor().reload(true);
            CodexEngine.get().getMessageUtil().sendMessage("editor.patternItemLoreAdded", (CommandSender)player, new MessageData[]{new MessageData("lore", (Object)ChatUT.hexString(builder.toString()))});
        } else if (editor instanceof BrowseEditor) {
            BrowseEditor browseEditor = (BrowseEditor)editor;
            Player player = browseEditor.getPlayer();
            if (args.length < 1) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)args)});
                return;
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                builder.append(args[i]);
                if (i >= args.length - 1) continue;
                builder.append(" ");
            }
            browseEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().newLoreLine(builder.toString());
            browseEditor.getPatternItemsEditor().getPatternItemEditor().reload(true);
            CodexEngine.get().getMessageUtil().sendMessage("editor.patternItemLoreAdded", (CommandSender)player, new MessageData[]{new MessageData("lore", (Object)ChatUT.hexString(builder.toString()))});
        }
    }

    private void addPatternItemCommand(Editor editor, String[] args) {
        if (editor instanceof ProfessionEditor) {
            ProfessionEditor professionEditor = (ProfessionEditor)editor;
            Player player = professionEditor.getPlayer();
            if (args.length < 3) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidCommand", (CommandSender)player, new MessageData[]{new MessageData("command", (Object)args)});
                return;
            }
            StringBuilder commandBuilder = new StringBuilder();
            try {
                CommandType commandType = CommandType.valueOf((String)args[0].toUpperCase());
                int delay = Integer.parseInt(args[1]);
                commandBuilder = new StringBuilder();
                for (int i = 2; i < args.length; ++i) {
                    commandBuilder.append(args[i]);
                    if (i >= args.length - 1) continue;
                    commandBuilder.append(" ");
                }
                professionEditor.getPatternItemsEditor().getPatternItemEditor().addCommand(new DelayedCommand(Map.of("delay", delay, "as", commandType.name(), "cmd", commandBuilder.toString())));
                professionEditor.getPatternItemsEditor().getPatternItemEditor().reload(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidCommand", (CommandSender)player, new MessageData[]{new MessageData("command", (Object)(args[0] + " " + args[1] + " " + String.valueOf(commandBuilder)))});
            }
        } else if (editor instanceof BrowseEditor) {
            BrowseEditor browseEditor = (BrowseEditor)editor;
            Player player = browseEditor.getPlayer();
            if (args.length < 3) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidCommand", (CommandSender)player, new MessageData[]{new MessageData("command", (Object)args)});
                return;
            }
            StringBuilder commandBuilder = new StringBuilder();
            try {
                CommandType commandType = CommandType.valueOf((String)args[0].toUpperCase());
                int delay = Integer.parseInt(args[1]);
                commandBuilder = new StringBuilder();
                for (int i = 2; i < args.length; ++i) {
                    commandBuilder.append(args[i]);
                    if (i >= args.length - 1) continue;
                    commandBuilder.append(" ");
                }
                browseEditor.getPatternItemsEditor().getPatternItemEditor().addCommand(new DelayedCommand(Map.of("delay", delay, "as", commandType.name(), "cmd", commandBuilder.toString())));
                browseEditor.getPatternItemsEditor().getPatternItemEditor().reload(true);
            }
            catch (Exception e) {
                e.printStackTrace();
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidCommand", (CommandSender)player, new MessageData[]{new MessageData("command", (Object)(args[0] + " " + args[1] + " " + String.valueOf(commandBuilder)))});
            }
        }
    }

    private void addPatternEnchants(Editor editor, String[] args) {
        if (editor instanceof ProfessionEditor) {
            Enchantment enchantment;
            ProfessionEditor professionEditor = (ProfessionEditor)editor;
            Player player = professionEditor.getPlayer();
            if (args.length < 1) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<enchantment> [level]")});
                return;
            }
            int level = 1;
            if (args.length >= 2) {
                try {
                    level = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    CodexEngine.get().getMessageUtil().sendMessage("editor.invalidNumber", (CommandSender)player, new MessageData[]{new MessageData("number", (Object)args[1])});
                    return;
                }
            }
            if ((enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)args[0].toLowerCase()))) == null) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidEnchantment", (CommandSender)player, new MessageData[]{new MessageData("enchantment", (Object)args[0])});
                return;
            }
            professionEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().enchant(enchantment, level);
            professionEditor.getPatternItemsEditor().getPatternItemEditor().reload(true);
        } else if (editor instanceof BrowseEditor) {
            Enchantment enchantment;
            BrowseEditor browseEditor = (BrowseEditor)editor;
            Player player = browseEditor.getPlayer();
            if (args.length < 1) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<enchantment> [level]")});
                return;
            }
            int level = 1;
            if (args.length >= 2) {
                try {
                    level = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    CodexEngine.get().getMessageUtil().sendMessage("editor.invalidNumber", (CommandSender)player, new MessageData[]{new MessageData("number", (Object)args[1])});
                    return;
                }
            }
            if ((enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)args[0].toLowerCase()))) == null) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidEnchantment", (CommandSender)player, new MessageData[]{new MessageData("enchantment", (Object)args[0])});
                return;
            }
            browseEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().enchant(enchantment, level);
            browseEditor.getPatternItemsEditor().getPatternItemEditor().reload(true);
        }
    }

    public void addPatternFlags(Editor editor, String[] args) {
        if (editor instanceof ProfessionEditor) {
            ProfessionEditor professionEditor = (ProfessionEditor)editor;
            Player player = professionEditor.getPlayer();
            if (args.length < 1) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<flag>")});
                return;
            }
            try {
                ItemFlag flag = ItemFlag.valueOf((String)args[0].toUpperCase());
                if (professionEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().getFlags().contains(flag)) {
                    CodexEngine.get().getMessageUtil().sendMessage("editor.flagAlreadyExists", (CommandSender)player, new MessageData[]{new MessageData("flag", (Object)flag.name())});
                    return;
                }
                professionEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().flag(flag);
                professionEditor.getPatternItemsEditor().getPatternItemEditor().reload(true);
            }
            catch (Exception e) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidFlag", (CommandSender)player, new MessageData[]{new MessageData("flag", (Object)args[0])});
            }
        } else if (editor instanceof BrowseEditor) {
            BrowseEditor browseEditor = (BrowseEditor)editor;
            Player player = browseEditor.getPlayer();
            if (args.length < 1) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<flag>")});
                return;
            }
            try {
                ItemFlag flag = ItemFlag.valueOf((String)args[0].toUpperCase());
                if (browseEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().getFlags().contains(flag)) {
                    CodexEngine.get().getMessageUtil().sendMessage("editor.flagAlreadyExists", (CommandSender)player, new MessageData[]{new MessageData("flag", (Object)flag.name())});
                    return;
                }
                browseEditor.getPatternItemsEditor().getPatternItemEditor().getBuilder().flag(flag);
                browseEditor.getPatternItemsEditor().getPatternItemEditor().reload(true);
            }
            catch (Exception e) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidFlag", (CommandSender)player, new MessageData[]{new MessageData("flag", (Object)args[0])});
            }
        }
    }

    private void updateRecipeName(ProfessionEditor professionEditor, String[] args) {
        if (args.length < 1) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)professionEditor.getPlayer(), new MessageData[]{new MessageData("syntax", (Object)"<newRecipeName>")});
            return;
        }
        String recipeName = args[0];
        Player player = professionEditor.getPlayer();
        String oldName = professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipeName();
        for (Recipe recipe : professionEditor.getTable().getRecipes().values()) {
            if (!recipe.getName().equalsIgnoreCase(recipeName)) continue;
            CodexEngine.get().getMessageUtil().sendMessage("editor.recipeAlreadyExists", (CommandSender)player, new MessageData[]{new MessageData("recipe", (Object)recipeName)});
            return;
        }
        professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().setName(recipeName);
        CodexEngine.get().getMessageUtil().sendMessage("editor.recipeRenamed", (CommandSender)player, new MessageData[]{new MessageData("oldName", (Object)oldName), new MessageData("newName", (Object)recipeName)});
        professionEditor.getRecipeEditor().getRecipeItemEditor().reload(true);
    }

    private void addRecipeCommand(ProfessionEditor professionEditor, String[] args) {
        Player player = professionEditor.getPlayer();
        if (args.length < 3) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidCommand", (CommandSender)player, new MessageData[]{new MessageData("command", (Object)args)});
            return;
        }
        StringBuilder commandBuilder = new StringBuilder();
        try {
            CommandType commandType = CommandType.valueOf((String)args[0].toUpperCase());
            int delay = Integer.parseInt(args[1]);
            commandBuilder = new StringBuilder();
            for (int i = 2; i < args.length; ++i) {
                commandBuilder.append(args[i]);
                if (i >= args.length - 1) continue;
                commandBuilder.append(" ");
            }
            professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getResults().getCommands().add(new DelayedCommand(Map.of("delay", delay, "as", commandType.name(), "cmd", commandBuilder.toString())));
            professionEditor.getRecipeEditor().getRecipeItemEditor().reload(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidCommand", (CommandSender)player, new MessageData[]{new MessageData("command", (Object)(args[0] + " " + args[1] + " " + String.valueOf(commandBuilder)))});
        }
    }

    private void addRecipeItem(ProfessionEditor professionEditor, String[] args) {
        Player player = professionEditor.getPlayer();
        if (args.length < 2) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<item> <amount>")});
            return;
        }
        try {
            String itemName = args[0];
            int amount = Integer.parseInt(args[1]);
            if (!this.isValidItem(itemName)) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidItem", (CommandSender)player, new MessageData[]{new MessageData("item", (Object)itemName)});
                return;
            }
            professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getResults().getItemNames().add(itemName + ":" + amount);
            professionEditor.getRecipeEditor().getRecipeItemEditor().reload(true);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidNumber", (CommandSender)player, new MessageData[]{new MessageData("number", (Object)args[1])});
        }
    }

    private void addNewRecipe(ProfessionEditor professionEditor, String[] args) {
        Player player = professionEditor.getPlayer();
        if (args.length < 3) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<recipeName> <resultItem> <amount>")});
            return;
        }
        try {
            String recipeName = args[0];
            String itemName = args[1];
            int amount = Integer.parseInt(args[2]);
            for (Recipe recipe : professionEditor.getTable().getRecipes().values()) {
                if (!recipe.getName().equalsIgnoreCase(recipeName)) continue;
                CodexEngine.get().getMessageUtil().sendMessage("editor.recipeAlreadyExists", (CommandSender)player, new MessageData[]{new MessageData("recipe", (Object)recipeName)});
                return;
            }
            if (!this.isValidItem(itemName)) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidItem", (CommandSender)player, new MessageData[]{new MessageData("item", (Object)itemName)});
                return;
            }
            if (professionEditor.getTable().getRecipes().containsKey(recipeName)) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.recipeAlreadyExists", (CommandSender)player, new MessageData[]{new MessageData("recipe", (Object)recipeName)});
                return;
            }
            LinkedHashMap<String, Object> recipeSettings = new LinkedHashMap<String, Object>();
            recipeSettings.put("name", recipeName);
            if (!professionEditor.getTable().getCategories().isEmpty()) {
                recipeSettings.put("category", professionEditor.getTable().getCategories().keySet().iterator().next());
            }
            recipeSettings.put("craftingTime", 0);
            recipeSettings.put("results", Map.of("professionExp", 0, "vanillaExp", 0, "commands", new ArrayList(), "items", new ArrayList()));
            recipeSettings.put("conditions", Map.of("professionLevel", 0, "mastery", false));
            recipeSettings.put("costs", Map.of("items", List.of("STONE:3"), "money", 0.0, "exp", 0));
            recipeSettings.put("settings", Map.of("icon", Map.of("item", itemName + ":" + amount)));
            professionEditor.getTable().getRecipes().put(recipeName, new Recipe(professionEditor.getTable(), recipeSettings));
            CodexEngine.get().getMessageUtil().sendMessage("editor.recipeAdded", (CommandSender)player, new MessageData[]{new MessageData("recipe", (Object)recipeName), new MessageData("result", (Object)itemName)});
            professionEditor.getRecipeEditor().reload(true);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidNumber", (CommandSender)player, new MessageData[]{new MessageData("number", (Object)args[2])});
        }
    }

    private void updateRecipeItems(ProfessionEditor professionEditor, String[] args, EditorCriteria criteria) {
        Player player = professionEditor.getPlayer();
        if (args.length != 2) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<item> <amount>")});
            return;
        }
        try {
            String itemName = args[0];
            int amount = Integer.parseInt(args[1]);
            if (!this.isValidItem(itemName)) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidItem", (CommandSender)player, new MessageData[]{new MessageData("item", (Object)itemName)});
                return;
            }
            switch (criteria) {
                case Profession_Recipe_Edit_ResultItem: {
                    professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getSettings().setRecipeItem(RecipeItem.fromConfig(itemName + ":" + amount));
                    professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getSettings().setIconNamespace(itemName + ":" + amount);
                    CodexEngine.get().getMessageUtil().sendMessage("editor.resultEdited", (CommandSender)player, new MessageData[]{new MessageData("recipe", (Object)professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getName()), new MessageData("result", (Object)itemName)});
                    break;
                }
                case Profession_Recipe_Add_Ingredients: {
                    int i = 0;
                    boolean found = false;
                    for (RecipeItem ingredient : professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().getRequiredItems()) {
                        if (ingredient.toConfig().toString().split(":")[0].equalsIgnoreCase(itemName)) {
                            professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().getRequiredItems().set(i, RecipeItem.fromConfig(itemName + ":" + amount));
                            professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().getRequiredItemNames().set(i, itemName + ":" + amount);
                            found = true;
                        }
                        ++i;
                    }
                    if (found) break;
                    professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().getRequiredItems().add(RecipeItem.fromConfig(itemName + ":" + amount));
                    professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().getRequiredItemNames().add(itemName + ":" + amount);
                    break;
                }
                case Profession_Recipe_Edit_Ingredients: {
                    professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().getRequiredItems().clear();
                    professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().getRequiredItems().add(RecipeItem.fromConfig(itemName + ":" + amount));
                    professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().getRequiredItemNames().add(itemName + ":" + amount);
                }
            }
            professionEditor.getRecipeEditor().getRecipeItemEditor().reload(true);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidNumber", (CommandSender)player, new MessageData[]{new MessageData("number", (Object)args[1])});
        }
    }

    private void updateRecipePermission(ProfessionEditor professionEditor, String[] args) {
        Player player = professionEditor.getPlayer();
        if (args.length != 1) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<permission>")});
            return;
        }
        String permission = args[0];
        professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().setPermission(permission);
        CodexEngine.get().getMessageUtil().sendMessage("editor.recipePermissionUpdated", (CommandSender)player, new MessageData[]{new MessageData("permission", (Object)permission)});
        professionEditor.getRecipeEditor().getRecipeItemEditor().reload(true);
    }

    private void addRecipeConditions(ProfessionEditor professionEditor, String[] args) {
        Player player = professionEditor.getPlayer();
        if (args.length != 3) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<conditionKey> <conditionValue> <level>")});
            return;
        }
        String conditionKey = args[0];
        String conditionValue = args[1];
        int level = Integer.parseInt(args[2]);
        switch (conditionKey) {
            case "professions": {
                if (!ProfessionsCfg.getMap().containsKey(conditionValue)) {
                    CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionValue", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
                    return;
                }
                professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().getProfessionConditions().put(conditionValue, level);
                break;
            }
            case "fabled": {
                if (!Bukkit.getPluginManager().isPluginEnabled("Fabled")) {
                    return;
                }
                if (!Fabled.getClasses().containsKey(conditionValue)) {
                    CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionValue", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
                    return;
                }
                professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().getFabledClassConditions().put(conditionValue, level);
                break;
            }
            case "mcmmo": {
                if (!Bukkit.getPluginManager().isPluginEnabled("mcMMO")) {
                    return;
                }
                try {
                    PrimarySkillType skillType = PrimarySkillType.valueOf((String)conditionValue.toUpperCase());
                    professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().getMcMMOConditions().put(conditionValue, level);
                    break;
                }
                catch (IllegalArgumentException e) {
                    CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionValue", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
                    return;
                }
            }
            case "jobs": {
                if (!Bukkit.getPluginManager().isPluginEnabled("Jobs")) {
                    return;
                }
                Optional<Job> job = Jobs.getJobs().stream().filter(_job -> _job.getName().equalsIgnoreCase(conditionValue)).findFirst();
                if (job.isEmpty()) {
                    CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionValue", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
                    return;
                }
                professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().getJobsConditions().put(conditionValue, level);
                break;
            }
            case "aura_abilities": 
            case "aura_mana_abilities": 
            case "aura_skills": 
            case "aura_stats": {
                if (!Bukkit.getPluginManager().isPluginEnabled("AuraSkills") || !Bukkit.getPluginManager().isPluginEnabled("AureliumSkills")) {
                    return;
                }
                switch (conditionKey) {
                    case "aura_abilities": {
                        if (AuraSkillsApi.get().getGlobalRegistry().getAbility(NamespacedId.fromString((String)conditionValue)) == null) {
                            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionValue", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
                            return;
                        }
                        professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().getAuraAbilityConditions().put(conditionValue, level);
                        break;
                    }
                    case "aura_mana_abilities": {
                        if (AuraSkillsApi.get().getGlobalRegistry().getManaAbility(NamespacedId.fromString((String)conditionValue)) == null) {
                            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionValue", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
                            return;
                        }
                        professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().getAuraManaAbilityConditions().put(conditionValue, level);
                        break;
                    }
                    case "aura_skills": {
                        if (AuraSkillsApi.get().getGlobalRegistry().getSkill(NamespacedId.fromString((String)conditionValue)) == null) {
                            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionValue", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
                            return;
                        }
                        professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().getAuraSkillsConditions().put(conditionValue, level);
                        break;
                    }
                    case "aura_stats": {
                        if (AuraSkillsApi.get().getGlobalRegistry().getStat(NamespacedId.fromString((String)conditionValue)) == null) {
                            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionValue", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
                            return;
                        }
                        professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getConditions().getAuraStatsConditions().put(conditionValue, level);
                    }
                }
            }
            default: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionKey", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey)});
                return;
            }
        }
        CodexEngine.get().getMessageUtil().sendMessage("editor.conditionAdded", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
        professionEditor.getRecipeEditor().getRecipeItemEditor().reload(true);
    }

    private void updateBrowseName(BrowseEditor browseEditor, String[] args) {
        StringBuilder builder = new StringBuilder();
        for (String arg : args) {
            builder.append(arg).append(" ");
        }
        String name = builder.toString().trim();
        String oldName = browseEditor.getName();
        Player player = browseEditor.getPlayer();
        browseEditor.setName(name);
        CodexEngine.get().getMessageUtil().sendMessage("editor.browserRenamed", (CommandSender)player, new MessageData[]{new MessageData("oldName", (Object)oldName), new MessageData("newName", (Object)name)});
        browseEditor.reload(true);
    }

    private void addNewProfession(BrowseEditor browseEditor, String[] args) {
        String professionName = args[0];
        Player player = browseEditor.getPlayer();
        if (!ProfessionsCfg.getMap().containsKey(professionName)) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidProfession", (CommandSender)player, new MessageData[]{new MessageData("profession", (Object)professionName)});
            return;
        }
        if (browseEditor.getProfessions().contains(professionName)) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.professionAlreadyExists", (CommandSender)player, new MessageData[]{new MessageData("profession", (Object)professionName)});
            return;
        }
        browseEditor.getProfessions().add(professionName);
        LinkedHashMap conditionsMaps = new LinkedHashMap();
        conditionsMaps.put("costs", Map.of("money", 0.0, "exp", 0, "items", new ArrayList()));
        conditionsMaps.put("conditions", Map.of());
        browseEditor.getProfessionConditions().put(professionName, new ProfessionConditions(professionName, DeserializationWorker.start(conditionsMaps)));
        CodexEngine.get().getMessageUtil().sendMessage("editor.addedProfessionToBrowse", (CommandSender)player, new MessageData[]{new MessageData("profession", (Object)professionName)});
        browseEditor.getBrowseProfessionsEditor().reload(true);
    }

    private void addBrowseIngredient(BrowseEditor browseEditor, String[] args) {
        Player player = browseEditor.getPlayer();
        if (args.length != 2) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<item> <amount>")});
            return;
        }
        try {
            String itemName = args[0];
            int amount = Integer.parseInt(args[1]);
            if (!this.isValidItem(itemName)) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidItem", (CommandSender)player, new MessageData[]{new MessageData("item", (Object)itemName)});
                return;
            }
            int i = 0;
            boolean found = false;
            for (RecipeItem ingredient : browseEditor.getBrowseProfessionsEditor().getBrowseProfessionEditor().getConditions().getRequiredItems()) {
                if (ingredient.toConfig().toString().split(":")[0].equalsIgnoreCase(itemName)) {
                    browseEditor.getBrowseProfessionsEditor().getBrowseProfessionEditor().getConditions().getRequiredItems().set(i, RecipeItem.fromConfig(itemName + ":" + amount));
                    browseEditor.getBrowseProfessionsEditor().getBrowseProfessionEditor().getConditions().getRequiredItemNames().set(i, itemName + ":" + amount);
                    found = true;
                }
                ++i;
            }
            if (!found) {
                browseEditor.getBrowseProfessionsEditor().getBrowseProfessionEditor().getConditions().getRequiredItems().add(RecipeItem.fromConfig(itemName + ":" + amount));
                browseEditor.getBrowseProfessionsEditor().getBrowseProfessionEditor().getConditions().getRequiredItemNames().add(itemName + ":" + amount);
                browseEditor.getBrowseProfessionsEditor().getBrowseProfessionEditor().reload(true);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidNumber", (CommandSender)player, new MessageData[]{new MessageData("number", (Object)args[1])});
        }
    }

    private void addBrowseConditions(BrowseEditor browseEditor, String[] args) {
        Player player = browseEditor.getPlayer();
        if (args.length != 3) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<conditionKey> <conditionValue> <level>")});
            return;
        }
        String conditionKey = args[0];
        String conditionValue = args[1];
        int level = Integer.parseInt(args[2]);
        switch (conditionKey) {
            case "professions": {
                if (!ProfessionsCfg.getMap().containsKey(conditionValue)) {
                    CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionValue", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
                    return;
                }
                browseEditor.getBrowseProfessionsEditor().getBrowseProfessionEditor().getConditions().getProfessionConditions().put(conditionValue, level);
                break;
            }
            case "fabled": {
                if (!Bukkit.getPluginManager().isPluginEnabled("Fabled")) {
                    return;
                }
                if (!Fabled.getClasses().containsKey(conditionValue)) {
                    CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionValue", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
                    return;
                }
                browseEditor.getBrowseProfessionsEditor().getBrowseProfessionEditor().getConditions().getFabledClassConditions().put(conditionValue, level);
                break;
            }
            case "mcmmo": {
                if (!Bukkit.getPluginManager().isPluginEnabled("mcMMO")) {
                    return;
                }
                try {
                    PrimarySkillType skillType = PrimarySkillType.valueOf((String)conditionValue.toUpperCase());
                    browseEditor.getBrowseProfessionsEditor().getBrowseProfessionEditor().getConditions().getMcMMOConditions().put(conditionValue, level);
                    break;
                }
                catch (IllegalArgumentException e) {
                    CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionValue", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
                    return;
                }
            }
            case "jobs": {
                if (!Bukkit.getPluginManager().isPluginEnabled("Jobs")) {
                    return;
                }
                Optional<Job> job = Jobs.getJobs().stream().filter(_job -> _job.getName().equalsIgnoreCase(conditionValue)).findFirst();
                if (job.isEmpty()) {
                    CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionValue", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
                    return;
                }
                browseEditor.getBrowseProfessionsEditor().getBrowseProfessionEditor().getConditions().getJobsConditions().put(conditionValue, level);
                break;
            }
            case "aura_abilities": 
            case "aura_mana_abilities": 
            case "aura_skills": 
            case "aura_stats": {
                if (!Bukkit.getPluginManager().isPluginEnabled("AuraSkills") || !Bukkit.getPluginManager().isPluginEnabled("AureliumSkills")) {
                    return;
                }
                switch (conditionKey) {
                    case "aura_abilities": {
                        if (AuraSkillsApi.get().getGlobalRegistry().getAbility(NamespacedId.fromString((String)conditionValue)) == null) {
                            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionValue", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
                            return;
                        }
                        browseEditor.getBrowseProfessionsEditor().getBrowseProfessionEditor().getConditions().getAuraAbilityConditions().put(conditionValue, level);
                        break;
                    }
                    case "aura_mana_abilities": {
                        if (AuraSkillsApi.get().getGlobalRegistry().getManaAbility(NamespacedId.fromString((String)conditionValue)) == null) {
                            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionValue", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
                            return;
                        }
                        browseEditor.getBrowseProfessionsEditor().getBrowseProfessionEditor().getConditions().getAuraManaAbilityConditions().put(conditionValue, level);
                        break;
                    }
                    case "aura_skills": {
                        if (AuraSkillsApi.get().getGlobalRegistry().getSkill(NamespacedId.fromString((String)conditionValue)) == null) {
                            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionValue", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
                            return;
                        }
                        browseEditor.getBrowseProfessionsEditor().getBrowseProfessionEditor().getConditions().getAuraSkillsConditions().put(conditionValue, level);
                        break;
                    }
                    case "aura_stats": {
                        if (AuraSkillsApi.get().getGlobalRegistry().getStat(NamespacedId.fromString((String)conditionValue)) == null) {
                            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionValue", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
                            return;
                        }
                        browseEditor.getBrowseProfessionsEditor().getBrowseProfessionEditor().getConditions().getAuraStatsConditions().put(conditionValue, level);
                    }
                }
            }
            default: {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidConditionKey", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey)});
                return;
            }
        }
        CodexEngine.get().getMessageUtil().sendMessage("editor.conditionAdded", (CommandSender)player, new MessageData[]{new MessageData("key", (Object)conditionKey), new MessageData("value", (Object)conditionValue), new MessageData("level", (Object)args[2])});
        browseEditor.getBrowseProfessionsEditor().getBrowseProfessionEditor().reload(true);
    }

    public void updateRecipeIconName(ProfessionEditor professionEditor, String[] args) {
        if (args.length < 1) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)professionEditor.getPlayer(), new MessageData[]{new MessageData("syntax", (Object)"<newIconName>")});
            return;
        }
        String iconName = args[0];
        Player player = professionEditor.getPlayer();
        professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getSettings().setName(iconName);
        CodexEngine.get().getMessageUtil().sendMessage("editor.recipeIconRenamed", (CommandSender)player, new MessageData[]{new MessageData("icon", (Object)iconName)});
        professionEditor.getRecipeEditor().getRecipeItemEditor().reload(true);
    }

    public void addRecipeIconLore(ProfessionEditor professionEditor, String[] args) {
        if (args.length < 1) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)professionEditor.getPlayer(), new MessageData[]{new MessageData("syntax", (Object)"<lore>")});
            return;
        }
        StringBuilder loreBuilder = new StringBuilder();
        for (String arg : args) {
            loreBuilder.append(arg).append(" ");
        }
        String lore = loreBuilder.toString().trim();
        Player player = professionEditor.getPlayer();
        professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getSettings().getLore().add(lore);
        CodexEngine.get().getMessageUtil().sendMessage("editor.recipeIconLoreAdded", (CommandSender)player, new MessageData[]{new MessageData("lore", (Object)lore)});
        professionEditor.getRecipeEditor().getRecipeItemEditor().reload(true);
    }

    public void addRecipeIconFlags(ProfessionEditor professionEditor, String[] args) {
        if (args.length < 1) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)professionEditor.getPlayer(), new MessageData[]{new MessageData("syntax", (Object)"<flag>")});
            return;
        }
        Player player = professionEditor.getPlayer();
        try {
            ItemFlag flag = ItemFlag.valueOf((String)args[0].toUpperCase());
            if (professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getSettings().getFlags().contains(flag)) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.flagAlreadyExists", (CommandSender)player, new MessageData[]{new MessageData("flag", (Object)flag.name())});
                return;
            }
            professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getSettings().getFlags().add(flag);
            CodexEngine.get().getMessageUtil().sendMessage("editor.recipeIconFlagAdded", (CommandSender)player, new MessageData[]{new MessageData("flag", (Object)flag.name())});
            professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipeIconEditor().reload(true);
        }
        catch (Exception e) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidFlag", (CommandSender)player, new MessageData[]{new MessageData("flag", (Object)args[0])});
        }
    }

    public void updateRecipeIconColor(ProfessionEditor professionEditor, String[] args) {
        if (args.length < 1) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)professionEditor.getPlayer(), new MessageData[]{new MessageData("syntax", (Object)"<color> (r,g,b)")});
            return;
        }
        Player player = professionEditor.getPlayer();
        try {
            String[] data = args[0].split(",");
            Color color = Color.fromRGB((int)Integer.parseInt(data[0]), (int)Integer.parseInt(data[1]), (int)Integer.parseInt(data[2]));
            professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getSettings().setColor(args[0]);
            CodexEngine.get().getMessageUtil().sendMessage("editor.recipeIconColorUpdated", (CommandSender)player, new MessageData[]{new MessageData("color", (Object)color.asRGB())});
            professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipeIconEditor().reload(true);
        }
        catch (NumberFormatException e) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidNumber", (CommandSender)player, new MessageData[]{new MessageData("number", (Object)args[0])});
        }
    }

    public void addRecipeIconCommand(ProfessionEditor professionEditor, String[] args) {
        Player player = professionEditor.getPlayer();
        if (args.length < 3) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidCommand", (CommandSender)player, new MessageData[]{new MessageData("command", (Object)args)});
            return;
        }
        StringBuilder commandBuilder = new StringBuilder();
        try {
            CommandType commandType = CommandType.valueOf((String)args[0].toUpperCase());
            int delay = Integer.parseInt(args[1]);
            commandBuilder = new StringBuilder();
            for (int i = 2; i < args.length; ++i) {
                commandBuilder.append(args[i]);
                if (i >= args.length - 1) continue;
                commandBuilder.append(" ");
            }
            professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getSettings().getCommandsOnClick().add(new DelayedCommand(Map.of("delay", delay, "as", commandType.name(), "cmd", commandBuilder.toString())));
            professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipeIconEditor().reload(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidCommand", (CommandSender)player, new MessageData[]{new MessageData("command", (Object)(args[0] + " " + args[1] + " " + String.valueOf(commandBuilder)))});
        }
    }

    public void addRecipeIconEnchants(ProfessionEditor professionEditor, String[] args) {
        Player player = professionEditor.getPlayer();
        if (args.length < 2) {
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidSyntax", (CommandSender)player, new MessageData[]{new MessageData("syntax", (Object)"<enchantment> <level>")});
            return;
        }
        try {
            Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)args[0].toLowerCase()));
            int level = Integer.parseInt(args[1]);
            if (enchantment == null) {
                CodexEngine.get().getMessageUtil().sendMessage("editor.invalidEnchantment", (CommandSender)player, new MessageData[]{new MessageData("enchantment", (Object)args[0])});
                return;
            }
            professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipe().getSettings().getEnchantments().put(enchantment, level);
            professionEditor.getRecipeEditor().getRecipeItemEditor().getRecipeIconEditor().reload(true);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            CodexEngine.get().getMessageUtil().sendMessage("editor.invalidNumber", (CommandSender)player, new MessageData[]{new MessageData("number", (Object)args[1])});
        }
    }

    public static void removeEditorCriteria(UUID uuid) {
        editorCriteria.remove(uuid);
    }
}

