/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.api.FusionAPI;
import studio.magemonkey.fusion.cfg.Cfg;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.cfg.sql.DatabaseType;
import studio.magemonkey.fusion.cfg.sql.SQLManager;
import studio.magemonkey.fusion.commands.Commands;
import studio.magemonkey.fusion.data.player.PlayerLoader;
import studio.magemonkey.fusion.data.professions.Profession;
import studio.magemonkey.fusion.data.professions.pattern.Category;
import studio.magemonkey.fusion.data.recipes.CalculatedRecipe;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.data.recipes.Recipe;
import studio.magemonkey.fusion.data.recipes.RecipeItem;
import studio.magemonkey.fusion.gui.BrowseGUI;
import studio.magemonkey.fusion.gui.ProfessionGuiRegistry;
import studio.magemonkey.fusion.gui.RecipeGui;
import studio.magemonkey.fusion.gui.show.ShowRecipesGui;
import studio.magemonkey.fusion.util.Utils;

public class CommandMechanics {
    public static void useProfession(CommandSender sender, String[] args) {
        if (!Utils.hasCraftingUsePermission((Permissible)sender, null)) {
            return;
        }
        String[] professionArgs = args[1].split(":");
        String profession = professionArgs[0];
        Category category = null;
        ProfessionGuiRegistry eq = ProfessionsCfg.getGuiMap().get(profession);
        if (professionArgs.length == 2 && Fusion.getInstance().checkPermission(sender, "fusion.craft.use.categories")) {
            category = ProfessionsCfg.getTable(profession).getCategory(professionArgs[1]);
        } else if (professionArgs.length == 2) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.noPermission", sender, new MessageData[0]);
            return;
        }
        if (eq == null) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.notACrafting", sender, new MessageData[]{new MessageData("name", (Object)args[1]), new MessageData("sender", (Object)sender)});
            return;
        }
        if (args.length == 3) {
            if (!Fusion.getInstance().checkPermission(sender, "fusion.admin.use")) {
                return;
            }
            Player target = Bukkit.getPlayer((String)args[2]);
            if (target == null) {
                CodexEngine.get().getMessageUtil().sendMessage("notAPlayer", sender, new MessageData[]{new MessageData("name", (Object)args[2]), new MessageData("sender", (Object)sender)});
                return;
            }
            CommandMechanics.openGui(target, eq, category);
            CodexEngine.get().getMessageUtil().sendMessage("fusion.useConfirmOther", sender, new MessageData[]{new MessageData("craftingInventory", (Object)eq.getProfession()), new MessageData("sender", (Object)sender.getName()), new MessageData("target", (Object)target.getName())});
        } else if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!Utils.hasCraftingUsePermission((Permissible)sender, eq.getProfession())) {
                return;
            }
            if (!PlayerLoader.getPlayer(player).hasProfession(eq.getProfession())) {
                if (player.isOp()) {
                    CommandMechanics.openGui(player, eq, category);
                    CodexEngine.get().getMessageUtil().sendMessage("fusion.useConfirm", sender, new MessageData[]{new MessageData("craftingInventory", (Object)eq), new MessageData("player", (Object)sender)});
                    return;
                }
                CodexEngine.get().getMessageUtil().sendMessage("fusion.error.notUnlocked", sender, new MessageData[0]);
                return;
            }
            CommandMechanics.openGui(player, eq, category);
            CodexEngine.get().getMessageUtil().sendMessage("fusion.useConfirm", sender, new MessageData[]{new MessageData("craftingInventory", (Object)eq), new MessageData("player", (Object)sender)});
        } else {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.help", sender, new MessageData[]{new MessageData("sender", (Object)sender)});
        }
    }

    public static void masterProfession(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            String guiName = args[1];
            CraftingTable table = ProfessionsCfg.getTable(guiName);
            if (table == null) {
                CodexEngine.get().getMessageUtil().sendMessage("fusion.notACrafting", sender, new MessageData[]{new MessageData("name", (Object)args[1]), new MessageData("sender", (Object)sender)});
                return;
            }
            if (PlayerLoader.getPlayer(((Player)sender).getUniqueId()).hasMastered(table.getName())) {
                CodexEngine.get().getMessageUtil().sendMessage("fusion.error.alreadyMastered", sender, new MessageData[]{new MessageData("sender", (Object)sender), new MessageData("craftingTable", (Object)table)});
            }
            if (table.getLevelFunction().getLevel((OfflinePlayer)player) < table.getMasteryUnlock()) {
                CodexEngine.get().getMessageUtil().sendMessage("fusion.error.noMasteryLevel", sender, new MessageData[]{new MessageData("sender", (Object)sender), new MessageData("craftingTable", (Object)table)});
            }
            if (!CodexEngine.get().getVault().canPay((OfflinePlayer)player, (double)table.getMasteryFee())) {
                CodexEngine.get().getMessageUtil().sendMessage("fusion.error.noMasteryFunds", sender, new MessageData[]{new MessageData("sender", (Object)sender), new MessageData("craftingTable", (Object)table)});
            }
            FusionAPI.getEventServices().getProfessionService().masterProfession(table.getName(), player, true);
            PlayerLoader.getPlayer(((Player)sender).getUniqueId()).setMastered(table.getName(), true);
            CodexEngine.get().getMessageUtil().sendMessage("fusion.mastered", sender, new MessageData[]{new MessageData("sender", (Object)sender), new MessageData("craftingTable", (Object)table)});
        } else {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.help", sender, new MessageData[]{new MessageData("sender", (Object)sender)});
        }
    }

    public static void forgetProfession(CommandSender sender, String[] args, Map<String, Commands.ConfirmationAction> confirmation) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            CraftingTable table = ProfessionsCfg.getTable(args[1]);
            if (table == null) {
                CodexEngine.get().getMessageUtil().sendMessage("fusion.notACrafting", sender, new MessageData[]{new MessageData("name", (Object)args[1]), new MessageData("sender", (Object)sender)});
                return;
            }
            Commands.ConfirmationAction action = () -> FusionAPI.getEventServices().getProfessionService().leaveProfession(table, player);
            confirmation.put(player.getUniqueId().toString(), action);
            CodexEngine.get().getMessageUtil().sendMessage("fusion.forget.confirm", sender, new MessageData[]{new MessageData("sender", (Object)sender), new MessageData("craftingTable", (Object)table)});
            Bukkit.getScheduler().runTaskLater((Plugin)Fusion.getInstance(), () -> confirmation.remove(player.getUniqueId().toString()), 300L);
        } else {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.help", sender, new MessageData[]{new MessageData("sender", (Object)sender)});
        }
    }

    public static void joinProfession(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (ProfessionsCfg.getGuiMap().containsKey(args[1])) {
                BrowseGUI.joinProfession(player, ProfessionsCfg.getGUI(args[1]));
            } else {
                CodexEngine.get().getMessageUtil().sendMessage("fusion.notACrafting", sender, new MessageData[]{new MessageData("name", (Object)args[1]), new MessageData("sender", (Object)sender)});
            }
        } else {
            CodexEngine.get().getMessageUtil().sendMessage("senderIsNotPlayer", sender, new MessageData[]{new MessageData("sender", (Object)sender)});
        }
    }

    public static void setStorage(CommandSender sender, String[] args) {
        String storage = args[1];
        DatabaseType type = DatabaseType.valueOf(Objects.requireNonNull(Cfg.getConfig()).getString("storage.type", "LOCALE").toUpperCase());
        switch (storage.toLowerCase()) {
            case "local": {
                if (type == DatabaseType.LOCAL) {
                    CodexEngine.get().getMessageUtil().sendMessage("fusion.error.alreadyUsedStorage", sender, new MessageData[]{new MessageData("storage", (Object)storage)});
                    return;
                }
                SQLManager.swapToLocal();
                CodexEngine.get().getMessageUtil().sendMessage("fusion.storageChanged", sender, new MessageData[]{new MessageData("storage", (Object)storage)});
                break;
            }
            case "sql": {
                if (type == DatabaseType.MARIADB || type == DatabaseType.MYSQL) {
                    CodexEngine.get().getMessageUtil().sendMessage("fusion.error.alreadyUsedStorage", sender, new MessageData[]{new MessageData("storage", (Object)storage)});
                    return;
                }
                SQLManager.swapToSql();
                CodexEngine.get().getMessageUtil().sendMessage("fusion.storageChanged", sender, new MessageData[]{new MessageData("storage", (Object)storage)});
                break;
            }
            default: {
                CodexEngine.get().getMessageUtil().sendMessage("fusion.error.invalidStorage", sender, new MessageData[]{new MessageData("storage", (Object)storage)});
            }
        }
    }

    public static void openBrowseGui(CommandSender sender) {
        if (!(sender instanceof Player)) {
            CodexEngine.get().getMessageUtil().sendMessage("senderIsNotPlayer", sender, new MessageData[]{new MessageData("sender", (Object)sender)});
            return;
        }
        Player player = (Player)sender;
        if (player.isPermissionSet("fusion.browse") && !player.hasPermission("fusion.browse")) {
            return;
        }
        BrowseGUI.open(player);
    }

    public static void openIngredientGui(CommandSender sender) {
        if (!(sender instanceof Player)) {
            CodexEngine.get().getMessageUtil().sendMessage("senderIsNotPlayer", sender, new MessageData[]{new MessageData("sender", (Object)sender)});
            return;
        }
        Player player = (Player)sender;
        if (Fusion.getInstance().checkPermission(sender, "fusion.show")) {
            CommandMechanics.showIngredientUsage(player);
        }
    }

    public static void showStats(CommandSender sender) {
        if (!(sender instanceof Player)) {
            CodexEngine.get().getMessageUtil().sendMessage("senderIsNotPlayer", sender, new MessageData[]{new MessageData("sender", (Object)sender)});
            return;
        }
        for (Profession profession : PlayerLoader.getPlayer(((Player)sender).getUniqueId()).getProfessions()) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.level.format", sender, new MessageData[]{new MessageData("category", (Object)profession.getName()), new MessageData("level", (Object)profession.getLevel()), new MessageData("experience", (Object)PlayerLoader.getPlayer(((Player)sender).getUniqueId()).getExperience(profession))});
        }
    }

    public static void toggleAutoCrafting(CommandSender sender) {
        if (!(sender instanceof Player)) {
            CodexEngine.get().getMessageUtil().sendMessage("senderIsNotPlayer", sender, new MessageData[]{new MessageData("sender", (Object)sender)});
            return;
        }
        Player player = (Player)sender;
        if (Cfg.craftingQueue) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.autoDisabled", sender, new MessageData[0]);
            return;
        }
        if (!Fusion.getInstance().checkPermission(sender, "fusion.auto")) {
            return;
        }
        boolean autoOn = PlayerLoader.getPlayer(player).isAutoCrafting();
        autoOn = !autoOn;
        PlayerLoader.getPlayer(player).setAutoCrafting(autoOn);
        CodexEngine.get().getMessageUtil().sendMessage("fusion.autoToggle", (CommandSender)player, new MessageData[]{new MessageData("state", (Object)(autoOn ? "on" : "off"))});
    }

    public static void reloadPlugin(CommandSender sender) {
        if (!Fusion.getInstance().checkPermission(sender, "fusion.reload")) {
            return;
        }
        Fusion.getInstance().closeAll();
        Fusion.getInstance().reloadConfig();
        Fusion.getInstance().reloadLang();
        ProfessionGuiRegistry.clearLatestRecipeGui();
        RecipeGui.resetRecipeHashes();
        CodexEngine.get().getMessageUtil().sendMessage("fusion.reload", sender, new MessageData[]{new MessageData("sender", (Object)sender)});
    }

    public static void confirmAction(CommandSender sender, Map<String, Commands.ConfirmationAction> confirmation) {
        String id;
        String string = id = sender instanceof Player ? ((Player)sender).getUniqueId().toString() : "console";
        if (confirmation.containsKey(id)) {
            confirmation.get(id).doAction();
            confirmation.remove(id);
        } else {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.nothingToConfirm", sender, new MessageData[]{new MessageData("sender", (Object)sender)});
        }
    }

    public static void setProfessionExp(CommandSender sender, String[] args) {
        String profession = args[2];
        if (!Fusion.getInstance().checkPermission(sender, "fusion.admin")) {
            return;
        }
        if (profession == null || !ProfessionsCfg.getMap().containsKey(profession)) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.invalidProfession", sender, new MessageData[0]);
            return;
        }
        Player player = Bukkit.getPlayer((String)args[3]);
        if (player == null) {
            CodexEngine.get().getMessageUtil().sendMessage("notAPlayer", sender, new MessageData[]{new MessageData("name", (Object)args[2])});
            return;
        }
        if (FusionAPI.getPlayerManager().getPlayer(player).getProfession(profession) == null) {
            CodexEngine.get().getMessageUtil().sendMessage("player.professionNotAvailable", sender, new MessageData[0]);
            return;
        }
        try {
            long exp = Long.parseLong(args[4]);
            long expBefore = FusionAPI.getPlayerManager().getPlayer(player).getExperience(profession);
            switch (args[1].toLowerCase()) {
                case "add": {
                    FusionAPI.getEventServices().getProfessionService().giveProfessionExp(player, ProfessionsCfg.getTable(profession), exp);
                    break;
                }
                case "take": {
                    FusionAPI.getEventServices().getProfessionService().giveProfessionExp(player, ProfessionsCfg.getTable(profession), -exp);
                    break;
                }
                case "set": {
                    FusionAPI.getEventServices().getProfessionService().setProfessionExp(player, ProfessionsCfg.getTable(profession), exp);
                }
            }
            long expAfter = FusionAPI.getPlayerManager().getPlayer(player).getExperience(profession);
            CodexEngine.get().getMessageUtil().sendMessage("admin.expChanged", sender, new MessageData[]{new MessageData("sender", (Object)sender), new MessageData("player", (Object)player.getName()), new MessageData("profession", (Object)profession), new MessageData("exp_old", (Object)expBefore), new MessageData("exp_new", (Object)expAfter)});
        }
        catch (NumberFormatException e) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.invalidNumber", sender, new MessageData[0]);
        }
    }

    public static void setProfessionLevel(CommandSender sender, String[] args) {
        String profession = args[2];
        if (!Fusion.getInstance().checkPermission(sender, "fusion.admin")) {
            return;
        }
        if (profession == null || !ProfessionsCfg.getMap().containsKey(profession)) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.invalidProfession", sender, new MessageData[0]);
            return;
        }
        if (!Fusion.getInstance().checkPermission(sender, "fusion.level")) {
            return;
        }
        Player player = Bukkit.getPlayer((String)args[3]);
        if (player == null) {
            CodexEngine.get().getMessageUtil().sendMessage("notAPlayer", sender, new MessageData[]{new MessageData("name", (Object)args[2])});
            return;
        }
        if (FusionAPI.getPlayerManager().getPlayer(player).getProfession(profession) == null) {
            CodexEngine.get().getMessageUtil().sendMessage("player.professionNotAvailable", sender, new MessageData[0]);
            return;
        }
        try {
            int levelBefore = FusionAPI.getPlayerManager().getPlayer(player).getLevel(profession);
            int levelAfter = Integer.parseInt(args[4]);
            if (levelAfter <= 0) {
                levelBefore = 1;
            }
            long expBefore = (long)ProfessionsCfg.getTable(profession).getLevelFunction().getXP(levelBefore);
            long expAfter = (long)ProfessionsCfg.getTable(profession).getLevelFunction().getXP(levelAfter);
            switch (args[1].toLowerCase()) {
                case "add": {
                    long expDiff = CommandMechanics.getExpDifference(expBefore, expAfter);
                    FusionAPI.getEventServices().getProfessionService().giveProfessionExp(player, ProfessionsCfg.getTable(profession), expDiff + (long)(!Cfg.useCustomFormula ? 1 : 0));
                    break;
                }
                case "take": {
                    long expDiff = CommandMechanics.getExpDifference(expBefore, expAfter);
                    FusionAPI.getEventServices().getProfessionService().giveProfessionExp(player, ProfessionsCfg.getTable(profession), -expDiff);
                    break;
                }
                case "set": {
                    FusionAPI.getEventServices().getProfessionService().setProfessionExp(player, ProfessionsCfg.getTable(profession), expAfter + (long)(!Cfg.useCustomFormula ? 1 : 0));
                }
            }
            CodexEngine.get().getMessageUtil().sendMessage("admin.levelChanged", sender, new MessageData[]{new MessageData("sender", (Object)sender), new MessageData("player", (Object)player.getName()), new MessageData("profession", (Object)profession), new MessageData("level_old", (Object)levelBefore), new MessageData("level_new", (Object)levelAfter)});
        }
        catch (NumberFormatException e) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.invalidNumber", sender, new MessageData[0]);
        }
    }

    private static void openGui(Player player, ProfessionGuiRegistry registry, Category category) {
        if (category == null) {
            registry.open(player);
        } else {
            registry.open(player, category);
        }
    }

    private static void showIngredientUsage(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType().isAir()) {
            return;
        }
        HashMap<Recipe, RecipeItem> recipeUsage = new HashMap<Recipe, RecipeItem>();
        for (CraftingTable table : ProfessionsCfg.getMap().values()) {
            for (Recipe recipe : table.getRecipes().values()) {
                for (RecipeItem ingredient : recipe.getConditions().getRequiredItems()) {
                    if (!CalculatedRecipe.isSimilar(ingredient.getItemStack(), item)) continue;
                    recipeUsage.put(recipe, ingredient);
                }
            }
        }
        new ShowRecipesGui(player, recipeUsage).open(player);
    }

    private static long getExpDifference(double expBefore, double expAfter) {
        if (expBefore > expAfter) {
            return (long)(expBefore - expAfter);
        }
        return (long)(expAfter - expBefore);
    }

    public static void forceJoinProfession(@NotNull CommandSender sender, String[] args) {
        if (!Fusion.getInstance().checkPermission(sender, "fusion.admin.force")) {
            return;
        }
        if (args.length < 3) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.force.invalidSyntax", sender, new MessageData[]{new MessageData("syntax", (Object)"/fusion forcejoin <player> <profession>")});
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            CodexEngine.get().getMessageUtil().sendMessage("notAPlayer", sender, new MessageData[]{new MessageData("name", (Object)args[1]), new MessageData("sender", (Object)sender)});
            return;
        }
        String professionName = args[2];
        if (!ProfessionsCfg.getGuiMap().containsKey(professionName)) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.notACrafting", sender, new MessageData[]{new MessageData("name", (Object)professionName), new MessageData("sender", (Object)sender)});
            return;
        }
        ProfessionGuiRegistry registry = ProfessionsCfg.getGUI(professionName);
        if (PlayerLoader.getPlayer(target).hasProfession(registry.getProfession())) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.force.alreadyHasProfession", sender, new MessageData[]{new MessageData("player", (Object)target.getName()), new MessageData("profession", (Object)professionName)});
            return;
        }
        FusionAPI.getEventServices().getProfessionService().joinProfession(registry.getProfession(), target, 0.0, 0);
        CodexEngine.get().getMessageUtil().sendMessage("fusion.force.joinSuccess", sender, new MessageData[]{new MessageData("player", (Object)target.getName()), new MessageData("profession", (Object)professionName), new MessageData("sender", (Object)sender)});
    }

    public static void forceLeaveProfession(@NotNull CommandSender sender, String[] args) {
        if (!Fusion.getInstance().checkPermission(sender, "fusion.admin.force")) {
            return;
        }
        if (args.length < 3) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.force.invalidSyntax", sender, new MessageData[]{new MessageData("syntax", (Object)"/fusion forceleave <player> <profession>")});
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            CodexEngine.get().getMessageUtil().sendMessage("notAPlayer", sender, new MessageData[]{new MessageData("name", (Object)args[1]), new MessageData("sender", (Object)sender)});
            return;
        }
        String professionName = args[2];
        CraftingTable table = ProfessionsCfg.getTable(professionName);
        if (table == null) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.notACrafting", sender, new MessageData[]{new MessageData("name", (Object)professionName), new MessageData("sender", (Object)sender)});
            return;
        }
        if (!PlayerLoader.getPlayer(target).hasProfession(table.getName())) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.force.doesNotHaveProfession", sender, new MessageData[]{new MessageData("player", (Object)target.getName()), new MessageData("profession", (Object)professionName)});
            return;
        }
        FusionAPI.getEventServices().getProfessionService().leaveProfession(table, target);
        CodexEngine.get().getMessageUtil().sendMessage("fusion.force.leaveSuccess", sender, new MessageData[]{new MessageData("player", (Object)target.getName()), new MessageData("profession", (Object)professionName), new MessageData("sender", (Object)sender)});
    }

    public static void forceStats(@NotNull CommandSender sender, String[] args) {
        if (!Fusion.getInstance().checkPermission(sender, "fusion.admin.force")) {
            return;
        }
        if (args.length < 2) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.force.invalidSyntax", sender, new MessageData[]{new MessageData("syntax", (Object)"/fusion forcestats <player>")});
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            CodexEngine.get().getMessageUtil().sendMessage("notAPlayer", sender, new MessageData[]{new MessageData("name", (Object)args[1]), new MessageData("sender", (Object)sender)});
            return;
        }
        CodexEngine.get().getMessageUtil().sendMessage("fusion.force.statsHeader", sender, new MessageData[]{new MessageData("player", (Object)target.getName())});
        CodexEngine.get().getMessageUtil().sendMessage("fusion.force.statsHeader", (CommandSender)target, new MessageData[]{new MessageData("player", (Object)target.getName())});
        for (Profession profession : PlayerLoader.getPlayer(target.getUniqueId()).getProfessions()) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.level.format", sender, new MessageData[]{new MessageData("category", (Object)profession.getName()), new MessageData("level", (Object)profession.getLevel()), new MessageData("experience", (Object)PlayerLoader.getPlayer(target.getUniqueId()).getExperience(profession))});
            CodexEngine.get().getMessageUtil().sendMessage("fusion.level.format", (CommandSender)target, new MessageData[]{new MessageData("category", (Object)profession.getName()), new MessageData("level", (Object)profession.getLevel()), new MessageData("experience", (Object)PlayerLoader.getPlayer(target.getUniqueId()).getExperience(profession))});
        }
    }

    public static void forceMaster(@NotNull CommandSender sender, String[] args) {
        if (!Fusion.getInstance().checkPermission(sender, "fusion.admin.force")) {
            return;
        }
        if (args.length < 3) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.force.invalidSyntax", sender, new MessageData[]{new MessageData("syntax", (Object)"/fusion forcemaster <player> <profession>")});
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            CodexEngine.get().getMessageUtil().sendMessage("notAPlayer", sender, new MessageData[]{new MessageData("name", (Object)args[1]), new MessageData("sender", (Object)sender)});
            return;
        }
        String professionName = args[2];
        CraftingTable table = ProfessionsCfg.getTable(professionName);
        if (table == null) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.notACrafting", sender, new MessageData[]{new MessageData("name", (Object)professionName), new MessageData("sender", (Object)sender)});
            return;
        }
        if (!PlayerLoader.getPlayer(target).hasProfession(table.getName())) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.force.doesNotHaveProfession", sender, new MessageData[]{new MessageData("player", (Object)target.getName()), new MessageData("profession", (Object)professionName)});
            return;
        }
        if (PlayerLoader.getPlayer(target.getUniqueId()).hasMastered(table.getName())) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.force.alreadyMastered", sender, new MessageData[]{new MessageData("player", (Object)target.getName()), new MessageData("profession", (Object)professionName)});
            return;
        }
        FusionAPI.getEventServices().getProfessionService().masterProfession(table.getName(), target, true);
        PlayerLoader.getPlayer(target.getUniqueId()).setMastered(table.getName(), true);
        CodexEngine.get().getMessageUtil().sendMessage("fusion.force.masterSuccess", sender, new MessageData[]{new MessageData("player", (Object)target.getName()), new MessageData("profession", (Object)professionName), new MessageData("sender", (Object)sender)});
    }

    public static void forceShow(@NotNull CommandSender sender, String[] args) {
        if (!Fusion.getInstance().checkPermission(sender, "fusion.admin.force")) {
            return;
        }
        if (args.length < 2) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.force.invalidSyntax", sender, new MessageData[]{new MessageData("syntax", (Object)"/fusion forceshow <player>")});
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            CodexEngine.get().getMessageUtil().sendMessage("notAPlayer", sender, new MessageData[]{new MessageData("name", (Object)args[1]), new MessageData("sender", (Object)sender)});
            return;
        }
        ItemStack item = target.getInventory().getItemInMainHand();
        if (item.getType().isAir()) {
            CodexEngine.get().getMessageUtil().sendMessage("fusion.force.noItemInHand", sender, new MessageData[]{new MessageData("player", (Object)target.getName())});
            return;
        }
        HashMap<Recipe, RecipeItem> recipeUsage = new HashMap<Recipe, RecipeItem>();
        for (CraftingTable table : ProfessionsCfg.getMap().values()) {
            for (Recipe recipe : table.getRecipes().values()) {
                for (RecipeItem ingredient : recipe.getConditions().getRequiredItems()) {
                    if (!CalculatedRecipe.isSimilar(ingredient.getItemStack(), item)) continue;
                    recipeUsage.put(recipe, ingredient);
                }
            }
        }
        new ShowRecipesGui(target, recipeUsage).open(target);
        CodexEngine.get().getMessageUtil().sendMessage("fusion.force.showSuccess", sender, new MessageData[]{new MessageData("player", (Object)target.getName()), new MessageData("sender", (Object)sender)});
    }
}

