/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.sql.SQLManager;
import studio.magemonkey.fusion.data.player.PlayerRecipeLimit;

public class FusionRecipeLimitsSQL {
    private final String Table = "fusion_limits";

    public FusionRecipeLimitsSQL() {
        try (PreparedStatement create = SQLManager.connection().prepareStatement("CREATE TABLE IF NOT EXISTS fusion_limits(Id long,UUID varchar(36), RecipePath varchar(100),Amount numeric,Timestamp BIGINT)");){
            create.execute();
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionRecipeLimitsSQL:FusionRecipeLimitsSQL] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getNextId() {
        try (PreparedStatement select = SQLManager.connection().prepareStatement("SELECT Count(Id) FROM fusion_limits");){
            ResultSet result = select.executeQuery();
            if (!result.next()) return 0L;
            long l = result.getLong(1);
            return l;
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionRecipeLimitsSQL:getNextId] Something went wrong with the sql-connection: " + e.getMessage());
        }
        return 0L;
    }

    public Map<String, PlayerRecipeLimit> getRecipeLimits(UUID uuid) {
        HashMap<String, PlayerRecipeLimit> limits = new HashMap<String, PlayerRecipeLimit>();
        try (PreparedStatement select = SQLManager.connection().prepareStatement("SELECT * FROM fusion_limits WHERE UUID = ?");){
            select.setString(1, uuid.toString());
            ResultSet result = select.executeQuery();
            while (result.next()) {
                String recipePath = result.getString("RecipePath");
                int amount = result.getInt("Amount");
                long timestamp = result.getLong("Timestamp");
                limits.put(recipePath, new PlayerRecipeLimit(recipePath, amount, timestamp));
            }
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionRecipeLimitsSQL:getRecipeLimits] Something went wrong with the sql-connection: " + e.getMessage());
        }
        return limits;
    }

    public void saveRecipeLimits(UUID uuid, Map<String, PlayerRecipeLimit> recipeLimits) {
        try (PreparedStatement delete = SQLManager.connection().prepareStatement("DELETE FROM fusion_limits WHERE UUID = ?");){
            delete.setString(1, uuid.toString());
            delete.execute();
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionRecipeLimitsSQL:saveRecipeLimits] Something went wrong with the sql-connection: " + e.getMessage());
        }
        try (PreparedStatement insert = SQLManager.connection().prepareStatement("INSERT INTO fusion_limits(Id, UUID, RecipePath, Amount, Timestamp) VALUES(?,?,?,?,?)");){
            for (Map.Entry<String, PlayerRecipeLimit> entry : recipeLimits.entrySet()) {
                if (entry.getValue().getLimit() <= 0) continue;
                insert.setLong(1, this.getNextId());
                insert.setString(2, uuid.toString());
                insert.setString(3, entry.getKey());
                insert.setInt(4, entry.getValue().getLimit());
                insert.setLong(5, entry.getValue().getCooldownTimestamp());
                insert.execute();
            }
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionRecipeLimitsSQL:saveRecipeLimits] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }
}

