/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.sql.SQLManager;

public class FusionPlayersSQL {
    private static final String Table = "fusion_players";

    public FusionPlayersSQL() {
        try (PreparedStatement create = SQLManager.connection().prepareStatement("CREATE TABLE IF NOT EXISTS fusion_players(UUID varchar(36), AutoCrafting boolean)");){
            create.execute();
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionPlayersSQL:FusionPlayersSQL] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    public void setAutoCrafting(UUID uuid, boolean autoCrafting) {
        this.addPlayer(uuid);
        try (PreparedStatement update = SQLManager.connection().prepareStatement("UPDATE fusion_players SET AutoCrafting=? WHERE UUID=?");){
            update.setBoolean(1, autoCrafting);
            update.setString(2, uuid.toString());
            update.execute();
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionPlayersSQL:setAutoCrafting] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    public void addPlayer(UUID uuid) {
        if (this.hasPlayer(uuid)) {
            return;
        }
        try (PreparedStatement insert = SQLManager.connection().prepareStatement("INSERT INTO fusion_players(UUID, AutoCrafting) VALUES(?,?)");){
            insert.setString(1, uuid.toString());
            insert.setBoolean(2, false);
            insert.execute();
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionPlayersSQL:addPlayer] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasPlayer(UUID uuid) {
        try (PreparedStatement select = SQLManager.connection().prepareStatement("SELECT * FROM fusion_players WHERE UUID=?");){
            select.setString(1, uuid.toString());
            ResultSet result = select.executeQuery();
            if (!result.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionPlayersSQL:hasPlayer] Something went wrong with the sql-connection: " + e.getMessage());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAutoCrafting(UUID uuid) {
        try (PreparedStatement select = SQLManager.connection().prepareStatement("SELECT AutoCrafting FROM fusion_players WHERE UUID=?");){
            select.setString(1, uuid.toString());
            ResultSet result = select.executeQuery();
            if (!result.next()) return false;
            boolean bl = result.getBoolean("AutoCrafting");
            return bl;
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionPlayersSQL:isAutoCrafting] Something went wrong with the sql-connection: " + e.getMessage());
        }
        return false;
    }
}

