/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.migrations;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.api.items.PrefixHelper;
import studio.magemonkey.fusion.Fusion;

public class ProfessionMigration {
    public static final String VERSION = "1.3";
    private static final Map<String, Function<FileConfiguration, Void>> migrations = new HashMap<String, Function<FileConfiguration, Void>>();

    private static boolean compareVersions(String version, String compareTo) {
        int aMajor = Integer.parseInt(version.split("\\.")[0]);
        int aMinor = Integer.parseInt(version.split("\\.")[1]);
        int bMajor = Integer.parseInt(compareTo.split("\\.")[0]);
        int bMinor = Integer.parseInt(compareTo.split("\\.")[1]);
        return aMajor < bMajor || aMajor == bMajor && aMinor < bMinor;
    }

    public static void migrate(FileConfiguration config, String toVersion) {
        String version = config.getString("version", "1.0");
        if (ProfessionMigration.compareVersions(version, toVersion)) {
            Fusion.getInstance().getLogger().info("Migrating profession data to version " + toVersion);
            for (Map.Entry<String, Function<FileConfiguration, Void>> entry : migrations.entrySet()) {
                if (!ProfessionMigration.compareVersions(version, entry.getKey())) continue;
                entry.getValue().apply(config);
            }
            config.set("version", (Object)toVersion);
        }
    }

    static String convertLegacyDivinityFormat(String oldItem) {
        String id;
        oldItem = PrefixHelper.stripPrefix((String)"DIVINITY", (String)oldItem);
        String[] parts = oldItem.split(":");
        String[] divinityParts = parts[0].split("_", 2);
        String module = null;
        if (divinityParts.length >= 2) {
            module = ProfessionMigration.mapModule(divinityParts[0]);
            id = divinityParts[1];
        } else {
            id = divinityParts[0];
        }
        String level = null;
        String amount = null;
        String material = null;
        int index = 1;
        if (module != null && !module.equals("custom_items") && parts.length > index) {
            level = parts[index++];
        }
        if (parts.length > index) {
            amount = parts[index++];
        }
        if (parts.length > index) {
            material = parts[index++];
        }
        StringBuilder builder = new StringBuilder("DIVINITY_");
        if (module != null) {
            builder.append(module).append(":");
        }
        builder.append(id);
        if (level != null) {
            builder.append("~level:").append(level);
        }
        if (material != null) {
            builder.append("~material:").append(material);
        }
        if (amount != null) {
            builder.append(":").append(amount);
        }
        return builder.toString();
    }

    private static String mapModule(@Nullable String module) {
        if (module == null) {
            return null;
        }
        return switch (module.toLowerCase()) {
            case "arrows", "ar" -> "arrows";
            case "consumables", "co" -> "consumables";
            case "customitems", "ci" -> "custom_items";
            case "dismantle", "di" -> "dismantle";
            case "essences", "es" -> "essences";
            case "extractor", "ex" -> "extractor";
            case "fortify", "fo" -> "fortify";
            case "gems", "ge" -> "gems";
            case "identify", "id" -> "identify";
            case "itemgenerator", "itemgen", "it" -> "item_generator";
            case "magicdust", "md" -> "magic_dust";
            case "runes", "ru" -> "runes";
            default -> null;
        };
    }

    public static void replaceSectionInConfig(FileConfiguration config, String oldSection, String newSection) {
        String yamlContent = config.saveToString();
        String regex = "(?m)^" + oldSection + ":";
        yamlContent = yamlContent.replaceAll(regex, newSection + ":");
        YamlConfiguration modifiedConfig = YamlConfiguration.loadConfiguration((Reader)new StringReader(yamlContent));
        config.getKeys(false).forEach(key -> config.set(key, null));
        modifiedConfig.getKeys(false).forEach(arg_0 -> ProfessionMigration.lambda$replaceSectionInConfig$1(config, (FileConfiguration)modifiedConfig, arg_0));
    }

    private static /* synthetic */ void lambda$replaceSectionInConfig$1(FileConfiguration config, FileConfiguration modifiedConfig, String key) {
        config.set(key, modifiedConfig.get(key));
    }

    static {
        migrations.put("1.1", config -> {
            String icon = config.getString("icon");
            if (icon != null && icon.startsWith("DIVINITY_")) {
                String newItem = ProfessionMigration.convertLegacyDivinityFormat(icon);
                config.set("icon", (Object)newItem);
            }
            List recipes = config.getMapList("recipes");
            for (Map recipe : recipes) {
                String newItem;
                String oldItem;
                List itemCosts;
                Map costs = (Map)recipe.get("costs");
                if (costs == null || (itemCosts = (List)costs.get("items")) == null) continue;
                for (Object itemCost : itemCosts) {
                    if (!(itemCost instanceof String) || !(oldItem = (String)itemCost).startsWith("DIVINITY_")) continue;
                    newItem = ProfessionMigration.convertLegacyDivinityFormat(oldItem);
                    itemCosts.set(itemCosts.indexOf(oldItem), newItem);
                }
                Map result = (Map)recipe.get("results");
                Object resultData = result.get("item");
                if (!(resultData instanceof String) || !(oldItem = (String)resultData).startsWith("DIVINITY_")) continue;
                newItem = ProfessionMigration.convertLegacyDivinityFormat(oldItem);
                result.put("item", newItem);
            }
            config.set("recipes", (Object)recipes);
            List categories = config.getMapList("categories");
            for (Map category : categories) {
                Map cat = category;
                String iconName = (String)cat.get("icon");
                if (iconName == null || !iconName.startsWith("DIVINITY_")) continue;
                String newItem = ProfessionMigration.convertLegacyDivinityFormat(iconName);
                cat.put("icon", newItem);
            }
            config.set("categories", (Object)categories);
            return null;
        });
        migrations.put("1.2", config -> {
            ProfessionMigration.replaceSectionInConfig(config, "pattern", "recipePattern");
            List recipes = config.getMapList("recipes");
            for (Map recipe : recipes) {
                LinkedHashMap<String, Object> settings = new LinkedHashMap<String, Object>();
                settings.put("enableLore", true);
                Map hiding = (Map)recipe.get("hiding");
                if (hiding != null) {
                    settings.put("hiding", hiding);
                }
                recipe.remove("hiding");
                recipe.put("settings", settings);
            }
            return null;
        });
        migrations.put(VERSION, config -> {
            List recipes = config.getMapList("recipes");
            for (Map recipe : recipes) {
                String namespace;
                Map results = (Map)recipe.get("results");
                LinkedHashMap settings = (LinkedHashMap)recipe.get("settings");
                if (results == null) continue;
                if (settings == null) {
                    settings = new LinkedHashMap();
                }
                if ((namespace = (String)results.get("item")) == null) continue;
                LinkedHashMap<String, Object> iconSettings = new LinkedHashMap<String, Object>();
                iconSettings.put("item", namespace);
                iconSettings.put("optionals", new LinkedHashMap());
                settings.put("icon", iconSettings);
                results.put("item", null);
                recipe.put("results", results);
                recipe.put("settings", settings);
            }
            return null;
        });
    }
}

