/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.migrations;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.cfg.sql.SQLManager;
import studio.magemonkey.fusion.data.professions.Profession;
import studio.magemonkey.fusion.data.queue.QueueItem;

public class PConfigManager {
    public static void backup() {
        File parentFolder = new File(String.valueOf(Fusion.getInstance().getDataFolder()) + File.separator + "players");
        if (!parentFolder.exists()) {
            return;
        }
        File backupFolder = new File(String.valueOf(Fusion.getInstance().getDataFolder()) + File.separator + "backup" + File.separator + "players");
        if (!backupFolder.exists()) {
            backupFolder.mkdirs();
        }
        for (File file : parentFolder.listFiles()) {
            if (!file.getName().endsWith(".yml")) continue;
            File backupFile = new File(backupFolder, file.getName());
            try {
                file.renameTo(backupFile);
            }
            catch (Exception e) {
                Fusion.getInstance().getLogger().warning("Can't backup player data file: " + String.valueOf(file));
                e.printStackTrace();
            }
        }
        Fusion.getInstance().getLogger().info("Backup of player data is done.");
    }

    public static void migrateIntoSQL() {
        File parentFolder = new File(String.valueOf(Fusion.getInstance().getDataFolder()) + File.separator + "players");
        if (!parentFolder.exists()) {
            return;
        }
        for (File file : parentFolder.listFiles()) {
            if (!file.getName().endsWith(".yml")) continue;
            YamlConfiguration cfg = new YamlConfiguration();
            try {
                cfg.load(file);
                UUID uuid = UUID.fromString(file.getName().replace(".yml", ""));
                boolean autoCraft = cfg.getBoolean("autoCraft", false);
                SQLManager.players().setAutoCrafting(uuid, autoCraft);
                HashMap<String, Boolean> professionData = new HashMap<String, Boolean>();
                if (cfg.contains("professions")) {
                    for (String profession : cfg.getStringList("professions")) {
                        professionData.put(profession, false);
                    }
                }
                if (cfg.contains("guis")) {
                    for (String profession : cfg.getConfigurationSection("guis").getKeys(false)) {
                        professionData.put(profession, cfg.getBoolean("guis." + profession));
                    }
                }
                List<Profession> professions = SQLManager.professions().getProfessions(uuid);
                List joinedProfessions = cfg.getStringList("professions");
                for (Profession profession : professions) {
                    if (!professionData.containsKey(profession.getName())) continue;
                    profession.setMastered((Boolean)professionData.get(profession.getName()));
                    profession.setJoined(joinedProfessions.contains(profession.getName()));
                    SQLManager.professions().setProfession(uuid, profession);
                    professionData.remove(profession.getName());
                }
                professionData.forEach((name, mastered) -> {
                    Profession profession = new Profession(-1L, uuid, (String)name, 0L, (boolean)mastered, joinedProfessions.contains(name));
                    SQLManager.professions().setProfession(uuid, profession);
                });
                if (cfg.contains("queues")) {
                    ArrayList<QueueItem> entries = new ArrayList<QueueItem>();
                    for (String profession : cfg.getConfigurationSection("queues").getKeys(false)) {
                        for (String category : cfg.getConfigurationSection("queues." + profession).getKeys(false)) {
                            for (String recipe : cfg.getConfigurationSection("queues." + profession + "." + category).getKeys(false)) {
                                List timestamps = cfg.getLongList("queues." + profession + "." + category + "." + recipe + ".timestamps");
                                Iterator iterator = timestamps.iterator();
                                while (iterator.hasNext()) {
                                    long timestamp = (Long)iterator.next();
                                    entries.add(new QueueItem(-1, profession, ProfessionsCfg.getTable(profession).getCategory(category), ProfessionsCfg.getTable(profession).getCategory(category).getRecipe(recipe), timestamp, -1));
                                }
                            }
                        }
                    }
                    entries.forEach(e -> SQLManager.queues().setQueueItem(uuid, (QueueItem)e));
                }
                Fusion.getInstance().getLogger().info("Migrated player data for " + String.valueOf(uuid) + " into SQL.");
            }
            catch (Exception e2) {
                Fusion.getInstance().getLogger().warning("Can't load player data file: " + String.valueOf(file));
                e2.printStackTrace();
                return;
            }
        }
        PConfigManager.backup();
        if (parentFolder.listFiles().length == 0) {
            parentFolder.delete();
            Fusion.getInstance().getLogger().info("Players folder is not required anymore and will be deleted.");
        }
    }
}

