/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.hooks.divinity;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.divinity.modules.list.itemgenerator.ItemGeneratorManager;
import studio.magemonkey.divinity.modules.list.itemgenerator.ResourceManager;
import studio.magemonkey.divinity.stats.tiers.Tier;
import studio.magemonkey.divinity.utils.ItemUtils;

public class DivinityUT {
    public static Set<String> getAllCombinations(ItemGeneratorManager.GeneratorItem item, Material material, Tier tier, int level) {
        String name = item.getName();
        String itemGroupName = ItemUtils.getItemGroupNameFor((ItemStack)new ItemStack(material));
        HashSet<String> names = new HashSet<String>();
        LinkedHashMap<ResourceManager.ResourceCategory, Set<String>> prefixes = new LinkedHashMap<ResourceManager.ResourceCategory, Set<String>>();
        LinkedHashMap<ResourceManager.ResourceCategory, Set<String>> suffixes = new LinkedHashMap<ResourceManager.ResourceCategory, Set<String>>();
        DivinityUT.populateAffixes(prefixes, suffixes, material, tier);
        DivinityUT.generatePrefixSuffixCombinations(names, name, itemGroupName, prefixes, suffixes);
        if (level > 0) {
            HashSet<String> newNames = new HashSet<String>();
            for (String n : names) {
                newNames.add(n.replace("%ITEM_LEVEL%", String.valueOf(level)));
            }
            names = newNames;
        }
        return names;
    }

    private static void populateAffixes(Map<ResourceManager.ResourceCategory, Set<String>> prefixes, Map<ResourceManager.ResourceCategory, Set<String>> suffixes, Material material, Tier tier) {
        prefixes.put(ResourceManager.ResourceCategory.TIER, new HashSet(ItemGeneratorManager.getMatchingTierPrefixes((Tier)tier)));
        prefixes.put(ResourceManager.ResourceCategory.MATERIAL, new HashSet(ItemGeneratorManager.getMatchingMaterialPrefixes((Material)material)));
        prefixes.put(ResourceManager.ResourceCategory.SUBTYPE, new HashSet(ItemGeneratorManager.getMatchingTypePrefixes((ItemStack)new ItemStack(material))));
        suffixes.put(ResourceManager.ResourceCategory.TIER, new HashSet(ItemGeneratorManager.getMatchingTierSuffixes((Tier)tier)));
        suffixes.put(ResourceManager.ResourceCategory.MATERIAL, new HashSet(ItemGeneratorManager.getMatchingMaterialSuffixes((Material)material)));
        suffixes.put(ResourceManager.ResourceCategory.SUBTYPE, new HashSet(ItemGeneratorManager.getMatchingTypeSuffixes((ItemStack)new ItemStack(material))));
    }

    private static void generatePrefixSuffixCombinations(Set<String> names, String name, String itemGroupName, Map<ResourceManager.ResourceCategory, Set<String>> prefixes, Map<ResourceManager.ResourceCategory, Set<String>> suffixes) {
        String baseName = name.replace("%item_type%", itemGroupName);
        Set<String> prefixCombinations = DivinityUT.generateCombinations(prefixes, baseName, true);
        for (String prefixName : prefixCombinations) {
            Set<String> suffixCombinations = DivinityUT.generateCombinations(suffixes, prefixName, false);
            if (suffixCombinations.isEmpty()) {
                names.add(DivinityUT.cleanupName(prefixName));
                continue;
            }
            suffixCombinations.forEach(suffixName -> names.add(DivinityUT.cleanupName(suffixName)));
        }
    }

    private static String cleanupName(String name) {
        return name.trim().replaceAll("\\s{2,}", " ").replace("%BASE_NAME% ", "");
    }

    private static Set<String> generateCombinations(Map<ResourceManager.ResourceCategory, Set<String>> affixes, String name, boolean isPrefix) {
        HashSet<String> combinations = new HashSet<String>();
        combinations.add(name.trim());
        for (Map.Entry<ResourceManager.ResourceCategory, Set<String>> entry : affixes.entrySet()) {
            String placeholder = DivinityUT.getPlaceholder(entry.getKey(), isPrefix);
            Set<String> values = entry.getValue();
            if (!values.isEmpty()) {
                HashSet<String> newCombinations = new HashSet<String>();
                for (String existingName : combinations) {
                    for (String value : values) {
                        newCombinations.add(existingName.replace(placeholder, value).trim());
                    }
                }
                combinations = newCombinations;
                continue;
            }
            HashSet<String> cleanedCombinations = new HashSet<String>();
            for (String existingName : combinations) {
                cleanedCombinations.add(existingName.replace(placeholder, "").trim());
            }
            combinations = cleanedCombinations;
        }
        return combinations;
    }

    private static String getPlaceholder(ResourceManager.ResourceCategory category, boolean isPrefix) {
        return switch (category) {
            default -> throw new IncompatibleClassChangeError();
            case ResourceManager.ResourceCategory.TIER -> {
                if (isPrefix) {
                    yield "%prefix_tier%";
                }
                yield "%suffix_tier%";
            }
            case ResourceManager.ResourceCategory.MATERIAL -> {
                if (isPrefix) {
                    yield "%prefix_material%";
                }
                yield "%suffix_material%";
            }
            case ResourceManager.ResourceCategory.SUBTYPE -> isPrefix ? "%prefix_type%" : "%suffix_type%";
        };
    }
}

