/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.editors.pattern;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.YamlParser;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.gui.editors.browse.BrowseEditor;
import studio.magemonkey.fusion.util.ChatUT;

public class PatternEditorCfg {
    private final YamlParser config = YamlParser.loadOrExtract((JavaPlugin)Fusion.getInstance(), "Editors/pattern/PatternEditor.yml");

    public String getTitle(String category) {
        String title = ChatUT.hexString(this.config.getString("title", "&2Pattern Simulation: $<category>"));
        title = title.replace(MessageUtil.getReplacement((String)"category"), category);
        return ChatUT.hexString(title);
    }

    public Map<String, ItemStack> getIcons(CraftingTable table) {
        HashMap<String, ItemStack> icons = new HashMap<String, ItemStack>();
        for (String icon : this.config.getConfigurationSection("icons").getKeys(false)) {
            if (icon.equalsIgnoreCase("patternItem")) continue;
            icons.put(icon, this.getIcon(table, icon));
        }
        return icons;
    }

    public Map<String, ItemStack> getIcons(BrowseEditor browseEditor) {
        HashMap<String, ItemStack> icons = new HashMap<String, ItemStack>();
        for (String icon : this.config.getConfigurationSection("icons").getKeys(false)) {
            if (icon.equalsIgnoreCase("patternItem")) continue;
            icons.put(icon, this.getIcon(browseEditor, icon));
        }
        return icons;
    }

    public ItemStack getIcon(CraftingTable table, String icon) {
        Material material = Material.valueOf((String)this.config.getString("icons." + icon + ".material", "STONE").toUpperCase());
        int amount = this.config.getInt("icons." + icon + ".amount", 1);
        int durability = this.config.getInt("icons." + icon + ".durability", 0);
        boolean unbreakable = this.config.getBoolean("icon." + icon + ".unbreakable", false);
        String name = this.config.getString("icons." + icon + ".name", "&cInvalid Item: &4" + icon);
        List<String> lore = this.config.getStringList("icons." + icon + ".lore");
        for (int i = 0; i < lore.size(); ++i) {
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"name"), table.getInventoryName()).replace(MessageUtil.getReplacement((String)"profession"), table.getName()).replace(MessageUtil.getReplacement((String)"masteryUnlock"), String.valueOf(table.getMasteryUnlock())).replace(MessageUtil.getReplacement((String)"masteryCost"), String.valueOf(table.getMasteryFee())).replace(MessageUtil.getReplacement((String)"useCategories"), String.valueOf(table.getUseCategories()))));
        }
        Map<Enchantment, Integer> enchants = this.config.getEnchantmentSection("icons." + icon + ".enchants");
        List<ItemFlag> flags = this.config.getItemFlags("icons." + icon + ".flags");
        ItemFlag[] itemFlags = flags.toArray(new ItemFlag[0]);
        return ItemBuilder.newItem((Material)material).amount(amount).durability(durability).unbreakable(unbreakable).name(ChatUT.hexString(name)).lore(lore).enchant(enchants).flag(itemFlags).build();
    }

    public ItemStack getIcon(BrowseEditor browseEditor, String icon) {
        Material material = Material.valueOf((String)this.config.getString("icons." + icon + ".material", "STONE").toUpperCase());
        int amount = this.config.getInt("icons." + icon + ".amount", 1);
        int durability = this.config.getInt("icons." + icon + ".durability", 0);
        boolean unbreakable = this.config.getBoolean("icon." + icon + ".unbreakable", false);
        String name = this.config.getString("icons." + icon + ".name", "&cInvalid Item: &4" + icon);
        List<String> lore = this.config.getStringList("icons." + icon + ".lore");
        for (int i = 0; i < lore.size(); ++i) {
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"name"), browseEditor.getName())));
        }
        Map<Enchantment, Integer> enchants = this.config.getEnchantmentSection("icons." + icon + ".enchants");
        List<ItemFlag> flags = this.config.getItemFlags("icons." + icon + ".flags");
        ItemFlag[] itemFlags = flags.toArray(new ItemFlag[0]);
        return ItemBuilder.newItem((Material)material).amount(amount).durability(durability).unbreakable(unbreakable).name(ChatUT.hexString(name)).lore(lore).enchant(enchants).flag(itemFlags).build();
    }

    public ItemStack getPatternItem(char c, ItemStack item) {
        String itemName = item.hasItemMeta() ? item.getItemMeta().getDisplayName() : item.getType().name();
        String name = this.config.getString("icons.patternItem.name", "&9$<id>").replace(MessageUtil.getReplacement((String)"id"), String.valueOf(c)).replace(MessageUtil.getReplacement((String)"pattern.name"), itemName);
        List<String> lore = this.config.getStringList("icons.patternItem.lore");
        for (int i = 0; i < lore.size(); ++i) {
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"pattern.lore"))) {
                lore.remove(i);
                if (item.getItemMeta() == null || item.getItemMeta().getLore() == null) continue;
                int newLines = 1;
                for (String line : item.getItemMeta().getLore()) {
                    lore.add(i - 1 + newLines, ChatUT.hexString(line));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"pattern.name"), itemName)).replace(MessageUtil.getReplacement((String)"id"), String.valueOf(c)));
        }
        return ItemBuilder.newItem((ItemStack)item).name(name).lore(lore).build();
    }
}

