/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.editors.browse;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.cfg.YamlParser;
import studio.magemonkey.fusion.data.professions.ProfessionConditions;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.data.recipes.RecipeItem;
import studio.magemonkey.fusion.gui.editors.browse.BrowseEditor;
import studio.magemonkey.fusion.util.ChatUT;
import studio.magemonkey.fusion.util.Utils;

public class BrowseProfessionCfg {
    private final YamlParser config = YamlParser.loadOrExtract((JavaPlugin)Fusion.getInstance(), "Editors/browse/BrowseProfessionEditor.yml");

    public String getTitle() {
        return ChatUT.hexString(this.config.getString("title", "&2Professions in browse gui"));
    }

    public Map<String, ItemStack> getIcons(BrowseEditor browseEditor) {
        HashMap<String, ItemStack> icons = new HashMap<String, ItemStack>();
        for (String icon : this.config.getConfigurationSection("icons").getKeys(false)) {
            if (icon.equalsIgnoreCase("professionItem")) continue;
            icons.put(icon, this.getIcon(browseEditor, icon));
        }
        return icons;
    }

    public ItemStack getIcon(BrowseEditor browseEditor, String icon) {
        Material material = Material.valueOf((String)this.config.getString("icons." + icon + ".material", "STONE").toUpperCase());
        int amount = this.config.getInt("icons." + icon + ".amount", 1);
        int durability = this.config.getInt("icons." + icon + ".durability", 0);
        boolean unbreakable = this.config.getBoolean("icon." + icon + ".unbreakable", false);
        String name = this.config.getString("icons." + icon + ".name", "&cInvalid Item: &4" + icon);
        List<String> lore = this.config.getStringList("icons." + icon + ".lore");
        lore.replaceAll(s -> ChatUT.hexString(s.replace(MessageUtil.getReplacement((String)"name"), browseEditor.getName())));
        Map<Enchantment, Integer> enchants = this.config.getEnchantmentSection("icons." + icon + ".enchants");
        List<ItemFlag> flags = this.config.getItemFlags("icons." + icon + ".flags");
        ItemFlag[] itemFlags = flags.toArray(new ItemFlag[0]);
        return ItemBuilder.newItem((Material)material).amount(amount).durability(durability).unbreakable(unbreakable).name(ChatUT.hexString(name)).lore(lore).enchant(enchants).flag(itemFlags).build();
    }

    public ItemStack getProfessionIcon(ProfessionConditions conditions) {
        CraftingTable table = ProfessionsCfg.getMap().get(conditions.getProfession());
        ItemStack result = table.getIconItem().create();
        String name = this.config.getString("icons.professionItem.name", "&9$<name>").replace(MessageUtil.getReplacement((String)"id"), conditions.getProfession()).replace(MessageUtil.getReplacement((String)"name"), table.getInventoryName());
        List<String> lore = this.config.getStringList("icons.professionItem.lore");
        for (int i = 0; i < lore.size(); ++i) {
            int newLines;
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"ingredients"))) {
                lore.remove(i);
                newLines = 1;
                for (RecipeItem recipeItem : conditions.getRequiredItems()) {
                    ItemStack patternItem = recipeItem.getItemStack();
                    String itemName = Utils.getItemName(patternItem);
                    lore.add(i - 1 + newLines, this.config.getString("icons.professionItem.ingredientPrefix", "&7- &2$<ingredient.amount>x &a$<ingredient.name>").replace(MessageUtil.getReplacement((String)"ingredient.name"), itemName).replace(MessageUtil.getReplacement((String)"ingredient.amount"), String.valueOf(recipeItem.getItemStack().getAmount())));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"conditions"))) {
                lore.remove(i);
                newLines = 1;
                for (Map.Entry entry : conditions.getFullConditions().entrySet()) {
                    for (Map.Entry condition : ((Map)entry.getValue()).entrySet()) {
                        lore.add(i - 1 + newLines, this.config.getString("icons.professionItem.conditionPrefix", "&7- &a$<condition>").replace(MessageUtil.getReplacement((String)"condition"), this.getIconConditionFormat((String)entry.getKey(), (String)condition.getKey(), (Integer)condition.getValue())));
                        ++newLines;
                    }
                }
                i += newLines;
                continue;
            }
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"id"), conditions.getProfession()).replace(MessageUtil.getReplacement((String)"name"), ProfessionsCfg.getMap().get(conditions.getProfession()).getInventoryName()).replace(MessageUtil.getReplacement((String)"costs.money"), String.valueOf(conditions.getMoneyCost())).replace(MessageUtil.getReplacement((String)"costs.exp"), String.valueOf(conditions.getExpCost())).replace(MessageUtil.getReplacement((String)"conditions.permission"), String.valueOf(conditions.getPermission()))));
        }
        return ItemBuilder.newItem((ItemStack)result).name(name).lore(lore).build();
    }

    private String getIconConditionFormat(String condition, String key, int value) {
        return this.config.getString("icons.professionItem.conditionFormatting." + condition, key + ": " + value).replace(MessageUtil.getReplacement((String)"condition.name"), key).replace(MessageUtil.getReplacement((String)"condition.amount"), String.valueOf(value));
    }

    public String getSubTitle(String profession) {
        return ChatUT.hexString(this.config.getString("subEditor.title", "&2Profession: &9$<profession>").replace(MessageUtil.getReplacement((String)"profession"), profession));
    }

    public Map<String, ItemStack> getSubIcons(ProfessionConditions conditions) {
        HashMap<String, ItemStack> icons = new HashMap<String, ItemStack>();
        for (String icon : this.config.getConfigurationSection("subEditor.icons").getKeys(false)) {
            if (icon.equalsIgnoreCase("recipeItem")) continue;
            icons.put(icon, this.getIcon(conditions, icon));
        }
        return icons;
    }

    public ItemStack getIcon(ProfessionConditions conditions, String icon) {
        Material material = Material.valueOf((String)this.config.getString("subEditor.icons." + icon + ".material", "STONE").toUpperCase());
        int amount = this.config.getInt("subEditor.icons." + icon + ".amount", 1);
        int durability = this.config.getInt("subEditor.icons." + icon + ".durability", 0);
        boolean unbreakable = this.config.getBoolean("subEditor.icon." + icon + ".unbreakable", false);
        String name = this.config.getString("subEditor.icons." + icon + ".name", "&cInvalid Item: &4" + icon);
        List<String> lore = this.config.getStringList("subEditor.icons." + icon + ".lore");
        for (int i = 0; i < lore.size(); ++i) {
            int newLines;
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"ingredients"))) {
                lore.remove(i);
                newLines = 1;
                for (RecipeItem recipeItem : conditions.getRequiredItems()) {
                    ItemStack patternItem = recipeItem.getItemStack();
                    String itemName = Utils.getItemName(patternItem);
                    lore.add(i - 1 + newLines, this.config.getString("subEditor.icons.ingredients.ingredientPrefix", "&7- &2$<ingredient.amount>x &a$<ingredient.name>").replace(MessageUtil.getReplacement((String)"ingredient.name"), itemName).replace(MessageUtil.getReplacement((String)"ingredient.amount"), String.valueOf(recipeItem.getItemStack().getAmount())));
                    ++newLines;
                }
                i += newLines;
                continue;
            }
            if (lore.get(i).contains(MessageUtil.getReplacement((String)"conditions"))) {
                lore.remove(i);
                newLines = 1;
                for (Map.Entry entry : conditions.getFullConditions().entrySet()) {
                    for (Map.Entry condition : ((Map)entry.getValue()).entrySet()) {
                        lore.add(i - 1 + newLines, this.config.getString("subEditor.icons.conditions.conditionPrefix", "&7- &a$<condition>").replace(MessageUtil.getReplacement((String)"condition"), this.getSubIconConditionFormat((String)entry.getKey(), (String)condition.getKey(), (Integer)condition.getValue())));
                        ++newLines;
                    }
                }
                i += newLines;
                continue;
            }
            lore.set(i, ChatUT.hexString(lore.get(i).replace(MessageUtil.getReplacement((String)"name"), conditions.getProfession()).replace(MessageUtil.getReplacement((String)"costs.money"), String.valueOf(conditions.getMoneyCost())).replace(MessageUtil.getReplacement((String)"costs.exp"), String.valueOf(conditions.getExpCost())).replace(MessageUtil.getReplacement((String)"conditions.permission"), String.valueOf(conditions.getPermission()))));
        }
        Map<Enchantment, Integer> enchants = this.config.getEnchantmentSection("subEditor.icons." + icon + ".enchants");
        List<ItemFlag> flags = this.config.getItemFlags("subEditor.icons." + icon + ".flags");
        ItemFlag[] itemFlags = flags.toArray(new ItemFlag[0]);
        return ItemBuilder.newItem((Material)material).amount(amount).durability(durability).unbreakable(unbreakable).name(ChatUT.hexString(name)).lore(lore).enchant(enchants).flag(itemFlags).build();
    }

    private String getSubIconConditionFormat(String condition, String key, int value) {
        return this.config.getString("subEditor.icons.conditions.conditionFormatting." + condition, key + ": " + value).replace(MessageUtil.getReplacement((String)"condition.name"), key).replace(MessageUtil.getReplacement((String)"condition.amount"), String.valueOf(value));
    }
}

