/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.editors;

import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.entity.Player;
import studio.magemonkey.fusion.cfg.BrowseConfig;
import studio.magemonkey.fusion.cfg.editors.browse.BrowseEditorCfg;
import studio.magemonkey.fusion.cfg.editors.browse.BrowseProfessionCfg;
import studio.magemonkey.fusion.cfg.editors.pattern.PatternEditorCfg;
import studio.magemonkey.fusion.cfg.editors.pattern.PatternItemEditorCfg;
import studio.magemonkey.fusion.cfg.editors.professions.CategoryEditorCfg;
import studio.magemonkey.fusion.cfg.editors.professions.ProfessionEditorCfg;
import studio.magemonkey.fusion.cfg.editors.professions.RecipeEditorCfg;
import studio.magemonkey.fusion.cfg.editors.professions.RecipeIconEditorCfg;
import studio.magemonkey.fusion.data.professions.pattern.InventoryPattern;
import studio.magemonkey.fusion.gui.editors.Editor;
import studio.magemonkey.fusion.gui.editors.browse.BrowseEditor;
import studio.magemonkey.fusion.gui.editors.professions.ProfessionEditor;

public class EditorRegistry {
    private static final Map<UUID, Editor> editors = new TreeMap<UUID, Editor>();
    private static ProfessionEditorCfg professionEditorCfg;
    private static BrowseEditorCfg browseEditorCfg;
    private static PatternItemEditorCfg patternItemEditorCfg;
    private static PatternEditorCfg patternEditorCfg;
    private static RecipeEditorCfg recipeEditorCfg;
    private static RecipeIconEditorCfg recipeIconEditorCfg;
    private static CategoryEditorCfg categoryEditorCfg;
    private static BrowseProfessionCfg browseProfessionCfg;

    public static void reload() {
        editors.clear();
        professionEditorCfg = new ProfessionEditorCfg();
        recipeEditorCfg = new RecipeEditorCfg();
        recipeIconEditorCfg = new RecipeIconEditorCfg();
        categoryEditorCfg = new CategoryEditorCfg();
        browseEditorCfg = new BrowseEditorCfg();
        browseProfessionCfg = new BrowseProfessionCfg();
        patternItemEditorCfg = new PatternItemEditorCfg();
        patternEditorCfg = new PatternEditorCfg();
    }

    public static Editor getProfessionEditor(Player player, String profession) {
        if (!editors.containsKey(player.getUniqueId()) && profession != null) {
            editors.put(player.getUniqueId(), new ProfessionEditor(player, profession));
        }
        return editors.get(player.getUniqueId());
    }

    public static Editor getBrowseEditor(Player player) {
        if (!editors.containsKey(player.getUniqueId())) {
            LinkedList<String> professions = new LinkedList<String>(BrowseConfig.getProfessions());
            editors.put(player.getUniqueId(), new BrowseEditor(player, BrowseConfig.getBrowseName(), professions, InventoryPattern.copy(BrowseConfig.getBrowsePattern())));
        }
        return editors.get(player.getUniqueId());
    }

    public static Editor getCurrentEditor(Player player) {
        return editors.get(player.getUniqueId());
    }

    public static void removeCurrentEditor(Player player) {
        editors.remove(player.getUniqueId());
    }

    @Generated
    public static ProfessionEditorCfg getProfessionEditorCfg() {
        return professionEditorCfg;
    }

    @Generated
    public static BrowseEditorCfg getBrowseEditorCfg() {
        return browseEditorCfg;
    }

    @Generated
    public static PatternItemEditorCfg getPatternItemEditorCfg() {
        return patternItemEditorCfg;
    }

    @Generated
    public static PatternEditorCfg getPatternEditorCfg() {
        return patternEditorCfg;
    }

    @Generated
    public static RecipeEditorCfg getRecipeEditorCfg() {
        return recipeEditorCfg;
    }

    @Generated
    public static RecipeIconEditorCfg getRecipeIconEditorCfg() {
        return recipeIconEditorCfg;
    }

    @Generated
    public static CategoryEditorCfg getCategoryEditorCfg() {
        return categoryEditorCfg;
    }

    @Generated
    public static BrowseProfessionCfg getBrowseProfessionCfg() {
        return browseProfessionCfg;
    }
}

