/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.util.messages.MessageUtil;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.data.professions.pattern.InventoryPattern;
import studio.magemonkey.fusion.data.recipes.Recipe;
import studio.magemonkey.fusion.data.recipes.RecipeItem;
import studio.magemonkey.fusion.util.ChatUT;
import studio.magemonkey.fusion.util.Utils;

public class ShowRecipesCfg {
    private static FileConfiguration config;
    private static File file;
    private static String name;
    private static ItemStack fillItem;
    private static InventoryPattern pattern;

    public static void load() {
        try {
            if (file == null || !file.exists()) {
                config = new YamlConfiguration();
                file = new File(Fusion.getInstance().getDataFolder(), "lang/ShowRecipes.yml");
                file.getParentFile().mkdirs();
                ShowRecipesCfg.setDefaults();
                if (!file.exists()) {
                    file.createNewFile();
                    config.options().copyDefaults(true);
                    config.save(file);
                    Fusion.getInstance().log.info("Created default browse.yml");
                }
            }
            config = YamlConfiguration.loadConfiguration((File)file);
            ShowRecipesCfg.setDefaults();
            ShowRecipesCfg.readData();
            Fusion.getInstance().log.info("Successfully loaded browse.yml data");
        }
        catch (IOException e) {
            Fusion.getInstance().log.severe("Could not load browse.yml data: " + e.getMessage());
        }
    }

    private static void setDefaults() {
        config.addDefault("name", (Object)"&8Recipes for ingredient: &a&7<ingredient>");
        HashMap<Character, ItemStack> showItems = new HashMap<Character, ItemStack>();
        showItems.put(Character.valueOf('0'), ItemBuilder.newItem((Material)Material.BIRCH_SIGN).name("&8Possible Recipes").insertLoreLine(0, String.valueOf(ChatColor.GRAY) + "Your ingredient can be used").insertLoreLine(1, String.valueOf(ChatColor.GRAY) + "in the following recipes.").build());
        showItems.put(Character.valueOf('1'), ItemBuilder.newItem((Material)Material.GRAY_STAINED_GLASS_PANE).name(" ").build());
        showItems.put(Character.valueOf('<'), ItemBuilder.newItem((Material)Material.ARROW).name("&7Previous Page").build());
        showItems.put(Character.valueOf('>'), ItemBuilder.newItem((Material)Material.ARROW).name("&7Next Page").build());
        showItems.put(Character.valueOf('o'), ItemBuilder.newItem((Material)Material.LIGHT_GRAY_STAINED_GLASS_PANE).name(" ").build());
        InventoryPattern showPattern = new InventoryPattern(new String[]{"111101111", "ooooooooo", "ooooooooo", "ooooooooo", "111111111"}, showItems);
        config.addDefault("pattern", showPattern.serialize());
        HashMap<String, Object> recipeItem = new HashMap<String, Object>();
        recipeItem.put("material", "$<material>");
        recipeItem.put("name", "&7<name>");
        recipeItem.put("lore", new String[]{"&8[&a$<amount>x &7<ingredient>&8]", "&7Click to navigate to recipe"});
        config.addDefault("recipeItem", recipeItem);
        config.addDefault("fillItem", (Object)ItemBuilder.newItem((Material)Material.BLACK_STAINED_GLASS_PANE).name(" ").build());
    }

    private static void readData() {
        name = config.getString("name");
        fillItem = config.getItemStack("fillItem", ItemBuilder.newItem((Material)Material.BLACK_STAINED_GLASS_PANE).name(" ").build());
        pattern = new InventoryPattern(config.getConfigurationSection("pattern").getValues(false));
    }

    public static ItemStack getRecipeIcon(Recipe recipe, RecipeItem ingredient) {
        String itemName = Utils.getItemName(recipe.getSettings().getRecipeItem().getItemStack());
        String name = ChatUT.hexString(config.getString("recipeItem.name", "&7$<name>").replace(MessageUtil.getReplacement((String)"name"), itemName));
        List lore = config.getStringList("recipeItem.lore");
        lore.replaceAll(s -> ChatUT.hexString(s.replace(MessageUtil.getReplacement((String)"ingredient"), Utils.getItemName(ingredient.getItemStack())).replace(MessageUtil.getReplacement((String)"profession"), recipe.getTable().getInventoryName()).replace(MessageUtil.getReplacement((String)"amount"), String.valueOf(ingredient.getAmount())).replace(MessageUtil.getReplacement((String)"name"), name)));
        ItemStack icon = recipe.getSettings().getRecipeItem().getItemStack().clone();
        ItemMeta meta = icon.getItemMeta();
        meta.setDisplayName(name);
        meta.setLore(lore);
        icon.setItemMeta(meta);
        return icon;
    }

    public static String getInventoryName(RecipeItem ingredient) {
        return ChatUT.hexString(name.replace(MessageUtil.getReplacement((String)"ingredient"), Utils.getItemName(ingredient.getItemStack())));
    }

    @Generated
    public static String getName() {
        return name;
    }

    @Generated
    public static void setName(String name) {
        ShowRecipesCfg.name = name;
    }

    @Generated
    public static ItemStack getFillItem() {
        return fillItem;
    }

    @Generated
    public static void setFillItem(ItemStack fillItem) {
        ShowRecipesCfg.fillItem = fillItem;
    }

    @Generated
    public static InventoryPattern getPattern() {
        return pattern;
    }

    @Generated
    public static void setPattern(InventoryPattern pattern) {
        ShowRecipesCfg.pattern = pattern;
    }

    static {
        name = String.valueOf(ChatColor.DARK_AQUA) + "Browse";
    }
}

