/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.api.events.services;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.DelayedCommand;
import studio.magemonkey.codex.api.Replacer;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.api.FusionAPI;
import studio.magemonkey.fusion.api.events.QueueItemAddedEvent;
import studio.magemonkey.fusion.api.events.QueueItemFinishedEvent;
import studio.magemonkey.fusion.api.events.QueueItemRemovedEvent;
import studio.magemonkey.fusion.cfg.sql.SQLManager;
import studio.magemonkey.fusion.data.queue.CraftingQueue;
import studio.magemonkey.fusion.data.queue.QueueItem;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.data.recipes.RecipeItem;
import studio.magemonkey.fusion.util.PlayerUtil;

public class QueueService {
    public void addQueueItem(Player player, CraftingTable table, CraftingQueue queue, QueueItem item) {
        QueueItemAddedEvent event = new QueueItemAddedEvent(table.getName(), player, queue, item);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            item.setCraftinQueue(event.getQueue());
            event.getQueue().getQueue().add(item);
        }
    }

    public void cancelQueueItem(Player player, CraftingTable table, CraftingQueue queue, QueueItem item, boolean finished, boolean refunded, List<ItemStack> refundItems) {
        QueueItemRemovedEvent event = new QueueItemRemovedEvent(table.getName(), player, queue, item, finished, refunded, refundItems);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            if (event.isRefunded()) {
                CodexEngine.get().getVault().give((OfflinePlayer)event.getPlayer(), item.getRecipe().getConditions().getMoneyCost());
                List<ItemStack> refunds = event.getRefundedItems();
                for (ItemStack refundItem : refunds) {
                    if (refundItem.getMaxStackSize() < refundItem.getAmount()) {
                        for (int i = 0; i < refundItem.getAmount(); ++i) {
                            ItemStack singleItem = refundItem.clone();
                            singleItem.setAmount(1);
                            Collection notAdded = player.getInventory().addItem(new ItemStack[]{singleItem}).values();
                            if (notAdded.isEmpty()) continue;
                            for (ItemStack _item : notAdded) {
                                Objects.requireNonNull(player.getLocation().getWorld()).dropItemNaturally(player.getLocation(), _item);
                            }
                        }
                        continue;
                    }
                    Collection notAdded = player.getInventory().addItem(new ItemStack[]{refundItem}).values();
                    if (notAdded.isEmpty()) continue;
                    for (ItemStack _item : notAdded) {
                        Objects.requireNonNull(player.getLocation().getWorld()).dropItemNaturally(player.getLocation(), _item);
                    }
                }
            }
            event.getQueue().getQueue().remove(item);
            for (Map.Entry<Integer, QueueItem> entry : event.getQueue().getQueuedItems().entrySet()) {
                if (!entry.getValue().equals(item)) continue;
                event.getQueue().getQueuedItems().remove(entry.getKey());
                break;
            }
            if (!SQLManager.queues().removeQueueItem(item)) {
                Fusion.getInstance().getLogger().warning("Failed to remove queue item from SQL");
            }
        }
    }

    public void finishQueueItem(Player player, CraftingTable table, CraftingQueue queue, QueueItem item, List<RecipeItem> resultItems) {
        QueueItemFinishedEvent event = new QueueItemFinishedEvent(table.getName(), player, queue, item, resultItems);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            long professionExp;
            if (event.getFusionPlayer().hasRecipeLimitReached(event.getQueueItem().getRecipe())) {
                this.cancelQueueItem(player, table, queue, item, false, true, event.getQueueItem().getRecipe().getItemsToTake());
                event.setCancelled(true);
                CodexEngine.get().getMessageUtil().sendMessage("fusion.error.recipeLimitReached", (CommandSender)player, new MessageData[]{new MessageData("recipe", (Object)event.getQueueItem().getRecipe().getName()), new MessageData("amount", (Object)event.getFusionPlayer().getRecipeLimit(event.getQueueItem().getRecipe()).getLimit()), new MessageData("recipe.limit", (Object)event.getQueueItem().getRecipe().getCraftingLimit()), new MessageData("limit", (Object)event.getQueueItem().getRecipe().getCraftingLimit())});
                return;
            }
            if (!item.getRecipe().getResults().hasCommandsOrItems()) {
                ItemStack result = event.getQueueItem().getRecipe().getDivinityRecipeMeta() == null ? event.getQueueItem().getRecipe().getSettings().getRecipeItem().getItemStack() : event.getQueueItem().getRecipe().getDivinityRecipeMeta().generateItem();
                Collection notAdded = player.getInventory().addItem(new ItemStack[]{result}).values();
                if (!notAdded.isEmpty()) {
                    for (ItemStack _item2 : notAdded) {
                        Objects.requireNonNull(player.getLocation().getWorld()).dropItemNaturally(player.getLocation(), _item2);
                    }
                }
            } else {
                if (!item.getRecipe().getResults().getCommands().isEmpty()) {
                    DelayedCommand.invoke((Plugin)Fusion.getInstance(), (CommandSender)player, item.getRecipe().getResults().getCommands(), (Replacer[])new Replacer[0]);
                }
                if (!item.getRecipe().getResults().getItems().isEmpty()) {
                    for (RecipeItem resultItem : resultItems) {
                        Collection remainings;
                        ItemStack itemStack = resultItem.getItemStack();
                        if (itemStack == null || (remainings = player.getInventory().addItem(new ItemStack[]{itemStack}).values()).isEmpty()) continue;
                        remainings.forEach(_item -> player.getWorld().dropItemNaturally(player.getLocation(), _item));
                    }
                }
            }
            if ((professionExp = item.getRecipe().getResults().getProfessionExp() + (long)((double)item.getRecipe().getResults().getProfessionExp() * PlayerUtil.getProfessionExpBonusThroughPermissions(player, table.getName()))) > 0L) {
                FusionAPI.getEventServices().getProfessionService().giveProfessionExp(player, event.getCraftingTable(), professionExp);
            }
            if (item.getRecipe().getResults().getVanillaExp() > 0) {
                player.giveExp(event.getQueueItem().getRecipe().getResults().getVanillaExp());
            }
            if (event.getQueueItem().getRecipe().getCraftingLimit() > 0) {
                event.getFusionPlayer().incrementLimit(event.getQueueItem().getRecipe());
            }
            event.getQueue().removeRecipe(event.getQueueItem(), false);
        }
    }
}

