/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.ChatColor;

public class ChatUT {
    private static final MiniMessage minimessage = MiniMessage.builder().build();
    private static final LegacyComponentSerializer serializer = LegacyComponentSerializer.legacyAmpersand();

    public static String serialize(Component component) {
        if (component == null) {
            return " ";
        }
        return serializer.serialize(component);
    }

    public static Component deserialize(String component) {
        return ChatUT.hexComp(component);
    }

    public static String hexString(String message) {
        Pattern pattern = Pattern.compile("&#[a-fA-F0-9]{6}");
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            String hexCode = message.substring(matcher.start(), matcher.end());
            String replaceSharp = hexCode.replace("&", "").replace('#', 'x');
            char[] ch = replaceSharp.toCharArray();
            StringBuilder builder = new StringBuilder();
            for (char c : ch) {
                builder.append("&" + c);
            }
            message = message.replace(hexCode, builder.toString());
            matcher = pattern.matcher(message);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static Component hexComp(String message) {
        message = message.replace("\u00a7", "&");
        message = ChatUT.parseHexColorCodes(message);
        message = ChatUT.parseNativeColorCodes(message);
        return minimessage.deserialize((Object)message);
    }

    private static String parseHexColorCodes(String message) {
        Pattern pattern = Pattern.compile("&#[a-fA-F0-9]{6}");
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            String hexCode = message.substring(matcher.start(), matcher.end());
            String replaceSharp = hexCode.replace("&", "");
            message = message.replace(hexCode, "<color:" + replaceSharp + ">");
            matcher = pattern.matcher(message);
        }
        return message;
    }

    private static String parseNativeColorCodes(String message) {
        Pattern pattern = Pattern.compile("&[a-flmnokrA-F0-9]");
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            String colorCode = message.substring(matcher.start(), matcher.end());
            String replaceSharp = colorCode.replace("&", "");
            message = message.replace(colorCode, ChatUT.getNativeColor(replaceSharp.toCharArray()[0]));
            matcher = pattern.matcher(message);
        }
        return message;
    }

    public static Component fixColor(String message, String key, String value) {
        if (message.split(key).length == 0) {
            return ChatUT.hexComp(value);
        }
        String colorMsg = message.split(key)[0];
        String color = colorMsg.substring(colorMsg.length() - 2);
        if (color.trim().isEmpty()) {
            return ChatUT.hexComp(value);
        }
        if (color.charAt(0) == '&') {
            return ChatUT.hexComp(color + value);
        }
        return ChatUT.hexComp(value);
    }

    private static String getNativeColor(char color) {
        String reset = "<!b><!i><!obf><!u><!st>";
        Object colorCode = "<color:white>";
        if (color == 'r') {
            return reset + (String)colorCode;
        }
        switch (color) {
            case 'a': {
                colorCode = "<color:green>";
                break;
            }
            case 'b': {
                colorCode = "<color:aqua>";
                break;
            }
            case 'c': {
                colorCode = "<color:red>";
                break;
            }
            case 'd': {
                colorCode = "<color:light_purple>";
                break;
            }
            case 'e': {
                colorCode = "<color:yellow>";
                break;
            }
            case 'f': {
                colorCode = "<color:white>";
                break;
            }
            case '0': {
                colorCode = "<color:black>";
                break;
            }
            case '1': {
                colorCode = "<color:dark_blue>";
                break;
            }
            case '2': {
                colorCode = "<color:dark_green>";
                break;
            }
            case '3': {
                colorCode = "<color:dark_aqua>";
                break;
            }
            case '4': {
                colorCode = "<color:dark_red>";
                break;
            }
            case '5': {
                colorCode = "<color:dark_purple>";
                break;
            }
            case '6': {
                colorCode = "<color:gold>";
                break;
            }
            case '7': {
                colorCode = "<color:gray>";
                break;
            }
            case '8': {
                colorCode = "<color:dark_gray>";
                break;
            }
            case '9': {
                colorCode = "<color:blue>";
                break;
            }
            case 'l': {
                colorCode = "<bold>";
                break;
            }
            case 'm': {
                colorCode = "<strikethrough>";
                break;
            }
            case 'n': {
                colorCode = "<u>";
                break;
            }
            case 'o': {
                colorCode = "<italic>";
                break;
            }
            case 'k': {
                colorCode = "<obf>";
            }
        }
        switch (color) {
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': {
                break;
            }
            default: {
                colorCode = reset + (String)colorCode;
            }
        }
        return colorCode;
    }
}

