/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.slot;

import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import studio.magemonkey.codex.CodexEngine;

public abstract class Slot {
    public static final Slot BASE_CONTAINER_SLOT = new Slot(InventoryType.SlotType.CONTAINER){

        @Override
        public ItemStack canHoldItem(ItemStack item) {
            return item;
        }
    };
    public static final Slot BASE_HOTBAR_SLOT = new Slot(InventoryType.SlotType.QUICKBAR){

        @Override
        public ItemStack canHoldItem(ItemStack item) {
            return item;
        }
    };
    public static final Slot BASE_CRAFTING_SLOT = new Slot(InventoryType.SlotType.CRAFTING){

        @Override
        public ItemStack canHoldItem(ItemStack item) {
            return item;
        }
    };
    public static final Slot SPECIAL_CRAFTING_SLOT = new Slot(InventoryType.SlotType.CRAFTING){

        @Override
        public ItemStack canHoldItem(ItemStack item) {
            if (item == null || item.getType() == Material.AIR) {
                return null;
            }
            return CodexEngine.get().getItemManager().getItemTypes(item).isEmpty() ? null : item;
        }
    };
    public static final Slot BASE_RESULT_SLOT = new Slot(InventoryType.SlotType.RESULT){

        @Override
        public ItemStack canHoldItem(ItemStack item) {
            return null;
        }
    };
    public static final Slot BLOCKED_SLOT = new Slot(InventoryType.SlotType.CONTAINER){

        @Override
        public ItemStack canHoldItem(ItemStack item) {
            return null;
        }
    };
    public static final Slot QUEUED_SLOT = new Slot(InventoryType.SlotType.RESULT){

        @Override
        public ItemStack canHoldItem(ItemStack item) {
            return null;
        }
    };
    public static final Slot BASE_OUTSIDE_SLOT = new Slot(InventoryType.SlotType.OUTSIDE){

        @Override
        public ItemStack canHoldItem(ItemStack item) {
            return item;
        }
    };
    protected final InventoryType.SlotType slotType;

    public Slot(InventoryType.SlotType slotType) {
        this.slotType = slotType;
    }

    public abstract ItemStack canHoldItem(ItemStack var1);

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append("slotType", (Object)this.slotType).toString();
    }

    @Generated
    public InventoryType.SlotType getSlotType() {
        return this.slotType;
    }
}

