/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.show;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.DelayedCommand;
import studio.magemonkey.codex.api.Replacer;
import studio.magemonkey.codex.util.ItemUtils;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.cfg.ShowRecipesCfg;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.data.recipes.Recipe;
import studio.magemonkey.fusion.data.recipes.RecipeItem;
import studio.magemonkey.fusion.gui.slot.Slot;

public class ShowRecipesGui
implements Listener {
    private final Player player;
    private final Map<Recipe, RecipeItem> recipes;
    private final Map<Integer, Recipe> recipeSlots = new HashMap<Integer, Recipe>();
    private Inventory inventory;
    private Slot[] slots;
    private final ArrayList<Integer> resultSlots = new ArrayList(20);
    private final ArrayList<Integer> blockedSlots = new ArrayList(20);
    private int page = 0;
    private int nextPage;
    private int prevPage;

    public ShowRecipesGui(Player player, Map<Recipe, RecipeItem> recipes) {
        this.player = player;
        this.recipes = recipes;
        this.initialize();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Fusion.getInstance());
    }

    public void initialize() {
        this.resultSlots.clear();
        this.inventory = Bukkit.createInventory(null, (int)ShowRecipesCfg.getPattern().getInventorySize(), (String)ShowRecipesCfg.getInventoryName(this.recipes.values().stream().toList().get(0)));
        this.mapSlots();
        this.reloadRecipes();
    }

    public void reloadRecipes() {
        if (!this.player.isOnline()) {
            return;
        }
        try {
            int k;
            int slot;
            Integer[] slots;
            int pages;
            ItemStack fill = ShowRecipesCfg.getFillItem();
            int pageSize = this.resultSlots.size();
            int allRecipesCount = this.recipes.size();
            int i = 0;
            int page = this.page;
            int fullPages = allRecipesCount / pageSize;
            int rest = allRecipesCount % pageSize;
            int n = pages = rest == 0 ? fullPages : fullPages + 1;
            if (this.player.isOnline() && page >= pages) {
                if (page > 0) {
                    this.page = pages - 1;
                }
                if (this.page != page) {
                    this.reloadRecipes();
                }
                return;
            }
            Recipe[] allRecipesArray = this.recipes.keySet().toArray(new Recipe[allRecipesCount]);
            Integer[] integerArray = slots = this.resultSlots.toArray(new Integer[0]);
            int n2 = integerArray.length;
            for (int j = 0; j < n2; ++j) {
                slot = integerArray[j];
                this.inventory.setItem(slot, null);
            }
            this.updateBlockedSlots(new MessageData[]{new MessageData("gui", (Object)ShowRecipesCfg.getInventoryName(this.recipes.values().stream().toList().get(0))), new MessageData("player", (Object)this.player.getName()), new MessageData("bal", (Object)(CodexEngine.get().getVault() == null ? 0.0 : CodexEngine.get().getVault().getBalance((OfflinePlayer)this.player)))});
            int e = Math.min(slots.length, allRecipesArray.length);
            for (k = page * pageSize; k < allRecipesArray.length && i < e; ++k, ++i) {
                Recipe recipe = allRecipesArray[k];
                slot = slots[i];
                this.recipeSlots.put(slot, recipe);
                this.inventory.setItem(slot, ShowRecipesCfg.getRecipeIcon(recipe, this.recipes.get(recipe)));
            }
            for (k = 0; k < this.inventory.getSize(); ++k) {
                if (this.inventory.getItem(k) != null && this.inventory.getItem(k).getType() != Material.AIR) continue;
                this.inventory.setItem(k, fill);
            }
        }
        catch (Exception e) {
            this.inventory.clear();
            this.player.closeInventory();
            throw new RuntimeException("Exception was thrown when reloading categories for: " + this.player.getName(), e);
        }
    }

    public void reloadRecipesTask() {
        Bukkit.getScheduler().runTaskLater((Plugin)Fusion.getInstance(), this::reloadRecipes, 1L);
    }

    public void updateBlockedSlots(MessageData[] data) {
        int totalItems = this.recipes.size();
        int fullPages = totalItems / this.resultSlots.size();
        int rest = totalItems % this.resultSlots.size();
        int pages = rest == 0 ? fullPages : fullPages + 1;
        boolean includeBack = false;
        int k = -1;
        HashMap<Character, ItemStack> items = ShowRecipesCfg.getPattern().getItems();
        ArrayList<Integer> leaveBlank = new ArrayList<Integer>();
        ArrayList<Integer> fill = new ArrayList<Integer>();
        for (String row : ShowRecipesCfg.getPattern().getPattern()) {
            for (char c : row.toCharArray()) {
                ++k;
                ItemStack item = ItemUtils.replaceText((ItemStack)items.get(Character.valueOf(c)), (MessageData[])data);
                if (!includeBack && c == '<' && this.page <= 0) {
                    leaveBlank.add(k);
                    continue;
                }
                if (c == '>' && this.page + 1 >= pages) {
                    leaveBlank.add(k);
                    continue;
                }
                if (c == '{' || c == '}' || c == '-') {
                    fill.add(k);
                    continue;
                }
                if (item == null) continue;
                this.inventory.setItem(k, item.clone());
            }
        }
        for (Integer index : leaveBlank) {
            if (this.inventory.getSize() > index + 1) {
                this.inventory.setItem(index.intValue(), this.inventory.getItem(index + 1));
                continue;
            }
            this.inventory.setItem(index.intValue(), this.inventory.getItem(index - 1));
        }
        for (Integer index : fill) {
            this.inventory.setItem(index.intValue(), ShowRecipesCfg.getFillItem());
        }
    }

    private void mapSlots() {
        this.resultSlots.clear();
        this.slots = new Slot[ShowRecipesCfg.getPattern().getPattern().length * 9];
        int k = -1;
        int prevPage = -1;
        int nextPage = -1;
        for (String row : ShowRecipesCfg.getPattern().getPattern()) {
            block7: for (char c : row.toCharArray()) {
                ++k;
                switch (c) {
                    case '=': 
                    case 'o': {
                        this.slots[k] = Slot.BASE_RESULT_SLOT;
                        this.resultSlots.add(k);
                        continue block7;
                    }
                    case '>': {
                        this.slots[k] = Slot.BLOCKED_SLOT;
                        nextPage = k;
                        continue block7;
                    }
                    case '<': {
                        this.slots[k] = Slot.BLOCKED_SLOT;
                        prevPage = k;
                        continue block7;
                    }
                    case '-': 
                    case '{': 
                    case '}': {
                        continue block7;
                    }
                    default: {
                        this.slots[k] = Slot.BLOCKED_SLOT;
                        this.blockedSlots.add(k);
                    }
                }
            }
        }
        this.nextPage = nextPage;
        this.prevPage = prevPage;
    }

    private boolean validatePageCount() {
        int pages;
        if (this.page <= 0) {
            this.reloadRecipesTask();
            return false;
        }
        int pageSize = this.resultSlots.size();
        int fullCount = this.recipes.size();
        int page = this.page;
        int fullPages = fullCount / pageSize;
        int rest = fullCount % pageSize;
        int n = pages = rest == 0 ? fullPages : fullPages + 1;
        if (page >= pages) {
            this.page = pages;
            this.reloadRecipesTask();
            return false;
        }
        return true;
    }

    private void prevPage() {
        if (this.page <= 0) {
            this.player.closeInventory();
            return;
        }
        --this.page;
        if (this.validatePageCount()) {
            Bukkit.getConsoleSender().sendMessage("[-] Validated: " + this.page);
            this.reloadRecipesTask();
        }
    }

    private void nextPage() {
        ++this.page;
        if (this.validatePageCount()) {
            Bukkit.getConsoleSender().sendMessage("[+] Validated: " + this.page);
            this.reloadRecipesTask();
        }
    }

    public void open(Player player) {
        player.openInventory(this.inventory);
    }

    public void executeCommands(Character c, HumanEntity player) {
        List<DelayedCommand> patternCommands = ShowRecipesCfg.getPattern().getCommands(c.charValue());
        if (patternCommands != null && !patternCommands.isEmpty()) {
            DelayedCommand.invoke((Plugin)Fusion.getInstance(), (CommandSender)player, patternCommands, (Replacer[])new Replacer[0]);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (event.getInventory() != this.getInventory()) {
            return;
        }
        event.setCancelled(true);
        event.setResult(Event.Result.DENY);
        Player player = (Player)event.getWhoClicked();
        int slot = event.getSlot();
        if (slot < 0) {
            return;
        }
        Character c = ShowRecipesCfg.getPattern().getSlot(slot);
        this.executeCommands(c, event.getWhoClicked());
        if (ShowRecipesCfg.getPattern().getCloseOnClickSlots().contains(c)) {
            Bukkit.getScheduler().runTask((Plugin)Fusion.getInstance(), () -> event.getWhoClicked().closeInventory());
        }
        if (this.nextPage != -1 && event.getSlot() == this.nextPage) {
            this.nextPage();
            return;
        }
        if (this.prevPage != -1 && event.getSlot() == this.prevPage) {
            this.prevPage();
            return;
        }
        if (this.recipeSlots.containsKey(slot)) {
            Recipe recipe = this.recipeSlots.get(slot);
            CraftingTable table = recipe.getTable();
            ProfessionsCfg.getGuiMap().get(table.getName()).open(player, table.getCategory(recipe.getCategory()));
        }
    }

    @Generated
    public Inventory getInventory() {
        return this.inventory;
    }

    @Generated
    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }
}

