/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.recipe;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryFingerprint {
    public static byte[] fingerprint(Player p) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (ItemStack is : p.getInventory().getContents()) {
                Damageable dmeta;
                Object nameBytes;
                if (is == null || is.getType() == Material.AIR) {
                    md.update((byte)0);
                    continue;
                }
                ItemMeta im = is.getItemMeta();
                md.update((byte)is.getType().ordinal());
                if (im != null && im.hasDisplayName()) {
                    nameBytes = im.getDisplayName().getBytes(StandardCharsets.UTF_8);
                    md.update((byte[])nameBytes);
                }
                if (im != null && im.hasLore()) {
                    nameBytes = Objects.requireNonNull(im.getLore()).iterator();
                    while (nameBytes.hasNext()) {
                        String line = (String)nameBytes.next();
                        byte[] lineBytes = line.getBytes(StandardCharsets.UTF_8);
                        md.update(lineBytes);
                    }
                }
                if (im != null && im.hasEnchants()) {
                    im.getEnchants().forEach((ench, lvl) -> {
                        md.update(ByteBuffer.allocate(4).putInt(ench.getKey().hashCode()).array());
                        md.update(ByteBuffer.allocate(4).putInt((int)lvl).array());
                    });
                }
                if (im == null) continue;
                if (im.isUnbreakable()) {
                    md.update((byte)1);
                }
                if (!(im instanceof Damageable) || (dmeta = (Damageable)im).getDamage() <= 0) continue;
                md.update(ByteBuffer.allocate(4).putInt(dmeta.getDamage()).array());
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            int h = 7;
            for (ItemStack is : p.getInventory().getContents()) {
                h = h * 31 + (is == null ? 0 : is.hashCode());
            }
            return ByteBuffer.allocate(4).putInt(h).array();
        }
    }
}

