/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.editors.pattern;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.editors.EditorRegistry;
import studio.magemonkey.fusion.data.professions.pattern.InventoryPattern;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.gui.editors.Editor;
import studio.magemonkey.fusion.gui.editors.browse.BrowseEditor;

public class PatternEditor
extends Editor
implements Listener {
    private final Player player;
    private InventoryPattern pattern;
    private final CraftingTable table;
    private final boolean isCategoryPattern;
    private final BrowseEditor browseEditor;
    private final Map<Integer, Character> slots = new HashMap<Integer, Character>();

    public PatternEditor(Editor parentEditor, Player player, CraftingTable table, boolean isCategoryPattern) {
        super(parentEditor, EditorRegistry.getPatternEditorCfg().getTitle(isCategoryPattern ? "Category" : "Master"), isCategoryPattern && table.getCatPattern() != null ? table.getCatPattern().getInventorySize() : table.getRecipePattern().getInventorySize());
        this.player = player;
        this.table = table;
        this.isCategoryPattern = isCategoryPattern;
        this.browseEditor = null;
        this.setIcons(EditorRegistry.getPatternEditorCfg().getIcons(table));
        InventoryPattern inventoryPattern = this.pattern = isCategoryPattern ? table.getCatPattern() : table.getRecipePattern();
        if (isCategoryPattern && this.pattern == null) {
            table.setCatPattern(InventoryPattern.copy(table.getRecipePattern()));
            this.pattern = table.getCatPattern();
            CodexEngine.get().getMessageUtil().sendMessage("editor.defaultCategoryPattern", (CommandSender)player, new MessageData[0]);
        }
        this.initialize();
        Fusion.registerListener(this);
    }

    public PatternEditor(BrowseEditor browseEditor, Player player) {
        super(browseEditor, EditorRegistry.getPatternEditorCfg().getTitle("Browse"), browseEditor.getBrowsePattern().getInventorySize());
        this.player = player;
        this.browseEditor = browseEditor;
        this.table = null;
        this.isCategoryPattern = false;
        this.setIcons(EditorRegistry.getPatternEditorCfg().getIcons(browseEditor));
        this.pattern = browseEditor.getBrowsePattern();
        this.initialize();
        Fusion.registerListener(this);
    }

    public void initialize() {
        this.slots.clear();
        int i = 0;
        for (String key : this.pattern.getPattern()) {
            for (char c : key.toCharArray()) {
                this.slots.put(i, Character.valueOf(c));
                if (c == 'o') {
                    if (this.table != null) {
                        this.setItem(i, this.getIcons().get("recipeSlot"));
                    } else if (this.browseEditor != null) {
                        this.setItem(i, this.getIcons().get("browseSlot"));
                    }
                    ++i;
                    continue;
                }
                if (this.pattern.getItems().get(Character.valueOf(c)) != null && !this.pattern.getItems().get(Character.valueOf(c)).getType().isAir()) {
                    this.setItem(i, EditorRegistry.getPatternEditorCfg().getPatternItem(c, this.pattern.getItems().get(Character.valueOf(c))));
                }
                ++i;
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory() != this.getInventory()) {
            return;
        }
        event.setCancelled(true);
        boolean hasChanges = false;
        if (event.getClickedInventory() == this.getInventory()) {
            event.setCancelled(true);
            int slot = event.getSlot();
            if (this.slots.containsKey(slot)) {
                if (event.isLeftClick()) {
                    char cycled = this.pattern.getCycledCharacter(this.pattern.getSlot(slot).charValue(), true).charValue();
                    this.pattern.replaceSlot(event.getSlot(), cycled);
                    hasChanges = true;
                } else if (event.isRightClick()) {
                    char cycled = this.pattern.getCycledCharacter(this.pattern.getSlot(slot).charValue(), false).charValue();
                    this.pattern.replaceSlot(event.getSlot(), cycled);
                    hasChanges = true;
                }
            }
        }
        if (hasChanges) {
            if (this.table != null) {
                this.setIcons(EditorRegistry.getPatternEditorCfg().getIcons(this.table));
            } else {
                this.setIcons(EditorRegistry.getPatternEditorCfg().getIcons(this.browseEditor));
            }
            this.initialize();
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory() != this.getInventory()) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Fusion.getInstance(), () -> this.openParent(this.player), 1L);
    }
}

