/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.editors.browse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.cfg.editors.EditorCriteria;
import studio.magemonkey.fusion.cfg.editors.EditorRegistry;
import studio.magemonkey.fusion.commands.FusionEditorCommand;
import studio.magemonkey.fusion.data.professions.ProfessionConditions;
import studio.magemonkey.fusion.gui.editors.Editor;
import studio.magemonkey.fusion.gui.editors.browse.BrowseEditor;
import studio.magemonkey.fusion.gui.editors.browse.BrowseProfessionEditor;
import studio.magemonkey.fusion.util.InventoryUtils;

public class BrowseProfessionsEditor
extends Editor
implements Listener {
    private final Player player;
    private final BrowseEditor browseEditor;
    private BrowseProfessionEditor browseProfessionEditor;
    private final HashMap<Inventory, HashMap<Integer, ProfessionConditions>> slots = new HashMap();

    public BrowseProfessionsEditor(BrowseEditor browseEditor, Player player) {
        super(browseEditor, EditorRegistry.getBrowseProfessionCfg().getTitle(), 54);
        this.player = player;
        this.browseEditor = browseEditor;
        this.setIcons(EditorRegistry.getBrowseProfessionCfg().getIcons(browseEditor));
        this.initialize();
        Fusion.registerListener(this);
    }

    public void initialize() {
        this.slots.clear();
        this.getNestedInventories().clear();
        HashMap<Integer, ProfessionConditions> invSlots = new HashMap<Integer, ProfessionConditions>();
        ArrayList<Inventory> inventories = new ArrayList<Inventory>();
        Inventory inv = null;
        int invSlot = 0;
        Collection<ProfessionConditions> professions = this.browseEditor.getProfessionConditions().values();
        for (ProfessionConditions entry : professions) {
            if (!ProfessionsCfg.getMap().containsKey(entry.getProfession())) {
                Fusion.getInstance().getLogger().warning("Profession " + entry.getProfession() + " not found for BrowseEditor. You might want to remove it from browse.yml to avoid problems.");
                Fusion.getInstance().getLogger().warning("Skipping profession: " + entry.getProfession());
                continue;
            }
            int invDex = invSlot % 36 + 9;
            if (invDex == 9) {
                if (inv != null) {
                    inventories.add(inv);
                }
                inv = InventoryUtils.createFilledInventory(null, EditorRegistry.getBrowseProfessionCfg().getTitle(), 54, this.getIcons().get("fill"));
                inv.setItem(4, this.getIcons().get("add"));
                inv.setItem(48, this.getIcons().get("previous"));
                inv.setItem(50, this.getIcons().get("next"));
                inv.setItem(53, this.getIcons().get("back"));
                invSlots = new HashMap();
            }
            inv.setItem(invDex, EditorRegistry.getBrowseProfessionCfg().getProfessionIcon(entry));
            invSlots.put(invDex, entry);
            this.slots.put(inv, invSlots);
            ++invSlot;
        }
        if (inv == null) {
            inv = InventoryUtils.createFilledInventory(null, EditorRegistry.getBrowseProfessionCfg().getTitle(), 54, this.getIcons().get("fill"));
            inv.setItem(4, this.getIcons().get("add"));
            inv.setItem(48, this.getIcons().get("previous"));
            inv.setItem(50, this.getIcons().get("next"));
            inv.setItem(53, this.getIcons().get("back"));
        }
        inventories.add(inv);
        this.setNestedInventories(inventories);
    }

    @Override
    public void open(Player player) {
        this.open(player, 0);
    }

    public void open(Player player, int page) {
        player.openInventory(this.getNestedInventories().get(page) != null ? this.getNestedInventories().get(page) : this.getNestedInventories().get(page - 1));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int invdex = this.getNestedInventories().indexOf(event.getInventory());
        if (invdex < 0) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        int slot = event.getSlot();
        int size = this.getNestedInventories().size();
        boolean hasChanges = false;
        switch (event.getSlot()) {
            case 4: {
                FusionEditorCommand.suggestUsage(player, EditorCriteria.Browse_Add_Profession, "/fusion-editor ");
                break;
            }
            case 48: {
                this.open(player, (size + invdex - 1) % size);
                break;
            }
            case 50: {
                this.open(player, (invdex + 1) % size);
                break;
            }
            case 53: {
                this.openParent(player);
                break;
            }
            default: {
                if (!this.slots.containsKey(this.getNestedInventories().get(invdex)) || !this.slots.get(this.getNestedInventories().get(invdex)).containsKey(slot)) break;
                ProfessionConditions entry = this.slots.get(this.getNestedInventories().get(invdex)).get(slot);
                if (!event.isShiftClick()) {
                    if (event.isLeftClick()) {
                        this.browseProfessionEditor = new BrowseProfessionEditor((Editor)this, player, entry);
                        this.browseProfessionEditor.open(player);
                        break;
                    }
                    if (!event.isRightClick()) break;
                    this.browseEditor.getProfessions().remove(entry.getProfession());
                    this.browseEditor.getProfessionConditions().remove(entry.getProfession());
                    hasChanges = true;
                    break;
                }
                ProfessionConditions conditions = this.browseEditor.getProfessionConditions().get(entry.getProfession());
                if (event.isLeftClick()) {
                    this.browseEditor.moveEntry(conditions, -1);
                    hasChanges = true;
                    break;
                }
                if (!event.isRightClick()) break;
                this.browseEditor.moveEntry(conditions, 1);
                hasChanges = true;
            }
        }
        if (hasChanges) {
            this.reload(true);
        }
    }

    public void reload(boolean open) {
        this.setIcons(EditorRegistry.getBrowseProfessionCfg().getIcons(this.browseEditor));
        this.initialize();
        if (open) {
            this.open(this.player);
        }
    }

    @Generated
    public BrowseProfessionEditor getBrowseProfessionEditor() {
        return this.browseProfessionEditor;
    }
}

