/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.editors.browse;

import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.editors.EditorCriteria;
import studio.magemonkey.fusion.cfg.editors.EditorRegistry;
import studio.magemonkey.fusion.commands.FusionEditorCommand;
import studio.magemonkey.fusion.data.professions.ProfessionConditions;
import studio.magemonkey.fusion.gui.editors.Editor;
import studio.magemonkey.fusion.gui.editors.browse.BrowseProfessionsEditor;
import studio.magemonkey.fusion.util.InventoryUtils;

public class BrowseProfessionEditor
extends Editor
implements Listener {
    private final Player player;
    private ProfessionConditions conditions;

    public BrowseProfessionEditor(Editor editor, Player player, ProfessionConditions conditions) {
        super(editor, EditorRegistry.getBrowseProfessionCfg().getSubTitle(conditions.getProfession()), 36);
        this.player = player;
        this.conditions = conditions;
        this.setIcons(EditorRegistry.getBrowseProfessionCfg().getSubIcons(conditions));
        this.initialize();
        Fusion.registerListener(this);
    }

    private void initialize() {
        InventoryUtils.fillInventory(this.getInventory(), this.getIcons().get("fill"));
        this.setItem(11, this.getIcons().get("moneyCost"));
        this.setItem(13, this.getIcons().get("expCost"));
        this.setItem(21, this.getIcons().get("ingredients"));
        this.setItem(23, this.getIcons().get("conditions"));
        this.setItem(35, this.getIcons().get("back"));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory() != this.getInventory()) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        boolean hasChanges = false;
        switch (event.getSlot()) {
            case 11: {
                int amount;
                int n = amount = event.isShiftClick() ? 10 : 1;
                if (event.isLeftClick()) {
                    this.conditions.setMoneyCost(this.conditions.getMoneyCost() + (double)amount);
                    hasChanges = true;
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.conditions.getMoneyCost() == 0.0) {
                    return;
                }
                this.conditions.setMoneyCost(Math.max(this.conditions.getMoneyCost() - (double)amount, 0.0));
                hasChanges = true;
                break;
            }
            case 13: {
                int amount;
                int n = amount = event.isShiftClick() ? 10 : 1;
                if (event.isLeftClick()) {
                    this.conditions.setExpCost(this.conditions.getExpCost() + amount);
                    hasChanges = true;
                    break;
                }
                if (!event.isRightClick()) break;
                if (this.conditions.getExpCost() == 0) {
                    return;
                }
                this.conditions.setExpCost(Math.max(this.conditions.getExpCost() - amount, 0));
                hasChanges = true;
                break;
            }
            case 21: {
                FusionEditorCommand.suggestUsage(player, EditorCriteria.Browse_Profession_Add_Ingredients, "/fusion-editor <ingredient> <amount>");
                break;
            }
            case 23: {
                FusionEditorCommand.suggestUsage(player, EditorCriteria.Browse_Profession_Add_Conditions, "/fusion-editor <conditionKey> <conditionValue> <level>");
                break;
            }
            case 35: {
                this.reload(false);
                ((BrowseProfessionsEditor)this.getParentEditor()).reload(true);
            }
        }
        if (hasChanges) {
            this.reload(true);
        }
    }

    public void reload(boolean open) {
        this.setIcons(EditorRegistry.getBrowseProfessionCfg().getSubIcons(this.conditions));
        this.initialize();
        if (open) {
            this.open(this.player);
        }
    }

    @Generated
    public ProfessionConditions getConditions() {
        return this.conditions;
    }
}

