/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui.editors.browse;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.BrowseConfig;
import studio.magemonkey.fusion.cfg.editors.EditorCriteria;
import studio.magemonkey.fusion.cfg.editors.EditorRegistry;
import studio.magemonkey.fusion.commands.FusionEditorCommand;
import studio.magemonkey.fusion.data.professions.ProfessionConditions;
import studio.magemonkey.fusion.data.professions.pattern.InventoryPattern;
import studio.magemonkey.fusion.gui.editors.Editor;
import studio.magemonkey.fusion.gui.editors.browse.BrowseProfessionsEditor;
import studio.magemonkey.fusion.gui.editors.pattern.PatternEditor;
import studio.magemonkey.fusion.gui.editors.pattern.PatternItemsEditor;
import studio.magemonkey.fusion.util.InventoryUtils;

public class BrowseEditor
extends Editor
implements Listener {
    private final Player player;
    private String name;
    private final LinkedList<String> professions = new LinkedList();
    private final LinkedHashMap<String, ProfessionConditions> professionConditions = new LinkedHashMap();
    private final InventoryPattern browsePattern;
    private PatternItemsEditor patternItemsEditor;
    private PatternEditor patternEditor;
    private BrowseProfessionsEditor browseProfessionsEditor;

    public BrowseEditor(Player player, String name, LinkedList<String> professions, InventoryPattern browsePattern) {
        super(null, EditorRegistry.getBrowseEditorCfg().getTitle(), 27);
        this.player = player;
        this.name = name;
        this.professions.addAll(professions);
        for (String profession : BrowseConfig.getProfessions()) {
            this.professionConditions.put(profession, ProfessionConditions.copy(BrowseConfig.getProfessionConditions().get(profession)));
        }
        this.browsePattern = InventoryPattern.copy(browsePattern);
        this.setIcons(EditorRegistry.getBrowseEditorCfg().getIcons(this));
        this.initialize();
        Fusion.registerListener(this);
    }

    private void initialize() {
        InventoryUtils.fillInventory(this.getInventory(), this.getIcons().get("fill"));
        this.setItem(10, this.getIcons().get("name"));
        this.setItem(12, this.getIcons().get("patternItems"));
        this.setItem(13, this.getIcons().get("pattern"));
        this.setItem(16, this.getIcons().get("professions"));
        this.setItem(18, this.getIcons().get("save"));
        this.setItem(26, this.getIcons().get("back"));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory() != this.getInventory()) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        boolean hasChanges = false;
        switch (event.getSlot()) {
            case 10: {
                FusionEditorCommand.suggestUsage(player, EditorCriteria.Browse_Edit_Name, "/fusion-editor <newName>");
                break;
            }
            case 12: {
                if (this.patternItemsEditor == null) {
                    this.patternItemsEditor = new PatternItemsEditor(this, player);
                }
                this.patternItemsEditor.open(player);
                break;
            }
            case 13: {
                if (this.patternEditor == null) {
                    this.patternEditor = new PatternEditor(this, player);
                }
                this.patternEditor.open(player);
                break;
            }
            case 16: {
                if (this.browseProfessionsEditor == null) {
                    this.browseProfessionsEditor = new BrowseProfessionsEditor(this, player);
                }
                this.browseProfessionsEditor.open(player);
                break;
            }
            case 18: {
                player.closeInventory();
                BrowseConfig.save(this);
                CodexEngine.get().getMessageUtil().sendMessage("editor.changesSaved", (CommandSender)player, new MessageData[]{new MessageData("file", (Object)"browse.yml")});
                EditorRegistry.removeCurrentEditor(player);
                FusionEditorCommand.removeEditorCriteria(player.getUniqueId());
                BrowseConfig.load();
                break;
            }
            case 26: {
                player.closeInventory();
                this.reload(false);
            }
        }
        if (hasChanges) {
            this.reload(true);
        }
    }

    public void reload(boolean open) {
        this.setIcons(EditorRegistry.getBrowseEditorCfg().getIcons(this));
        this.initialize();
        if (open) {
            this.open(this.player);
        }
    }

    public void moveEntry(ProfessionConditions conditions, int offset) {
        if (offset != -1 && offset != 1) {
            throw new IllegalArgumentException("Offset must be -1 or 1");
        }
        ArrayList<Map.Entry<String, ProfessionConditions>> entries = new ArrayList<Map.Entry<String, ProfessionConditions>>(this.professionConditions.entrySet());
        int index = -1;
        for (int i = 0; i < entries.size(); ++i) {
            if (!((String)((Map.Entry)entries.get(i)).getKey()).equals(conditions.getProfession())) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        int newIndex = index + offset;
        if (newIndex < 0 || newIndex >= entries.size()) {
            return;
        }
        Map.Entry entry = (Map.Entry)entries.remove(index);
        entries.add(newIndex, entry);
        this.professionConditions.clear();
        this.professions.clear();
        for (Map.Entry entry2 : entries) {
            this.professions.add((String)entry2.getKey());
            this.professionConditions.put((String)entry2.getKey(), (ProfessionConditions)entry2.getValue());
        }
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public LinkedList<String> getProfessions() {
        return this.professions;
    }

    @Generated
    public InventoryPattern getBrowsePattern() {
        return this.browsePattern;
    }

    @Generated
    public PatternItemsEditor getPatternItemsEditor() {
        return this.patternItemsEditor;
    }

    @Generated
    public PatternEditor getPatternEditor() {
        return this.patternEditor;
    }

    @Generated
    public BrowseProfessionsEditor getBrowseProfessionsEditor() {
        return this.browseProfessionsEditor;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public LinkedHashMap<String, ProfessionConditions> getProfessionConditions() {
        return this.professionConditions;
    }
}

