/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.util.messages.MessageData;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.api.FusionAPI;
import studio.magemonkey.fusion.cfg.BrowseConfig;
import studio.magemonkey.fusion.cfg.Cfg;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.data.player.FusionPlayer;
import studio.magemonkey.fusion.data.player.PlayerLoader;
import studio.magemonkey.fusion.data.professions.CalculatedProfession;
import studio.magemonkey.fusion.data.professions.ProfessionConditions;
import studio.magemonkey.fusion.data.recipes.CalculatedRecipe;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.data.recipes.RecipeItem;
import studio.magemonkey.fusion.gui.ProfessionGuiRegistry;
import studio.magemonkey.fusion.gui.slot.Slot;
import studio.magemonkey.fusion.util.ChatUT;
import studio.magemonkey.fusion.util.PlayerUtil;
import studio.magemonkey.fusion.util.Utils;

public class BrowseGUI
implements Listener {
    private static final HashMap<UUID, BrowseGUI> map = new HashMap();
    private Inventory inventory;
    private final Map<Integer, String> slotMap = new HashMap<Integer, String>();
    private final Map<Integer, CalculatedProfession> calculatedProfessionMap = new HashMap<Integer, CalculatedProfession>();
    protected final String inventoryName;
    private final Player player;
    private final ArrayList<Integer> slots = new ArrayList();
    private final ItemStack fillItem;

    public BrowseGUI(String inventoryName, Player player, ItemStack fill) {
        this.inventoryName = inventoryName;
        this.player = player;
        if (fill == null) {
            fill = BrowseConfig.getBrowseFill();
        }
        this.fillItem = fill;
        this.initialize();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)Fusion.getInstance());
    }

    public static BrowseGUI open(Player player) {
        BrowseGUI gui = map.get(player.getUniqueId());
        if (gui == null) {
            gui = new BrowseGUI(BrowseConfig.getBrowseName(), player, null);
        } else {
            player.openInventory(gui.inventory);
        }
        return gui;
    }

    /*
     * WARNING - void declaration
     */
    private void initialize() {
        map.remove(this.player.getUniqueId());
        int phSlot = -1;
        for (String row : BrowseConfig.getBrowsePattern().getPattern()) {
            for (char c : row.toCharArray()) {
                ++phSlot;
                switch (c) {
                    case '=': 
                    case 'o': {
                        this.slots.add(phSlot);
                    }
                }
            }
        }
        this.inventory = null;
        String title = ChatColor.translateAlternateColorCodes((char)'&', (String)BrowseConfig.getBrowseName());
        try {
            void var9_17;
            this.inventory = Bukkit.createInventory((InventoryHolder)this.player, (int)(BrowseConfig.getBrowsePattern().getPattern().length * 9), (String)title);
            int i = 0;
            int k = this.slots.get(i);
            HashMap<Character, ItemStack> specItems = BrowseConfig.getBrowsePattern().getItems();
            int slot = 0;
            String[] stringArray = BrowseConfig.getBrowsePattern().getPattern();
            int n = stringArray.length;
            boolean bl = false;
            while (var9_17 < n) {
                String pat = stringArray[var9_17];
                for (char c : pat.toCharArray()) {
                    if (specItems.containsKey(Character.valueOf(c))) {
                        this.inventory.setItem(slot, specItems.get(Character.valueOf(c)));
                    }
                    ++slot;
                }
                ++var9_17;
            }
            for (String profession : BrowseConfig.getProfessions()) {
                if (i >= this.slots.size()) break;
                CraftingTable craftingTable = ProfessionsCfg.getTable(profession);
                if (craftingTable == null || !Utils.hasCraftingUsePermission((Permissible)this.player, craftingTable.getName().toLowerCase())) continue;
                Collection<ItemStack> playerItems = PlayerUtil.getPlayerItems((InventoryHolder)this.player);
                CalculatedProfession calculatedProfession = CalculatedProfession.create(BrowseConfig.getProfessionConditions(craftingTable.getName()), playerItems, this.player, craftingTable);
                this.calculatedProfessionMap.put(k, calculatedProfession);
                ItemStack item = Cfg.showRequirementsOnBrowse ? calculatedProfession.getIcon() : (craftingTable.getIconItem() != null ? craftingTable.getIconItem().create() : ItemBuilder.newItem((Material)Material.BEDROCK).name(String.valueOf(ChatColor.RED) + craftingTable.getName()).newLoreLine(String.valueOf(ChatColor.RED) + "Missing icon in config.").newLoreLine(String.valueOf(ChatColor.RED) + "Add 'icon: econ-item' under the profession.").build());
                ItemMeta meta = item.getItemMeta();
                if (meta != null) {
                    meta.setDisplayName(ChatUT.hexString(craftingTable.getInventoryName()));
                }
                item.setItemMeta(meta);
                this.inventory.setItem(k, item);
                this.slotMap.put(k, craftingTable.getName());
                k = this.slots.get(++i);
            }
            for (int j = i; j < this.slots.size(); ++j) {
                this.inventory.setItem(this.slots.get(j).intValue(), this.fillItem);
            }
            map.put(this.player.getUniqueId(), this);
            this.player.openInventory(this.inventory);
        }
        catch (Exception e) {
            if (this.inventory != null) {
                this.inventory.clear();
            }
            map.remove(this.player.getUniqueId());
            this.player.closeInventory();
            throw new RuntimeException("Exception was thrown on gui open for: " + this.player.getName(), e);
        }
    }

    public static void joinProfession(Player player, ProfessionGuiRegistry gui) {
        if (gui == null) {
            return;
        }
        String profession = gui.getProfession();
        FusionPlayer fusionPlayer = PlayerLoader.getPlayer(player.getUniqueId());
        ProfessionConditions conditions = BrowseConfig.getProfessionConditions(profession);
        if (conditions == null) {
            player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.profNotAvailable", (CommandSender)player, new MessageData[]{new MessageData("profession", (Object)profession)});
            return;
        }
        if (!conditions.isValid(fusionPlayer)) {
            return;
        }
        double moneyCost = conditions.getMoneyCost();
        int expCost = conditions.getExpCost();
        ArrayList<ItemStack> itemsToTake = new ArrayList<ItemStack>(conditions.getRequiredItems().stream().map(RecipeItem::getItemStack).toList());
        ArrayList<ItemStack> taken = new ArrayList<ItemStack>(itemsToTake.size());
        PlayerInventory inventory = player.getInventory();
        Iterator iterator = itemsToTake.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack;
            HashMap notAdded;
            HashMap notRemoved;
            ItemStack toTake = (ItemStack)iterator.next();
            for (ItemStack entry : PlayerUtil.getPlayerItems((InventoryHolder)player)) {
                ItemStack item = entry.clone();
                entry = entry.clone();
                if (!item.hasItemMeta() || !Objects.requireNonNull(item.getItemMeta()).hasLore()) continue;
                item = item.clone();
                entry.setAmount(toTake.getAmount());
                if (!CalculatedRecipe.isSimilar(toTake, item)) continue;
                toTake = entry;
                break;
            }
            if ((notRemoved = inventory.removeItem(new ItemStack[]{toTake})).isEmpty()) {
                taken.add(toTake);
                iterator.remove();
                continue;
            }
            Iterator iterator2 = taken.iterator();
            while (iterator2.hasNext() && !(notAdded = inventory.addItem(new ItemStack[]{itemStack = (ItemStack)iterator2.next()})).isEmpty()) {
                for (ItemStack stack : notAdded.values()) {
                    player.getWorld().dropItemNaturally(player.getLocation(), stack);
                }
            }
            break block0;
        }
        if (!itemsToTake.isEmpty()) {
            player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_PLACE, 1.0f, 1.0f);
            CodexEngine.get().getMessageUtil().sendMessage("fusion.error.insufficientItems", (CommandSender)player, new MessageData[]{new MessageData("profession", (Object)profession)});
            return;
        }
        FusionAPI.getEventServices().getProfessionService().joinProfession(profession, player, moneyCost, expCost);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onClick(InventoryClickEvent e) {
        Inventory clickedInv = e.getClickedInventory();
        if (clickedInv == null) {
            return;
        }
        if (!clickedInv.equals((Object)this.inventory)) {
            return;
        }
        if (e.getRawSlot() < 0) {
            return;
        }
        Player p = (Player)e.getWhoClicked();
        e.setCancelled(true);
        ProfessionGuiRegistry gui = ProfessionsCfg.getGUI(this.slotMap.get(e.getRawSlot()));
        BrowseGUI.joinProfession(p, gui);
    }

    @EventHandler(ignoreCancelled=true)
    public void onDrag(InventoryDragEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        if (e.getInventory().equals((Object)this.inventory)) {
            if (e.getOldCursor().getType() == Material.BARRIER) {
                e.setCancelled(true);
            }
            if (e.getRawSlots().stream().anyMatch(this.slots::contains)) {
                e.setResult(Event.Result.DENY);
                return;
            }
            if (e.getNewItems().values().stream().anyMatch(i -> Slot.SPECIAL_CRAFTING_SLOT.canHoldItem((ItemStack)i) == null)) {
                e.setResult(Event.Result.DENY);
            }
        }
    }

    @EventHandler
    public void drop(PlayerDropItemEvent event) {
        ItemStack stack;
        Player player = event.getPlayer();
        if (this.inventory.getViewers().contains(player) && (stack = event.getItemDrop().getItemStack()).getType() == Material.BARRIER) {
            event.getItemDrop().remove();
            if (player.getOpenInventory().getCursor() == null || player.getOpenInventory().getCursor().getType() == Material.AIR) {
                player.getOpenInventory().setCursor(stack);
            }
        }
    }

    @EventHandler
    public void close(InventoryCloseEvent event) {
        if (event.getInventory().equals((Object)this.inventory)) {
            map.remove(event.getPlayer().getUniqueId());
        }
    }

    public static void closeAll() {
        for (UUID id : map.keySet()) {
            Player target = Bukkit.getPlayer((UUID)id);
            if (target == null || !target.isOnline()) continue;
            target.closeInventory();
        }
        map.clear();
    }
}

