/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.recipes;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.CodexEngine;
import studio.magemonkey.codex.api.items.ItemType;
import studio.magemonkey.codex.api.items.exception.MissingItemException;
import studio.magemonkey.codex.api.items.exception.MissingProviderException;
import studio.magemonkey.codex.items.CodexItemManager;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.hooks.divinity.DivinityRecipeMeta;
import studio.magemonkey.fusion.data.recipes.RecipeCustomItem;
import studio.magemonkey.fusion.data.recipes.RecipeEconomyItem;

public interface RecipeItem {
    public static final String CUSTOM_PREFIX = "@ ";
    public static final Pattern divinityPattern = Pattern.compile("DIVINITY_([\\w-]+:)?([^:~]+)\\b((~level:(\\d+))|(~material:([\\w-]+)\\b)){0,2}");

    public int getAmount();

    public ItemStack getItemStack();

    public Object toConfig();

    public static RecipeItem fromConfig(Object obj) {
        if (obj instanceof Map) {
            return RecipeItem.getItemBuilder((Map)obj);
        }
        int amount = 1;
        RecipeItem result = null;
        if (obj instanceof String) {
            block8: {
                String itemString = (String)obj;
                CodexItemManager items = CodexEngine.get().getItemManager();
                try {
                    Matcher divMatcher = divinityPattern.matcher(itemString);
                    String itemKey = divMatcher.find() ? divMatcher.group(0) : itemString.split(":")[0];
                    ItemType type = items.getItemType(itemKey);
                    if (type == null) break block8;
                    String[] amountSplit = StringUtils.split((String)(itemString = itemString.replace(itemKey, "")), (char)':');
                    if (amountSplit.length > 0) {
                        try {
                            amount = Integer.parseInt(amountSplit[amountSplit.length - 1]);
                        }
                        catch (NumberFormatException e) {
                            Fusion.getInstance().getLogger().warning("Invalid amount found in configuration: " + amountSplit[amountSplit.length - 1] + " for item " + itemKey);
                        }
                    }
                    result = new RecipeCustomItem(type, amount, false);
                }
                catch (MissingItemException | MissingProviderException e) {
                    throw new RuntimeException(e);
                }
            }
            if (result == null) {
                result = RecipeItem.buildInternalItem(obj);
            }
        }
        return result;
    }

    @Nullable
    private static RecipeItem buildInternalItem(Object obj) {
        String[] srrs;
        RecipeItem result = null;
        String str = obj.toString();
        boolean custom = str.startsWith(CUSTOM_PREFIX);
        if (custom) {
            str = str.substring(CUSTOM_PREFIX.length());
        }
        if ((srrs = StringUtils.split((String)str, (char)':')).length == 0) {
            return null;
        }
        if (custom) {
            Material mat = Material.matchMaterial((String)srrs[0]);
            if (mat == null) {
                Fusion.getInstance().getLogger().warning("Invalid material found in configuration: " + srrs[0]);
                return null;
            }
            ItemBuilder itemBuilder = ItemBuilder.newItem((Material)mat);
            if (srrs.length > 1) {
                try {
                    itemBuilder.durability(Integer.parseInt(srrs[1]));
                }
                catch (NumberFormatException e) {
                    Fusion.getInstance().error("Durability is invalid (" + srrs[1] + ") for material " + mat.name());
                }
            }
            if (srrs.length > 2) {
                try {
                    itemBuilder.amount(Integer.parseInt(srrs[2]));
                }
                catch (NumberFormatException e) {
                    Fusion.getInstance().error("Amount is invalid (" + srrs[2] + ") for material " + mat.name());
                }
            }
            result = new RecipeCustomItem(itemBuilder, 1, true);
        } else if (srrs.length == 2) {
            try {
                RecipeEconomyItem recipeEconomyItem = new RecipeEconomyItem(srrs[0], Integer.parseInt(srrs[1]));
                ItemType itemType = recipeEconomyItem.asItemType();
                if (itemType != null) {
                    result = recipeEconomyItem;
                }
            }
            catch (Exception e) {
                Fusion.getInstance().error("Error on loading configuration of RecipeItem: " + String.valueOf(obj) + ", exception: " + e.getMessage() + ", more in console.");
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @NotNull
    private static RecipeItem getItemBuilder(Map<String, Object> obj) {
        ItemBuilder itemBuilder = new ItemBuilder(obj);
        return new RecipeCustomItem(itemBuilder, itemBuilder.getAmount(), false);
    }

    public static RecipeItem fromDivinityRecipeMeta(DivinityRecipeMeta meta) {
        return new RecipeCustomItem(meta);
    }
}

