/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.data.player;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.fusion.cfg.sql.SQLManager;
import studio.magemonkey.fusion.data.player.PlayerRecipeLimit;
import studio.magemonkey.fusion.data.professions.Profession;
import studio.magemonkey.fusion.data.professions.pattern.Category;
import studio.magemonkey.fusion.data.queue.CraftingQueue;
import studio.magemonkey.fusion.data.queue.QueueItem;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.data.recipes.Recipe;

public class FusionPlayer {
    private final UUID uuid;
    private final Map<String, Profession> professions = new TreeMap<String, Profession>();
    private Map<String, CraftingQueue> cachedQueues = new TreeMap<String, CraftingQueue>();
    private Map<String, PlayerRecipeLimit> cachedRecipeLimits = new TreeMap<String, PlayerRecipeLimit>();
    private boolean autoCrafting;

    public FusionPlayer(UUID uuid) {
        this.uuid = uuid;
        this.autoCrafting = SQLManager.players().isAutoCrafting(uuid);
        for (Profession profession : SQLManager.professions().getProfessions(uuid)) {
            this.professions.put(profession.getName(), profession);
        }
        this.cachedQueues = SQLManager.queues().getCraftingQueues(this.getPlayer());
        this.cachedRecipeLimits = SQLManager.recipeLimits().getRecipeLimits(uuid);
    }

    public Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.uuid);
    }

    public CraftingQueue getQueue(String profession, Category category) {
        if (!this.cachedQueues.containsKey(profession + "." + category.getName())) {
            this.cachedQueues.put(profession + "." + category.getName(), new CraftingQueue(this.getPlayer(), profession, category));
            Bukkit.getConsoleSender().sendMessage("Created new crafting queue for profession " + profession + " and category " + category.getName() + " for player " + this.getPlayer().getName());
        }
        return this.cachedQueues.get(profession + "." + category.getName());
    }

    public PlayerRecipeLimit getRecipeLimit(Recipe recipe) {
        return this.getRecipeLimit(recipe.getRecipePath());
    }

    public PlayerRecipeLimit getRecipeLimit(String recipePath) {
        this.cachedRecipeLimits.putIfAbsent(recipePath, new PlayerRecipeLimit(recipePath, 0, -1L));
        return this.cachedRecipeLimits.get(recipePath);
    }

    public void incrementLimit(Recipe recipe) {
        this.getRecipeLimit(recipe).incrementLimit(1);
        if (recipe.getCraftingLimitCooldown() > 0) {
            this.getRecipeLimit(recipe).updateCooldown(recipe.getCraftingLimitCooldown());
        }
    }

    public boolean hasRecipeLimitReached(Recipe recipe) {
        if (recipe.getCraftingLimit() <= 0) {
            return false;
        }
        return this.getRecipeLimit(recipe.getRecipePath()).getLimit() >= recipe.getCraftingLimit();
    }

    public long getExperience(String profession) {
        long experience = 0L;
        if (this.professions.containsKey(profession)) {
            experience = (int)this.professions.get(profession).getExp();
        }
        return experience;
    }

    public long getExperience(Profession profession) {
        return this.getExperience(profession.getName());
    }

    public long getExperience(CraftingTable table) {
        return this.getExperience(table.getName());
    }

    public int getLevel(String profession) {
        int level = 0;
        if (this.professions.containsKey(profession)) {
            level = this.professions.get(profession).getLevel();
        }
        return level;
    }

    public int getLevel(Profession profession) {
        return this.getLevel(profession.getName());
    }

    public int getLevel(CraftingTable table) {
        return this.getLevel(table.getName());
    }

    @Nullable
    public Profession getProfession(String profession) {
        return this.professions.get(profession);
    }

    @Nullable
    public Profession getProfession(CraftingTable table) {
        return this.getProfession(table.getName());
    }

    public void removeProfession(String profession) {
        this.professions.remove(profession);
    }

    public void removeProfession(Profession profession) {
        this.removeProfession(profession.getName());
    }

    public void removeProfession(CraftingTable table) {
        this.removeProfession(table.getName());
    }

    public void addProfession(Profession profession) {
        this.professions.put(profession.getName(), profession);
    }

    public boolean hasProfession(String profession) {
        return this.professions.containsKey(profession);
    }

    public boolean hasProfession(Profession profession) {
        return this.hasProfession(profession.getName());
    }

    public boolean hasProfession(CraftingTable table) {
        return this.hasProfession(table.getName());
    }

    public Collection<Profession> getJoinedProfessions() {
        return this.professions.values().stream().filter(Profession::isJoined).collect(Collectors.toList());
    }

    public Collection<Profession> getMasteredProfessions() {
        return this.professions.values().stream().filter(Profession::isMastered).collect(Collectors.toList());
    }

    public Collection<Profession> getProfessions() {
        return this.professions.values();
    }

    public boolean hasMastered(String profession) {
        return this.professions.containsKey(profession) && this.professions.get(profession).isMastered();
    }

    public boolean hasMastered(Profession profession) {
        return this.hasMastered(profession.getName());
    }

    public boolean hasMastered(CraftingTable table) {
        return this.hasMastered(table.getName());
    }

    public boolean hasJoined(String profession) {
        return this.professions.containsKey(profession) && this.professions.get(profession).isJoined();
    }

    public boolean hasJoined(Profession profession) {
        return this.hasJoined(profession.getName());
    }

    public boolean hasJoined(CraftingTable table) {
        return this.hasJoined(table.getName());
    }

    public void setMastered(String profession, boolean mastered) {
        if (this.professions.containsKey(profession)) {
            this.professions.get(profession).setMastered(mastered);
        }
    }

    public void setMastered(Profession profession, boolean mastered) {
        this.setMastered(profession.getName(), mastered);
    }

    public void setMastered(CraftingTable table, boolean mastered) {
        this.setMastered(table.getName(), mastered);
    }

    public void setJoined(String profession, boolean joined) {
        if (this.professions.containsKey(profession)) {
            this.professions.get(profession).setJoined(joined);
        }
    }

    public void setJoined(Profession profession, boolean joined) {
        this.setJoined(profession.getName(), joined);
    }

    public void setJoined(CraftingTable table, boolean joined) {
        this.setJoined(table.getName(), joined);
    }

    public void addExperience(String profession, long experience) {
        if (this.professions.containsKey(profession)) {
            this.professions.get(profession).addExp(experience);
        }
    }

    public void addExp(Profession profession, long experience) {
        this.addExperience(profession.getName(), experience);
    }

    public void addExp(CraftingTable table, long experience) {
        this.addExperience(table.getName(), experience);
    }

    public void setExperience(String profession, long experience) {
        if (this.professions.containsKey(profession)) {
            this.professions.get(profession).setExp(experience);
        }
    }

    public void setExp(Profession profession, long experience) {
        this.setExperience(profession.getName(), experience);
    }

    public void setExp(CraftingTable table, long experience) {
        this.setExperience(table.getName(), experience);
    }

    public void removeExperience(String profession, long experience) {
        if (this.professions.containsKey(profession)) {
            this.professions.get(profession).removeExp(experience);
        }
    }

    public void removeExp(Profession profession, long experience) {
        this.removeExperience(profession.getName(), experience);
    }

    public void removeExp(CraftingTable table, long experience) {
        this.removeExperience(table.getName(), experience);
    }

    public void resetExperience(String profession) {
        if (this.professions.containsKey(profession)) {
            this.professions.get(profession).resetExp();
        }
    }

    public void resetExp(Profession profession) {
        this.resetExperience(profession.getName());
    }

    public void resetExp(CraftingTable table) {
        this.resetExperience(table.getName());
    }

    public void resetMastered(String profession) {
        if (this.professions.containsKey(profession)) {
            this.professions.get(profession).resetMastered();
        }
    }

    public void resetMastered(Profession profession) {
        this.resetMastered(profession.getName());
    }

    public void resetMastered(CraftingTable table) {
        this.resetMastered(table.getName());
    }

    public void resetJoined(String profession) {
        if (this.professions.containsKey(profession)) {
            this.professions.get(profession).resetJoined();
        }
    }

    public void resetJoined(Profession profession) {
        this.resetJoined(profession.getName());
    }

    public void resetJoined(CraftingTable table) {
        this.resetJoined(table.getName());
    }

    public void reset(String profession) {
        if (this.professions.containsKey(profession)) {
            this.professions.get(profession).reset();
        }
    }

    public void reset(Profession profession) {
        this.reset(profession.getName());
    }

    public void reset(CraftingTable table) {
        this.reset(table.getName());
    }

    public int[] getQueueSizes(String profession, Category category) {
        int[] limits = new int[]{0, 0, 0};
        String path = profession + "." + category.getName();
        limits[0] = this.cachedQueues.containsKey(path) ? this.cachedQueues.get(path).getQueue().size() : 0;
        for (Map.Entry<String, CraftingQueue> queue : this.cachedQueues.entrySet()) {
            if (queue.getKey().contains(profession + ".")) {
                limits[1] = limits[1] + queue.getValue().getQueue().size();
            }
            limits[2] = limits[2] + queue.getValue().getQueue().size();
        }
        return limits;
    }

    public int getFinishedSize() {
        int size = 0;
        for (CraftingQueue queue : this.cachedQueues.values()) {
            for (QueueItem item : queue.getQueue()) {
                if (!item.isDone()) continue;
                ++size;
            }
        }
        return size;
    }

    public void save() {
        SQLManager.players().setAutoCrafting(this.uuid, this.autoCrafting);
        for (Profession profession : this.professions.values()) {
            SQLManager.professions().setProfession(this.uuid, profession);
        }
        for (CraftingQueue queue : this.cachedQueues.values()) {
            SQLManager.queues().saveCraftingQueue(queue);
        }
        SQLManager.recipeLimits().saveRecipeLimits(this.uuid, this.cachedRecipeLimits);
        this.cachedQueues.clear();
        this.cachedRecipeLimits.clear();
    }

    @Generated
    public boolean isAutoCrafting() {
        return this.autoCrafting;
    }

    @Generated
    public void setAutoCrafting(boolean autoCrafting) {
        this.autoCrafting = autoCrafting;
    }
}

