/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg.sql.tables;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.ProfessionsCfg;
import studio.magemonkey.fusion.cfg.sql.SQLManager;
import studio.magemonkey.fusion.data.professions.pattern.Category;
import studio.magemonkey.fusion.data.queue.CraftingQueue;
import studio.magemonkey.fusion.data.queue.QueueItem;
import studio.magemonkey.fusion.data.recipes.CraftingTable;
import studio.magemonkey.fusion.data.recipes.Recipe;

public class FusionQueuesSQL {
    private final String Table = "fusion_queues";

    public FusionQueuesSQL() {
        try (PreparedStatement create = SQLManager.connection().prepareStatement("CREATE TABLE IF NOT EXISTS fusion_queues(Id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,UUID varchar(36), RecipePath varchar(100),CraftingTime numeric,SavedSeconds numeric,Timestamp BIGINT)");){
            create.execute();
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionQueuesSQL:FusionQueuesSQL] Something went wrong with the sql-connection: " + e.getMessage());
        }
    }

    public boolean setQueueItem(UUID uuid, QueueItem item) {
        if (item == null) {
            return false;
        }
        if (item.getId() == -1L) {
            boolean bl;
            block19: {
                PreparedStatement insert = SQLManager.connection().prepareStatement("INSERT INTO fusion_queues(UUID, RecipePath, Timestamp, CraftingTime, SavedSeconds) VALUES (?,?,?,?,?)");
                try {
                    insert.setString(1, uuid.toString());
                    insert.setString(2, item.getRecipePath());
                    insert.setLong(3, item.getTimestamp());
                    insert.setLong(4, item.getRecipe().getCraftingTime());
                    insert.setLong(5, item.getSavedSeconds());
                    insert.execute();
                    bl = true;
                    if (insert == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (insert != null) {
                            try {
                                insert.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        Fusion.getInstance().getLogger().warning("[SQL:FusionQueuesSQL:setQueueItem] Something went wrong with the sql-connection: " + e.getMessage());
                    }
                }
                insert.close();
            }
            return bl;
        } else {
            boolean bl;
            block20: {
                PreparedStatement update = SQLManager.connection().prepareStatement("UPDATE fusion_queues SET SavedSeconds=? WHERE Id=?");
                try {
                    update.setLong(1, item.getSavedSeconds());
                    update.setLong(2, item.getId());
                    update.execute();
                    bl = true;
                    if (update == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (update != null) {
                            try {
                                update.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        Fusion.getInstance().getLogger().warning("[SQL:FusionQueuesSQL:setQueueItem] Something went wrong with the sql-connection: " + e.getMessage());
                    }
                }
                update.close();
            }
            return bl;
        }
        return false;
    }

    public boolean removeQueueItem(QueueItem item) {
        boolean bl;
        block8: {
            PreparedStatement delete = SQLManager.connection().prepareStatement("DELETE FROM fusion_queues WHERE Id=?");
            try {
                delete.setLong(1, item.getId());
                delete.execute();
                bl = true;
                if (delete == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (delete != null) {
                        try {
                            delete.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    Fusion.getInstance().getLogger().warning("[SQL:FusionQueuesSQL:removeQueueItem] Something went wrong with the sql-connection: " + e.getMessage());
                    return false;
                }
            }
            delete.close();
        }
        return bl;
    }

    public List<QueueItem> getQueueItems(UUID uuid, String profession, Category category) {
        ArrayList<QueueItem> entries = new ArrayList<QueueItem>();
        String sql = "SELECT * FROM fusion_queues WHERE UUID=? AND RecipePath LIKE ?";
        try (PreparedStatement select = SQLManager.connection().prepareStatement(sql);){
            select.setString(1, uuid.toString());
            select.setString(2, "%" + profession + "." + category.getName() + "%");
            try (ResultSet result = select.executeQuery();){
                while (result.next()) {
                    String recipeStr = result.getString("RecipePath").split("\\.")[2];
                    Recipe recipe = category.getRecipe(recipeStr);
                    if (recipe == null) {
                        Fusion.getInstance().getLogger().warning("Unable to locate recipe: " + recipeStr + " for " + profession + "." + category.getName() + " while loading queue for " + String.valueOf(uuid) + ". Does it exist?");
                        List<String> availableRecipes = category.getRecipes().stream().map(r -> r.getName().split("::")[0]).toList();
                        Fusion.getInstance().getLogger().info("Available recipes are " + String.valueOf(availableRecipes));
                        continue;
                    }
                    entries.add(new QueueItem(result.getInt("Id"), profession, category, recipe, result.getLong("Timestamp"), result.getInt("SavedSeconds")));
                }
            }
        }
        catch (SQLException e) {
            Fusion.getInstance().getLogger().warning("[SQL:FusionQueuesSQL:getQueueItems] Something went wrong with the sql-connection: " + e.getMessage());
        }
        return entries;
    }

    public Map<String, CraftingQueue> getCraftingQueues(Player player) {
        HashMap<String, CraftingQueue> entries = new HashMap<String, CraftingQueue>();
        for (Map.Entry<String, CraftingTable> entry : ProfessionsCfg.getMap().entrySet()) {
            String profession = entry.getKey();
            for (Category category : entry.getValue().getCategories().values()) {
                String path = profession + "." + category.getName();
                if (entries.containsKey(path)) continue;
                entries.putIfAbsent(path, new CraftingQueue(player, profession, category));
            }
        }
        return entries;
    }

    public void saveCraftingQueue(CraftingQueue queue) {
        queue.cancelTask();
        for (QueueItem item : queue.getQueue()) {
            if (this.setQueueItem(queue.getPlayer().getUniqueId(), item)) continue;
            Fusion.getInstance().getLogger().warning("An instance of " + item.getRecipePath() + " could not be saved to the database: " + String.valueOf(queue.getPlayer().getUniqueId()));
        }
    }
}

