/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fusion.cfg;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.legacy.item.ItemBuilder;
import studio.magemonkey.codex.util.SerializationBuilder;
import studio.magemonkey.fusion.Fusion;
import studio.magemonkey.fusion.cfg.Cfg;
import studio.magemonkey.fusion.data.professions.ProfessionConditions;
import studio.magemonkey.fusion.data.professions.pattern.InventoryPattern;
import studio.magemonkey.fusion.gui.editors.browse.BrowseEditor;

public class BrowseConfig
implements ConfigurationSerializable {
    private static FileConfiguration config;
    private static File file;
    private static final LinkedList<String> professions;
    private static final HashMap<String, ProfessionConditions> professionConditions;
    private static String browseName;
    private static ItemStack browseFill;
    private static InventoryPattern browsePattern;
    private static boolean loreConditionsEnabled;

    private BrowseConfig() {
        BrowseConfig.load();
    }

    public static void load() {
        try {
            if (file == null || !file.exists()) {
                config = new YamlConfiguration();
                file = new File(Fusion.getInstance().getDataFolder(), "browse.yml");
                file.getParentFile().mkdirs();
                BrowseConfig.setDefaults();
                if (!file.exists()) {
                    file.createNewFile();
                    config.options().copyDefaults(true);
                    BrowseConfig.attemptPort();
                    config.save(file);
                    Fusion.getInstance().log.info("Created default browse.yml");
                }
            }
            YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)file);
            config = yaml;
            BrowseConfig.setDefaults();
            BrowseConfig.readData();
            Fusion.getInstance().log.info("Successfully loaded browse.yml data");
        }
        catch (IOException e) {
            Fusion.getInstance().log.severe("Could not load browse.yml data: " + e.getMessage());
        }
    }

    private static void attemptPort() {
        boolean changed;
        FileConfiguration conf = Cfg.getConfig();
        boolean bl = changed = conf.contains("browse.name") || conf.contains("browse.fillItem") || conf.contains("browse.pattern");
        if (conf.contains("browse.name")) {
            config.set("name", (Object)conf.getString("browse.name"));
        }
        if (conf.contains("browse.fillItem")) {
            config.set("pattern.items.fillItem", conf.get("browse.fillItem"));
        }
        if (conf.contains("browse.pattern")) {
            config.set("pattern", conf.get("browse.pattern"));
        }
        if (changed) {
            conf.set("browse", null);
            try {
                conf.save(new File(Fusion.getInstance().getDataFolder(), "config.yml"));
            }
            catch (IOException e) {
                Fusion.getInstance().log.severe("Could not load browse.yml data: " + e.getMessage());
                e.printStackTrace();
            }
            Fusion.getInstance().log.info("Successfully ported old browse info to new browse.yml");
        }
    }

    private static void setDefaults() {
        config.addDefault("name", (Object)"&3&lBrowse");
        config.addDefault("pattern.items.fillItem", (Object)ItemBuilder.newItem((Material)Material.BLACK_STAINED_GLASS_PANE).name(" ").build());
        HashMap<Character, ItemStack> browseItems = new HashMap<Character, ItemStack>();
        browseItems.put(Character.valueOf('0'), ItemBuilder.newItem((Material)Material.BIRCH_SIGN).name("&3Crafting Groups").insertLoreLine(0, String.valueOf(ChatColor.GRAY) + "Select a profession").build());
        browseItems.put(Character.valueOf('1'), ItemBuilder.newItem((Material)Material.CYAN_STAINED_GLASS_PANE).name(" ").build());
        InventoryPattern browsePattern = new InventoryPattern(new String[]{"111101111", "ooooooooo", "ooooooooo"}, browseItems);
        config.addDefault("pattern", browsePattern.serialize());
        config.addDefault("professions.armor_smithing.costs", Map.of("exp", 10));
        config.addDefault("professions.armor_smithing.conditions", Map.of());
        config.addDefault("professions.weapon_smithing.costs", Map.of("money", 5));
        config.addDefault("professions.weapon_smithing.conditions", Map.of());
    }

    private static void readData() {
        professions.clear();
        professionConditions.clear();
        browseName = config.getString("name");
        browseFill = config.getItemStack("pattern.items.fillItem");
        browsePattern = new InventoryPattern(config.getConfigurationSection("pattern").getValues(false));
        for (String prof : config.getConfigurationSection("professions").getValues(false).keySet()) {
            professions.add(prof.toLowerCase());
            professionConditions.put(prof.toLowerCase(), new ProfessionConditions(prof, config.getConfigurationSection("professions." + prof)));
            Fusion.getInstance().log.info("Loaded info for profession '" + prof + "'");
        }
    }

    public static ProfessionConditions getProfessionConditions(String profession) {
        return professionConditions.getOrDefault(profession.toLowerCase(), null);
    }

    public void saveConfig() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save(BrowseEditor editor) {
        LinkedHashMap<String, Map<String, Object>> professionsMap = new LinkedHashMap<String, Map<String, Object>>();
        for (ProfessionConditions conditions : editor.getProfessionConditions().values()) {
            professionsMap.put(conditions.getProfession(), conditions.serialize());
        }
        config.set("name", (Object)editor.getName());
        config.set("pattern", editor.getBrowsePattern().serialize());
        config.set("professions", professionsMap);
        try {
            config.save(file);
            config = YamlConfiguration.loadConfiguration((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public Map<String, Object> serialize() {
        LinkedHashMap<String, Map<String, Object>> professionsMap = new LinkedHashMap<String, Map<String, Object>>();
        for (ProfessionConditions conditions : professionConditions.values()) {
            professionsMap.put(conditions.getProfession(), conditions.serialize());
        }
        return SerializationBuilder.start((int)2).append("name", (Object)browseName).append("pattern", browsePattern.serialize()).append("professions", professionsMap).build();
    }

    @Generated
    public static LinkedList<String> getProfessions() {
        return professions;
    }

    @Generated
    public static HashMap<String, ProfessionConditions> getProfessionConditions() {
        return professionConditions;
    }

    @Generated
    public static String getBrowseName() {
        return browseName;
    }

    @Generated
    public static void setBrowseName(String browseName) {
        BrowseConfig.browseName = browseName;
    }

    @Generated
    public static ItemStack getBrowseFill() {
        return browseFill;
    }

    @Generated
    public static void setBrowseFill(ItemStack browseFill) {
        BrowseConfig.browseFill = browseFill;
    }

    @Generated
    public static InventoryPattern getBrowsePattern() {
        return browsePattern;
    }

    @Generated
    public static void setBrowsePattern(InventoryPattern browsePattern) {
        BrowseConfig.browsePattern = browsePattern;
    }

    @Generated
    public static boolean isLoreConditionsEnabled() {
        return loreConditionsEnabled;
    }

    @Generated
    public static void setLoreConditionsEnabled(boolean loreConditionsEnabled) {
        BrowseConfig.loreConditionsEnabled = loreConditionsEnabled;
    }

    static {
        professions = new LinkedList();
        professionConditions = new HashMap();
        browseName = String.valueOf(ChatColor.DARK_AQUA) + "Browse";
        loreConditionsEnabled = true;
    }
}

