/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.tree.basic;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import studio.magemonkey.codex.compat.VersionManager;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.config.Filter;
import studio.magemonkey.codex.mccore.config.FilterType;
import studio.magemonkey.codex.mccore.items.InventoryManager;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fabled.api.exception.SkillTreeException;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.gui.tool.GUITool;
import studio.magemonkey.fabled.language.RPGFilter;
import studio.magemonkey.fabled.tree.SkillTree;

public abstract class InventoryTree
extends SkillTree {
    protected static final Comparator<Skill> comparator = new Comparator<Skill>(){

        @Override
        public int compare(Skill skill1, Skill skill2) {
            return skill1.getSkillReq() != null && skill2.getSkillReq() == null ? 1 : (skill1.getSkillReq() == null && skill2.getSkillReq() != null ? -1 : (skill1.getLevelReq(0) > skill2.getLevelReq(0) ? 1 : (skill1.getLevelReq(0) < skill2.getLevelReq(0) ? -1 : (skill1.getCost(0) > skill2.getCost(0) ? 1 : (skill1.getCost(0) < skill2.getCost(0) ? -1 : skill1.getName().compareTo(skill2.getName()))))));
        }
    };
    private static final String INVENTORY_KEY = "SAPI_ST";
    protected final TreeMap<Integer, Skill> skillSlots = new TreeMap();
    protected int height;

    public InventoryTree(Fabled api, FabledClass tree) {
        super(api, tree);
    }

    public void show(Player player) {
        player.openInventory(this.getInventory(Fabled.getData((OfflinePlayer)player)));
    }

    public Inventory getInventory(PlayerData player) {
        GUITool.getSkillTree(this.tree);
        Inventory inv = InventoryManager.createInventory((String)INVENTORY_KEY, (int)this.height, (String)((String)Fabled.getLanguage().getMessage("GUI.skill-tree", true, FilterType.COLOR, new CustomFilter[]{RPGFilter.CLASS.setReplacement(this.tree.getName()), Filter.PLAYER.setReplacement(player.getPlayerName())}).get(0)));
        Player p = player.getPlayer();
        for (Map.Entry<Integer, Skill> entry : this.skillSlots.entrySet()) {
            if (!this.canShow(p, entry.getValue())) continue;
            inv.setItem(entry.getKey().intValue(), entry.getValue().getIndicator(player.getSkill(entry.getValue().getName()), false));
        }
        return inv;
    }

    public boolean checkClick(int slot) {
        return this.skillSlots.containsKey(slot);
    }

    public boolean isSkill(HumanEntity player, int slot) {
        return this.skillSlots.get(slot) != null && player != null && this.skillSlots.get(slot).isAllowed((Player)player);
    }

    public Skill getSkill(int slot) {
        return this.skillSlots.get(slot);
    }

    public TreeMap<Integer, Skill> getSkillSlots() {
        return this.skillSlots;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void arrange() throws SkillTreeException {
        super.arrange();
        if (this.height > 6) {
            throw new SkillTreeException("Error generating the skill tree: " + this.tree.getName() + " - too large of a tree!");
        }
    }

    public void update(PlayerData player) {
        for (Map.Entry<Integer, Skill> skills : this.skillSlots.entrySet()) {
            VersionManager.getCompat().setItem(player.getPlayer(), skills.getKey().intValue(), skills.getValue().getIndicator(player.getSkill(skills.getValue().getName()), false));
        }
    }

    @Override
    public boolean hasSkill(Skill skill) {
        return this.skillSlots.containsValue(skill);
    }
}

