/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.tree.basic;

import java.util.Comparator;
import java.util.List;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fabled.api.exception.SkillTreeException;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.gui.tool.GUIType;
import studio.magemonkey.fabled.tree.basic.InventoryTree;

public class FloodTree
extends InventoryTree {
    private static final Comparator<Skill> levelComparator = new Comparator<Skill>(){

        @Override
        public int compare(Skill skill1, Skill skill2) {
            return skill1.getLevelReq(0) > skill2.getLevelReq(0) ? 1 : (skill1.getLevelReq(0) < skill2.getLevelReq(0) ? -1 : (skill1.getCost(0) > skill2.getCost(0) ? 1 : (skill1.getCost(0) < skill2.getCost(0) ? -1 : skill1.getName().compareTo(skill2.getName()))));
        }
    };

    public FloodTree(Fabled api, FabledClass tree) {
        super(api, tree);
    }

    @Override
    protected void arrange(List<Skill> skills) throws SkillTreeException {
        this.skillSlots.clear();
        skills.sort(levelComparator);
        int i = 0;
        for (Skill skill : skills) {
            if (i % 9 == 8) {
                ++i;
            }
            this.skillSlots.put(i, skill);
            ++i;
        }
        this.height = Math.max(1, Math.min(Fabled.getConfig("gui").getConfig().getInt(GUIType.SKILL_TREE.getPrefix() + this.tree.getName() + ".rows", (skills.size() + 7) / 8), 6));
    }
}

