/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.task;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.task.EntityTask;

public class RepeatingEntityTask<T extends Entity>
extends BukkitRunnable {
    private List<T> entities;
    private EntityTask<T> entityTask;

    public RepeatingEntityTask(List<T> entities, EntityTask<T> entityTask) {
        this.entities = entities;
        this.entityTask = entityTask;
        Fabled.schedule(this, 1, 1);
    }

    public void run() {
        ArrayList<Entity> toRemove = new ArrayList<Entity>();
        for (Entity entity : this.entities) {
            if (!entity.isValid() || entity.isDead() || this.stoppedMoving(entity)) {
                toRemove.add(entity);
                continue;
            }
            this.entityTask.apply(entity);
        }
        this.entities.removeAll(toRemove);
        if (this.entities.size() == 0) {
            this.cancel();
        }
    }

    private boolean stoppedMoving(T ent) {
        Vector vector = ent.getVelocity();
        return vector.getX() == 0.0 && vector.getY() == 0.0 && vector.getZ() == 0.0;
    }
}

