/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.log;

import java.util.HashMap;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.log.LogType;

public class Logger {
    private static final HashMap<String, Integer> LEVELS = new HashMap();

    public static void loadLevels(DataSection config) {
        for (String key : config.keys()) {
            Logger.setLevel(key, config.getInt(key));
        }
    }

    public static void setLevel(String key, int level) {
        LEVELS.put(key, level);
    }

    public static void log(String key, int level, String message) {
        if (LEVELS.containsKey(key) && LEVELS.get(key) >= level) {
            Fabled.inst().getLogger().info(message);
        }
    }

    public static void log(LogType key, int level, String message) {
        Logger.log(key.key(), level, message);
    }

    public static void invalid(String message) {
        Fabled.inst().getLogger().severe(message);
    }

    public static void bug(String message) {
        Fabled.inst().getLogger().severe(message);
    }

    public static void bug(String message, Throwable e) {
        StringBuilder stackTrace = new StringBuilder(e.getMessage());
        for (StackTraceElement stackTraceElement : e.getStackTrace()) {
            stackTrace.append("\n").append(stackTraceElement.toString()).append("\n");
        }
        Fabled.inst().getLogger().severe(message + "\n\n" + String.valueOf(stackTrace));
    }

    public static void log(String message) {
        Fabled.inst().getLogger().info(message);
    }
}

