/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.listener;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.Pair;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.util.BuffData;
import studio.magemonkey.fabled.api.util.BuffManager;
import studio.magemonkey.fabled.api.util.BuffType;
import studio.magemonkey.fabled.hook.ProtocolLibHook;
import studio.magemonkey.fabled.listener.FabledListener;

public class PacketListener
extends FabledListener {
    private ProtocolLibHook protocolLib;
    private List<PacketAdapter> packetListeners = new ArrayList<PacketAdapter>();

    @Override
    public void init() {
        this.protocolLib = new ProtocolLibHook(Fabled.inst());
        this.addListener(new EntityEquipmentPacketAdapter(ListenerPriority.HIGH, PacketType.Play.Server.ENTITY_EQUIPMENT));
        this.addListener(new PlayAnimationPacketAdapter(ListenerPriority.HIGH, PacketType.Play.Server.HURT_ANIMATION));
    }

    private void addListener(PacketAdapter listener) {
        this.packetListeners.add(listener);
        this.protocolLib.register(listener);
    }

    public static void updateEquipment(Player owner) {
        ProtocolLibHook protocolLib = new ProtocolLibHook(Fabled.inst());
        PacketContainer packet = protocolLib.getProtocolManager().createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
        PlayerInventory inv = owner.getInventory();
        packet.getIntegers().write(0, (Object)owner.getEntityId());
        List pairList = (List)packet.getSlotStackPairLists().read(0);
        pairList.add(new Pair((Object)EnumWrappers.ItemSlot.HEAD, (Object)inv.getHelmet()));
        pairList.add(new Pair((Object)EnumWrappers.ItemSlot.CHEST, (Object)inv.getChestplate()));
        pairList.add(new Pair((Object)EnumWrappers.ItemSlot.LEGS, (Object)inv.getLeggings()));
        pairList.add(new Pair((Object)EnumWrappers.ItemSlot.FEET, (Object)inv.getBoots()));
        pairList.add(new Pair((Object)EnumWrappers.ItemSlot.MAINHAND, (Object)inv.getItemInMainHand()));
        pairList.add(new Pair((Object)EnumWrappers.ItemSlot.OFFHAND, (Object)inv.getItemInOffHand()));
        packet.getSlotStackPairLists().write(0, (Object)pairList);
        protocolLib.broadcastToNearby(owner, packet);
    }

    @Override
    public void cleanup() {
        this.protocolLib.unregister(this.packetListeners);
    }

    private class EntityEquipmentPacketAdapter
    extends PacketAdapter {
        public EntityEquipmentPacketAdapter(ListenerPriority listenerPriority, PacketType ... types) {
            super((Plugin)Fabled.inst(), listenerPriority, types);
        }

        public void onPacketSending(PacketEvent event) {
            Entity entity = PacketListener.this.protocolLib.getProtocolManager().getEntityFromID(event.getPlayer().getWorld(), ((Integer)event.getPacket().getIntegers().read(0)).intValue());
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            BuffData data = BuffManager.getBuffData((LivingEntity)entity, false);
            if (data == null || !data.isActive(BuffType.INVISIBILITY) || !((LivingEntity)entity).hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                return;
            }
            PacketContainer packet = event.getPacket();
            ItemStack air = new ItemStack(Material.AIR);
            List pairList = (List)packet.getSlotStackPairLists().read(0);
            pairList.add(new Pair((Object)EnumWrappers.ItemSlot.HEAD, (Object)air));
            pairList.add(new Pair((Object)EnumWrappers.ItemSlot.CHEST, (Object)air));
            pairList.add(new Pair((Object)EnumWrappers.ItemSlot.LEGS, (Object)air));
            pairList.add(new Pair((Object)EnumWrappers.ItemSlot.FEET, (Object)air));
            pairList.add(new Pair((Object)EnumWrappers.ItemSlot.MAINHAND, (Object)air));
            pairList.add(new Pair((Object)EnumWrappers.ItemSlot.OFFHAND, (Object)air));
            packet.getSlotStackPairLists().write(0, (Object)pairList);
        }
    }

    private class PlayAnimationPacketAdapter
    extends PacketAdapter {
        public PlayAnimationPacketAdapter(ListenerPriority listenerPriority, PacketType ... types) {
            super((Plugin)Fabled.inst(), listenerPriority, types);
        }

        public void onPacketSending(PacketEvent event) {
            Entity entity = PacketListener.this.protocolLib.getProtocolManager().getEntityFromID(event.getPlayer().getWorld(), ((Integer)event.getPacket().getIntegers().read(0)).intValue());
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            BuffData data = BuffManager.getBuffData((LivingEntity)entity, false);
            if (data == null || !data.isActive(BuffType.NO_SCREEN_SHAKE)) {
                return;
            }
            event.setCancelled(true);
        }
    }
}

