/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.trigger;

import java.util.List;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.event.PlayerAttributeChangeEvent;
import studio.magemonkey.fabled.dynamic.trigger.Trigger;

public class AttributeChangeTrigger
implements Trigger<PlayerAttributeChangeEvent> {
    @Override
    public String getKey() {
        return "ATTRIBUTE_CHANGE";
    }

    @Override
    public Class<PlayerAttributeChangeEvent> getEvent() {
        return PlayerAttributeChangeEvent.class;
    }

    @Override
    public boolean shouldTrigger(PlayerAttributeChangeEvent event, int level, Settings settings) {
        List<String> attrs = settings.getStringList("attr");
        if (attrs.isEmpty() || attrs.get(0).equals("Any")) {
            return true;
        }
        return attrs.stream().anyMatch(attr -> attr.equalsIgnoreCase(event.getAttribute()));
    }

    @Override
    public void setValues(PlayerAttributeChangeEvent event, CastData data) {
        data.put("api-attribute", event.getAttribute());
        data.put("api-change", event.getChange());
        data.put("api-value", event.getPlayerData().getInvestedAttributeStage(event.getAttribute()) + event.getChange());
    }

    @Override
    public LivingEntity getCaster(PlayerAttributeChangeEvent event) {
        return event.getPlayer();
    }

    @Override
    public LivingEntity getTarget(PlayerAttributeChangeEvent event, Settings settings) {
        return event.getPlayer();
    }
}

