/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.target;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.particle.ParticleSettings;
import studio.magemonkey.fabled.api.util.Nearby;
import studio.magemonkey.fabled.dynamic.target.TargetComponent;

public class NearestTarget
extends TargetComponent {
    private static final String RADIUS = "radius";

    @Override
    public List<LivingEntity> getTargets(LivingEntity caster, int level, List<LivingEntity> targets) {
        double radius = this.parseValues(caster, RADIUS, level, 3.0);
        ArrayList<LivingEntity> result = new ArrayList<LivingEntity>();
        for (LivingEntity target : targets) {
            DistanceComparator comparator = new DistanceComparator(target.getLocation());
            Nearby.getLivingNearby((Entity)target, radius).stream().filter(e -> this.isValidTarget(caster, target, (LivingEntity)e) || this.self.equals((Object)TargetComponent.IncludeCaster.IN_AREA) && caster.equals(e)).min(comparator).ifPresent(e -> {
                GameMode gm;
                GameMode gameMode = gm = e instanceof Player ? ((Player)e).getGameMode() : GameMode.SURVIVAL;
                if (gm == GameMode.SPECTATOR || gm == GameMode.CREATIVE) {
                    return;
                }
                result.add((LivingEntity)e);
            });
        }
        return result;
    }

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, final int level, final Supplier<List<LivingEntity>> targetSupplier) {
        BukkitTask task;
        super.playPreview(onPreviewStop, caster, level, targetSupplier);
        if (this.preview.getBool("circle", false)) {
            task = new BukkitRunnable(){

                public void run() {
                    ParticleSettings particleSettings = new ParticleSettings(NearestTarget.this.preview, "circle-");
                    double radius = NearestTarget.this.parseValues((LivingEntity)caster, NearestTarget.RADIUS, level, 3.0);
                    double density = NearestTarget.this.preview.getDouble("circle-density", 1.0);
                    double angle = 1.0 / radius / density;
                    double halfPi = 1.5707963267948966;
                    Vector direction = new Vector(radius, 0.0, 0.0);
                    for (LivingEntity target : (List)targetSupplier.get()) {
                        Location center = target.getLocation();
                        for (double totalAngle = 0.0; totalAngle <= halfPi + 0.1; totalAngle += angle) {
                            Vector dir = direction.clone().rotateAroundY(totalAngle);
                            particleSettings.instance(caster, center.getX() + dir.getX(), center.getY() + dir.getY(), center.getZ() + dir.getZ());
                            particleSettings.instance(caster, center.getX() + dir.getX(), center.getY() + dir.getY(), center.getZ() - dir.getZ());
                            particleSettings.instance(caster, center.getX() - dir.getX(), center.getY() + dir.getY(), center.getZ() + dir.getZ());
                            particleSettings.instance(caster, center.getX() - dir.getX(), center.getY() + dir.getY(), center.getZ() - dir.getZ());
                        }
                    }
                }
            }.runTaskTimer((Plugin)Fabled.inst(), 0L, (long)Math.max(1, this.preview.getInt("circle-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
        if (this.preview.getBool("sphere", false)) {
            task = new BukkitRunnable(){

                public void run() {
                    ParticleSettings particleSettings = new ParticleSettings(NearestTarget.this.preview, "sphere-");
                    double radius = NearestTarget.this.parseValues((LivingEntity)caster, NearestTarget.RADIUS, level, 3.0);
                    double density = NearestTarget.this.preview.getDouble("sphere-density", 1.0);
                    double zAngle = 1.0 / radius / density;
                    double halfPi = 1.5707963267948966;
                    for (LivingEntity target : (List)targetSupplier.get()) {
                        Location center = target.getLocation();
                        Vector direction = new Vector(radius, 0.0, 0.0);
                        for (double totalZAngle = 0.0; totalZAngle <= halfPi; totalZAngle += zAngle) {
                            Vector dir = direction.clone().rotateAroundZ(totalZAngle);
                            double yAngle = 1.0 / (radius * Math.cos(totalZAngle)) / density;
                            for (double totalYAngle = 0.0; totalYAngle <= halfPi; totalYAngle += yAngle) {
                                Vector loc = dir.clone().rotateAroundY(totalYAngle);
                                particleSettings.instance(caster, center.getX() + loc.getX(), center.getY() + loc.getY(), center.getZ() + loc.getZ());
                                particleSettings.instance(caster, center.getX() + loc.getX(), center.getY() + loc.getY(), center.getZ() - loc.getZ());
                                particleSettings.instance(caster, center.getX() + loc.getX(), center.getY() - loc.getY(), center.getZ() + loc.getZ());
                                particleSettings.instance(caster, center.getX() + loc.getX(), center.getY() - loc.getY(), center.getZ() - loc.getZ());
                                particleSettings.instance(caster, center.getX() - loc.getX(), center.getY() + loc.getY(), center.getZ() + loc.getZ());
                                particleSettings.instance(caster, center.getX() - loc.getX(), center.getY() + loc.getY(), center.getZ() - loc.getZ());
                                particleSettings.instance(caster, center.getX() - loc.getX(), center.getY() - loc.getY(), center.getZ() + loc.getZ());
                                particleSettings.instance(caster, center.getX() - loc.getX(), center.getY() - loc.getY(), center.getZ() - loc.getZ());
                            }
                        }
                    }
                }
            }.runTaskTimer((Plugin)Fabled.inst(), 0L, (long)Math.max(1, this.preview.getInt("sphere-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
    }

    @Override
    public String getKey() {
        return "nearest";
    }

    public static class DistanceComparator
    implements Comparator<LivingEntity> {
        private final Location loc;

        public DistanceComparator(Location loc) {
            this.loc = loc;
        }

        @Override
        public int compare(LivingEntity o1, LivingEntity o2) {
            return Double.compare(o1.getLocation().distanceSquared(this.loc), o2.getLocation().distanceSquared(this.loc));
        }
    }
}

