/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.warp;

import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.particle.ParticleHelper;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.mechanic.warp.AbstractWarpingMechanic;

public class WarpValueMechanic
extends AbstractWarpingMechanic {
    private static final String KEY = "key";

    @Override
    public String getKey() {
        return "warp value";
    }

    @Nullable
    private Location parseLocation(LivingEntity caster) {
        CastData data = DynamicSkill.getCastData(caster);
        if (data == null) {
            return null;
        }
        String key = this.settings.getString(KEY);
        if (key == null) {
            return null;
        }
        Object obj = data.getRaw(key);
        if (obj instanceof Location) {
            return (Location)obj;
        }
        return null;
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty()) {
            return false;
        }
        Location loc = this.parseLocation(caster);
        if (loc == null) {
            return false;
        }
        for (LivingEntity target : targets) {
            this.warp(target, caster, loc, level);
        }
        return true;
    }

    @Override
    public void playPreview(List<Runnable> onPreviewStop, final Player caster, int level, Supplier<List<LivingEntity>> targetSupplier) {
        if (this.preview.getBool("per-target")) {
            BukkitTask task = new BukkitRunnable(){

                public void run() {
                    Location loc = WarpValueMechanic.this.parseLocation((LivingEntity)caster);
                    if (loc == null) {
                        return;
                    }
                    ParticleHelper.play(loc, WarpValueMechanic.this.preview, Set.of(caster), "per-target-", null);
                }
            }.runTaskTimer((Plugin)Fabled.inst(), 0L, (long)Math.max(1, this.preview.getInt("per-target-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
    }
}

