/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.value;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class ValueManaMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String TYPE = "type";
    private static final String SAVE = "save";

    @Override
    public String getKey() {
        return "value mana";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (!(targets.get(0) instanceof Player)) {
            return false;
        }
        PlayerData player = Fabled.getData((OfflinePlayer)((Player)targets.get(0)));
        String key = this.settings.getString(KEY);
        String type = this.settings.getString(TYPE, "current").toLowerCase();
        CastData data = DynamicSkill.getCastData(caster);
        switch (type) {
            case "max": {
                data.put(key, player.getMaxMana());
                break;
            }
            case "percent": {
                data.put(key, player.getMana() / player.getMaxMana());
                break;
            }
            case "missing": {
                data.put(key, player.getMaxMana() - player.getMana());
                break;
            }
            default: {
                data.put(key, player.getMana());
            }
        }
        if (this.settings.getBool(SAVE, false)) {
            Fabled.getData((OfflinePlayer)caster).setPersistentData(key, data.getRaw(key));
        }
        return true;
    }
}

