/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic.value;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class ValueHealthMechanic
extends MechanicComponent {
    private static final String KEY = "key";
    private static final String TYPE = "type";
    private static final String SAVE = "save";

    @Override
    public String getKey() {
        return "value health";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        String key = this.settings.getString(KEY);
        String type = this.settings.getString(TYPE, "current").toLowerCase();
        CastData data = DynamicSkill.getCastData(caster);
        LivingEntity target = targets.get(0);
        switch (type) {
            case "max": {
                data.put(key, target.getMaxHealth());
                break;
            }
            case "percent": {
                data.put(key, target.getHealth() / target.getMaxHealth());
                break;
            }
            case "missing": {
                data.put(key, target.getMaxHealth() - target.getHealth());
                break;
            }
            default: {
                data.put(key, target.getHealth());
            }
        }
        if (this.settings.getBool(SAVE, false)) {
            Fabled.getData((OfflinePlayer)caster).setPersistentData(key, data.getRaw(key));
        }
        return true;
    }
}

