/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.LivingEntity;
import org.bukkit.scheduler.BukkitRunnable;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class RepeatMechanic
extends MechanicComponent {
    private static final String REPETITIONS = "repetitions";
    private static final String DELAY = "delay";
    private static final String PERIOD = "period";
    private static final String STOP_ON_FAIL = "stop-on-fail";
    private final Map<Integer, List<RepeatTask>> tasks = new HashMap<Integer, List<RepeatTask>>();

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        if (targets.size() > 0) {
            int count = (int)this.parseValues(caster, REPETITIONS, level, 3.0);
            if (count <= 0) {
                return false;
            }
            int delay = (int)(this.settings.getDouble(DELAY, 0.0) * 20.0);
            int period = (int)(this.settings.getDouble(PERIOD, 1.0) * 20.0);
            boolean stopOnFail = this.settings.getBool(STOP_ON_FAIL, false);
            if (period <= 0) {
                while (count > 0) {
                    count = this.execute(caster, targets, count, stopOnFail, force);
                }
            } else {
                RepeatTask task = new RepeatTask(caster, targets, count, delay, period, stopOnFail, force);
                this.tasks.computeIfAbsent(caster.getEntityId(), ArrayList::new).add(task);
            }
            return true;
        }
        return false;
    }

    private int execute(LivingEntity caster, List<LivingEntity> targets, int count, boolean stopOnFail, boolean force) {
        for (int i = 0; i < targets.size(); ++i) {
            if (!targets.get(i).isDead() && targets.get(i).isValid()) continue;
            targets.remove(i);
        }
        if (!this.skill.isActive(caster) && !force || targets.size() == 0) {
            return 0;
        }
        int level = this.skill.getActiveLevel(caster);
        boolean success = this.executeChildren(caster, level, targets, force);
        if (--count <= 0 || !success && stopOnFail) {
            return 0;
        }
        if (this.skill.checkCancelled()) {
            return 0;
        }
        return count;
    }

    @Override
    public String getKey() {
        return "repeat";
    }

    @Override
    protected void doCleanUp(LivingEntity caster) {
        List<RepeatTask> casterTasks = this.tasks.remove(caster.getEntityId());
        if (casterTasks != null) {
            casterTasks.forEach(RepeatTask::cancel);
        }
    }

    private class RepeatTask
    extends BukkitRunnable {
        private final List<LivingEntity> targets;
        private final LivingEntity caster;
        private final boolean stopOnFail;
        private final boolean force;
        private int count;

        RepeatTask(LivingEntity caster, List<LivingEntity> targets, int count, int delay, int period, boolean stopOnFail, boolean force) {
            this.targets = new ArrayList<LivingEntity>(targets);
            this.caster = caster;
            this.count = count;
            this.stopOnFail = stopOnFail;
            this.force = force;
            Fabled.schedule(this, delay, period);
        }

        public void cancel() {
            super.cancel();
            List<RepeatTask> casterTasks = RepeatMechanic.this.tasks.get(this.caster.getEntityId());
            if (casterTasks != null) {
                casterTasks.remove((Object)this);
            }
        }

        public void run() {
            this.count = RepeatMechanic.this.execute(this.caster, this.targets, this.count, this.stopOnFail, this.force);
            if (this.count <= 0) {
                this.cancel();
            }
        }
    }
}

