/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.mechanic;

import java.util.List;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import studio.magemonkey.fabled.dynamic.mechanic.MechanicComponent;

public class DurabilityMechanic
extends MechanicComponent {
    private static final String AMOUNT = "amount";
    private static final String OFFHAND = "offhand";

    @Override
    public String getKey() {
        return "durability";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        ItemStack item;
        if (!(caster instanceof Player)) {
            return false;
        }
        Player player = (Player)caster;
        boolean offhand = this.settings.getBool(OFFHAND, false);
        short amount = (short)(this.parseValues(caster, AMOUNT, level, 1.0) * (double)targets.size());
        ItemStack itemStack = item = offhand ? player.getInventory().getItemInOffHand() : player.getInventory().getItemInMainHand();
        if (item.getType().isAir() || item.getType().getMaxDurability() == 0) {
            return false;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof Damageable)) {
            return false;
        }
        Damageable im = (Damageable)itemMeta;
        int durability = item.getType().getMaxDurability() - im.getDamage();
        if (amount > 0 && durability <= amount) {
            if (offhand) {
                player.getInventory().setItemInOffHand(null);
            } else {
                player.getInventory().setItemInMainHand(null);
            }
            player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
        }
        im.setDamage(im.getDamage() + amount);
        item.setItemMeta((ItemMeta)im);
        return true;
    }
}

