/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.condition;

import java.util.List;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.condition.ConditionComponent;

public class ValueCondition
extends ConditionComponent {
    private static final String KEY = "key";
    private static final String MIN = "min-value";
    private static final String MAX = "max-value";

    @Override
    public String getKey() {
        return "value";
    }

    @Override
    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets, boolean force) {
        return this.test(caster, level, null) && this.executeChildren(caster, level, targets, force);
    }

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        String key = this.settings.getString(KEY);
        double min = this.parseValues(caster, MIN, level, 1.0);
        double max = this.parseValues(caster, MAX, level, 999.0);
        CastData data = DynamicSkill.getCastData(caster);
        if (!data.contains(key)) {
            return false;
        }
        double value = DynamicSkill.getCastData(caster).getDouble(key);
        double deltaAllowed = 1.0E-4;
        double minDelta = value - min;
        double maxDelta = max - value;
        return minDelta >= -deltaAllowed && maxDelta >= -deltaAllowed;
    }
}

