/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.condition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.condition.ConditionComponent;
import studio.magemonkey.fabled.hook.MythicMobsHook;
import studio.magemonkey.fabled.hook.PluginChecker;

public class MythicMobTypeCondition
extends ConditionComponent {
    private static final String TYPES = "types";
    private Set<String> types;

    @Override
    public void load(DynamicSkill skill, DataSection config) {
        super.load(skill, config);
        this.types = new HashSet<String>();
        List<String> stringList = this.settings.getStringList(TYPES);
        if (stringList.stream().anyMatch(str -> str.equalsIgnoreCase("any"))) {
            this.types.add("any");
        } else {
            for (String string : stringList) {
                if (string.isEmpty()) continue;
                this.types.add(string);
            }
        }
    }

    @Override
    public String getKey() {
        return "mythicmob type";
    }

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        if (!PluginChecker.isMythicMobsActive()) {
            return false;
        }
        if (MythicMobsHook.isMonster(target)) {
            if (this.types.contains("any")) {
                return true;
            }
            String type = MythicMobsHook.getMythicMobId((Entity)target);
            for (String string : this.types) {
                if (!string.equals(type)) continue;
                return true;
            }
            return false;
        }
        return this.types.isEmpty();
    }
}

