/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.condition;

import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;
import studio.magemonkey.fabled.dynamic.condition.ConditionComponent;

public class ManaCondition
extends ConditionComponent {
    private static final String TYPE = "type";
    private static final String MIN = "min-value";
    private static final String MAX = "max-value";

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        if (!(target instanceof Player)) {
            return false;
        }
        String type = this.settings.getString(TYPE).toLowerCase();
        double min = this.parseValues(caster, MIN, level, 0.0);
        double max = this.parseValues(caster, MAX, level, 99.0);
        PlayerData data = Fabled.getData((OfflinePlayer)((Player)target));
        PlayerSkill skill = this.getSkillData(caster);
        double mana = data.getMana();
        double value = switch (type) {
            case "difference percent" -> (mana - skill.getPlayerData().getMana()) * 100.0 / skill.getPlayerData().getMana();
            case "difference" -> mana - skill.getPlayerData().getMana();
            case "percent" -> mana * 100.0 / data.getMaxMana();
            default -> mana;
        };
        return value >= min && value <= max;
    }

    @Override
    public String getKey() {
        return "mana";
    }
}

