/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic.condition;

import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.dynamic.condition.ConditionComponent;

public class BlockCondition
extends ConditionComponent {
    private static final String MATERIAL = "material";
    private static final String STANDING = "standing";
    private Set<String> types;
    private boolean negated;
    private boolean in;

    @Override
    public String getKey() {
        return "block";
    }

    @Override
    public void load(DynamicSkill skill, DataSection config) {
        super.load(skill, config);
        String type = this.settings.getString(STANDING).toLowerCase();
        this.negated = type.startsWith("not");
        this.in = type.endsWith("in block");
        this.types = this.settings.getStringList(MATERIAL).stream().map(s -> s.toUpperCase(Locale.US).replace(' ', '_')).collect(Collectors.toSet());
    }

    @Override
    boolean test(LivingEntity caster, int level, LivingEntity target) {
        Block in = target.getLocation().getBlock();
        Block tested = this.in ? in : in.getRelative(BlockFace.DOWN);
        return this.negated != this.types.contains(tested.getType().name());
    }
}

