/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.dynamic;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.CastData;
import studio.magemonkey.fabled.api.Settings;
import studio.magemonkey.fabled.api.particle.ParticleHelper;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;
import studio.magemonkey.fabled.dynamic.ComponentRegistry;
import studio.magemonkey.fabled.dynamic.ComponentType;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.log.Logger;

public abstract class EffectComponent {
    private static final String ICON_KEY = "icon-key";
    private static final String COUNTS_KEY = "counts";
    private static final String TYPE = "type";
    private static final String PREVIEW = "preview";
    private static boolean passed;
    public final List<EffectComponent> children = new ArrayList<EffectComponent>();
    protected final Settings settings = new Settings();
    private boolean isPreviewEnabled = false;
    protected final Settings preview = new Settings();
    protected DynamicSkill skill;
    private String instanceKey;

    private static String filterSpecialChars(String string) {
        int i = 0;
        int j = string.indexOf(38);
        StringBuilder builder = new StringBuilder();
        while (j >= 0) {
            String key;
            switch (key = string.substring(j + 1, j + 3)) {
                case "rc": {
                    builder.append(string, i, j);
                    builder.append('}');
                    i = j + 3;
                    break;
                }
                case "lc": {
                    builder.append(string, i, j);
                    builder.append('{');
                    i = j + 3;
                    break;
                }
                case "sq": {
                    builder.append(string, i, j);
                    builder.append('\'');
                    i = j + 3;
                    break;
                }
                default: {
                    ++i;
                }
            }
            j = string.indexOf(38, i);
        }
        builder.append(string.substring(i));
        return builder.toString();
    }

    public abstract String getKey();

    public abstract ComponentType getType();

    public boolean isPreviewEnabled() {
        return this.isPreviewEnabled;
    }

    public double parseValues(LivingEntity caster, String key, int level, double fallback) {
        double base = this.getNum(caster, key + "-base", fallback);
        double scale = this.getNum(caster, key + "-scale", 0.0);
        double value = base + (double)(level - 1) * scale;
        if (Fabled.getSettings().isAttributesEnabled() && caster instanceof Player) {
            PlayerData data = Fabled.getData((OfflinePlayer)((Player)caster));
            value = data.scaleDynamic(this, key, value);
        }
        return value;
    }

    protected double getNum(LivingEntity caster, String key, double fallback) {
        String val = this.settings.getString(key);
        if (val == null) {
            return fallback;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (Exception exception) {
            CastData castData = DynamicSkill.getCastData(caster);
            if (castData.contains(val)) {
                String mapVal = castData.get(val);
                try {
                    return Double.parseDouble(mapVal);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            try {
                int mid = val.indexOf(45, 1);
                double min = Double.parseDouble(val.substring(0, mid));
                double max = Double.parseDouble(val.substring(mid + 1));
                return Math.random() * (max - min) + min;
            }
            catch (Exception exception3) {
                return 0.0;
            }
        }
    }

    protected boolean lastPassed() {
        return passed;
    }

    protected boolean executeChildren(LivingEntity caster, int level, @NotNull List<LivingEntity> targets, boolean force) {
        if (targets.isEmpty()) {
            return false;
        }
        boolean worked = false;
        for (EffectComponent child : this.children) {
            boolean counts = !child.settings.getString(COUNTS_KEY, "true").equalsIgnoreCase("false");
            passed = child.execute(caster, level, targets, force);
            worked = passed && counts || worked;
        }
        return worked;
    }

    public void cleanUp(LivingEntity caster) {
        this.doCleanUp(caster);
        this.children.forEach(child -> child.cleanUp(caster));
    }

    protected void doCleanUp(LivingEntity caster) {
    }

    protected PlayerSkill getSkillData(LivingEntity caster) {
        if (caster instanceof Player) {
            return Fabled.getData((OfflinePlayer)((Player)caster)).getSkill(this.skill.getName());
        }
        return null;
    }

    protected String filter(LivingEntity caster, LivingEntity target, String text) {
        CastData data = DynamicSkill.getCastData(caster);
        String pattern = "\\{[^{}]+}";
        Pattern pat = Pattern.compile(pattern);
        LinkedHashMap<String, String> snipped = new LinkedHashMap<String, String>();
        Matcher match = pat.matcher(text);
        while (match.find()) {
            String key = match.group().substring(1, match.group().length() - 1);
            if (data.contains(key)) {
                text = text.replace(match.group(), data.get(key));
            } else if (key.equals("player")) {
                text = text.replace(match.group(), caster.getName());
            } else if (key.equals("target")) {
                text = text.replace(match.group(), target.getName());
            } else if (key.equals("targetUUID")) {
                text = text.replace(match.group(), target.getUniqueId().toString());
            } else {
                UUID uuid = UUID.randomUUID();
                snipped.put(uuid.toString(), key);
                text = text.replace(match.group(), uuid.toString());
            }
            match = pat.matcher(text);
        }
        ArrayList list = new ArrayList(snipped.entrySet());
        for (int i = list.size() - 1; i >= 0; --i) {
            Map.Entry entry = (Map.Entry)list.get(i);
            text = text.replace((CharSequence)entry.getKey(), "{" + (String)entry.getValue() + "}");
        }
        return EffectComponent.filterSpecialChars(text);
    }

    public boolean execute(LivingEntity caster, int level, List<LivingEntity> targets) {
        return this.execute(caster, level, targets, false);
    }

    public abstract boolean execute(LivingEntity var1, int var2, List<LivingEntity> var3, boolean var4);

    public void playPreview(List<Runnable> onPreviewStop, final Player caster, int level, final Supplier<List<LivingEntity>> targetSupplier) {
        if (this.preview.getBool("per-target")) {
            BukkitTask task = new BukkitRunnable(){

                public void run() {
                    for (LivingEntity target : (List)targetSupplier.get()) {
                        ParticleHelper.play(target.getLocation(), EffectComponent.this.preview, Set.of(caster), "per-target-", EffectComponent.this.preview.getBool("per-target-hitbox") ? target.getBoundingBox() : null);
                    }
                }
            }.runTaskTimer((Plugin)Fabled.inst(), 0L, (long)Math.max(1, this.preview.getInt("per-target-period", 5)));
            onPreviewStop.add(() -> ((BukkitTask)task).cancel());
        }
        this.playChildrenPreviews(onPreviewStop, caster, level, targetSupplier);
    }

    public void playChildrenPreviews(List<Runnable> onPreviewStop, Player caster, int level, Supplier<List<LivingEntity>> targetSupplier) {
        for (EffectComponent child : this.children) {
            child.playPreview(onPreviewStop, caster, level, targetSupplier);
        }
    }

    public void save(DataSection config) {
        config.set(TYPE, (Object)this.getType().name().toLowerCase());
        this.settings.save(config.createSection("data"));
        this.preview.save(config.createSection(PREVIEW));
        DataSection children = config.createSection("children");
        for (EffectComponent child : this.children) {
            child.save(children.createSection(child.instanceKey));
        }
    }

    public void load(DynamicSkill skill, DataSection config) {
        String key;
        this.skill = skill;
        if (config == null) {
            return;
        }
        this.settings.load(config.getSection("data"));
        if (this.settings.has(ICON_KEY) && !(key = this.settings.getString(ICON_KEY)).isBlank()) {
            skill.setAttribKey(key, this);
        }
        this.preview.load(config.getSection(PREVIEW));
        this.isPreviewEnabled = this.preview.getBool("enabled", false);
        DataSection children = config.getSection("children");
        if (children != null) {
            for (String key2 : children.keys()) {
                String typeName = children.getSection(key2).getString(TYPE, "missing").toUpperCase(Locale.US);
                ComponentType type = ComponentType.valueOf(typeName);
                String mkey = key2.replaceAll("-.+", "");
                try {
                    EffectComponent child = ComponentRegistry.getComponent(type, mkey);
                    if (child != null) {
                        child.instanceKey = key2;
                        child.load(skill, children.getSection(key2));
                        this.children.add(child);
                        continue;
                    }
                    Logger.invalid("Invalid " + String.valueOf((Object)type) + " component: " + mkey);
                }
                catch (Exception ex) {
                    Logger.bug("Failed to create " + String.valueOf((Object)type) + " component: " + key2);
                    ex.printStackTrace();
                }
            }
        }
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public String getInstanceKey() {
        return this.instanceKey;
    }
}

