/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.data.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.classes.FabledClass;
import studio.magemonkey.fabled.api.player.PlayerAccounts;
import studio.magemonkey.fabled.api.player.PlayerClass;
import studio.magemonkey.fabled.api.player.PlayerCombos;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.api.player.PlayerSkill;
import studio.magemonkey.fabled.api.player.PlayerSkillBar;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.cast.CastMode;
import studio.magemonkey.fabled.data.io.PlayerLoader;
import studio.magemonkey.fabled.listener.MainListener;
import studio.magemonkey.fabled.log.Logger;
import studio.magemonkey.fabled.manager.ComboManager;

public abstract class IOManager {
    private static final String LIMIT = "limit";
    private static final String ACTIVE = "active";
    private static final String ACCOUNTS = "accounts";
    private static final String ACCOUNT_PREFIX = "acc";
    private static final String HEALTH = "health";
    private static final String MANA = "mana";
    private static final String CLASSES = "classes";
    private static final String SKILLS = "skills";
    private static final String BINDS = "binds";
    private static final String LEVEL = "level";
    private static final String EXP = "exp";
    private static final String SHARED_POINTS = "shared-points";
    private static final String POINTS = "points";
    private static final String SKILL_BAR = "bar";
    private static final String HOVER = "hover";
    private static final String EXTRA = "extra";
    private static final String PERSISTENT = "persistent";
    private static final String INSTANT = "instant";
    private static final String TEXT_LAYOUT = "text-layout";
    private static final String ENABLED = "enabled";
    private static final String SLOTS = "slots";
    private static final String UNASSIGNED = "e";
    private static final String COMBOS = "combos";
    private static final String ATTRIBS = "attribs";
    private static final String ATTRSTAGES = "attrstages";
    private static final String COOLDOWN = "cd";
    private static final String HUNGER = "hunger";
    private static final String ATTRIB_POINTS = "attrib-points";
    protected final Fabled api;

    protected IOManager(Fabled api) {
        this.api = api;
    }

    public abstract Map<UUID, PlayerAccounts> loadAll();

    public abstract PlayerAccounts loadData(OfflinePlayer var1);

    public abstract void saveData(PlayerAccounts var1);

    public void saveAll() {
        for (PlayerAccounts data : PlayerLoader.getAllPlayerAccounts().values()) {
            if (!data.isLoaded() || MainListener.loadingPlayers.containsKey(data.getOfflinePlayer().getUniqueId())) continue;
            this.saveData(data);
        }
    }

    public static PlayerAccounts load(OfflinePlayer player, DataSection file) {
        PlayerAccounts data = new PlayerAccounts(player);
        DataSection accounts = file.getSection(ACCOUNTS);
        if (accounts == null) {
            data.getActiveData().endInit();
            data.isLoaded(true);
            return data;
        }
        for (String accountKey : accounts.keys()) {
            Object fabledClass;
            FabledClass fabledClass2;
            DataSection skills;
            Object classKey2;
            DataSection account = accounts.getSection(accountKey);
            PlayerData acc = null;
            try {
                acc = data.getData(Integer.parseInt(accountKey.replace(ACCOUNT_PREFIX, "")), player, true);
            }
            catch (NumberFormatException e) {
                Logger.bug("Could not parse account key '" + accountKey + "' for player " + String.valueOf(player.getUniqueId()));
                Logger.bug("This is related to ticket #154. Please paste the player's file and this stack trace.");
                Logger.bug("https://github.com/magemonkeystudio/fabled/issues/154");
                e.printStackTrace();
            }
            DataSection classes = account.getSection(CLASSES);
            if (classes != null) {
                for (Object classKey2 : classes.keys()) {
                    FabledClass fabledClass3 = Fabled.getClass((String)classKey2);
                    if (fabledClass3 == null) continue;
                    PlayerClass c = acc.setClass(null, fabledClass3, true);
                    DataSection classData = classes.getSection(classKey2);
                    int levels = classData.getInt(LEVEL);
                    if (levels > 0) {
                        c.setLevel(levels);
                    }
                    if (classData.has("total-exp")) {
                        c.setExp(classData.getDouble("total-exp") - c.getTotalExp());
                        continue;
                    }
                    c.setExp(classData.getDouble(EXP));
                }
            }
            if ((skills = account.getSection(SKILLS)) != null) {
                classKey2 = skills.keys().iterator();
                while (classKey2.hasNext()) {
                    String skillKey = (String)classKey2.next();
                    DataSection skill2 = skills.getSection(skillKey);
                    PlayerSkill skillData = acc.getSkill(skillKey);
                    if (skillData == null) continue;
                    skillData.setLevel(skill2.getInt(LEVEL));
                    skillData.addCooldown(skill2.getInt(COOLDOWN, 0));
                }
            }
            if (Fabled.getSettings().isSharedSkillPoints()) {
                if (account.has(SHARED_POINTS)) {
                    acc.setPoints(account.getInt(SHARED_POINTS, 0));
                    classKey2 = classes.keys().iterator();
                    while (classKey2.hasNext()) {
                        Object classKey3 = (String)classKey2.next();
                        fabledClass2 = Fabled.getClass((String)classKey3);
                        if (fabledClass2 == null) continue;
                        acc.getClass(fabledClass2.getGroup()).setEarnedPoints(classes.getSection((String)classKey3).getInt(POINTS, 0));
                    }
                } else {
                    int shared = 0;
                    for (String classKey4 : classes.keys()) {
                        fabledClass = Fabled.getClass(classKey4);
                        if (fabledClass == null) continue;
                        int current = classes.getSection(classKey4).getInt(POINTS, 0);
                        shared += current;
                        PlayerClass playerClass = acc.getClass(((FabledClass)fabledClass).getGroup());
                        playerClass.setEarnedPoints(current + acc.getSkills().stream().filter(skill -> skill.getPlayerClass() == playerClass).map(PlayerSkill::getInvestedCost).reduce(Integer::sum).orElse(0));
                    }
                    acc.setPoints(shared);
                }
            } else if (account.has(SHARED_POINTS)) {
                HashMap points = new HashMap();
                for (String classKey4 : classes.keys()) {
                    fabledClass = Fabled.getClass(classKey4);
                    if (fabledClass == null) continue;
                    PlayerClass playerClass = acc.getClass(((FabledClass)fabledClass).getGroup());
                    int current = classes.getSection(classKey4).getInt(POINTS, 0) - acc.getSkills().stream().filter(skill -> skill.getPlayerClass() == playerClass).map(PlayerSkill::getInvestedCost).reduce(Integer::sum).orElse(0);
                    playerClass.setPoints(current);
                    points.put(((FabledClass)fabledClass).getGroup(), current);
                }
            } else {
                for (Object classKey3 : classes.keys()) {
                    fabledClass2 = Fabled.getClass((String)classKey3);
                    if (fabledClass2 == null) continue;
                    acc.getClass(fabledClass2.getGroup()).setPoints(classes.getSection((String)classKey3).getInt(POINTS, 0));
                }
            }
            if (Fabled.getSettings().isSkillBarEnabled() || Fabled.getSettings().getCastMode().equals((Object)CastMode.COMBAT)) {
                DataSection skillBar = account.getSection(SKILL_BAR);
                PlayerSkillBar bar = acc.getSkillBar();
                if (skillBar != null && bar != null) {
                    boolean enabled = skillBar.getBoolean(ENABLED, true);
                    for (String key : skillBar.keys()) {
                        boolean[] locked = Fabled.getSettings().getLockedSlots();
                        if (key.equals(SLOTS)) {
                            for (int i = 0; i < 9; ++i) {
                                if (bar.isWeaponSlot(i) || locked[i]) continue;
                                bar.getData().remove(i + 1);
                            }
                            List slots = skillBar.getList(SLOTS);
                            for (String slot : slots) {
                                int i = Integer.parseInt(slot);
                                if (i < 1 || i > locked.length - 1) {
                                    Logger.invalid("Invalid skill bar slot: " + i);
                                    continue;
                                }
                                if (locked[i - 1]) continue;
                                bar.getData().put(i, UNASSIGNED);
                            }
                            continue;
                        }
                        if (Fabled.getSkill(key) == null) continue;
                        bar.getData().put(skillBar.getInt(key), key);
                    }
                    bar.applySettings();
                }
            }
            if (Fabled.getSettings().isCustomCombosAllowed()) {
                DataSection combos = account.getSection(COMBOS);
                PlayerCombos comboData = acc.getComboData();
                ComboManager cm = Fabled.getComboManager();
                if (combos != null && comboData != null) {
                    for (String key : combos.keys()) {
                        Skill skill3 = Fabled.getSkill(key);
                        if (!acc.hasSkill(key) || skill3 == null || !skill3.canCast()) continue;
                        int combo = cm.parseCombo(combos.getString(key));
                        if (combo == -1) {
                            Logger.invalid("Invalid skill combo: " + combos.getString(key));
                            continue;
                        }
                        comboData.setSkill(skill3, combo);
                    }
                }
            }
            if (Fabled.getSettings().isAttributesEnabled()) {
                acc.setAttribPoints(account.getInt(ATTRIB_POINTS, 0));
                DataSection attribs = account.getSection(ATTRIBS);
                DataSection attrstages = account.getSection(ATTRSTAGES);
                if (attribs != null) {
                    for (String key : attribs.keys()) {
                        acc.getAttributeData().put(key, attribs.getInt(key));
                    }
                }
                if (attrstages != null) {
                    for (String key : attrstages.keys()) {
                        acc.getAttributeStageData().put(key, attrstages.getInt(key));
                    }
                }
            }
            if (Fabled.getSettings().isCastEnabled()) {
                switch (Fabled.getSettings().getCastMode()) {
                    case BARS: {
                        acc.getCastBars().reset();
                        acc.getCastBars().load(account.getSection(HOVER), true);
                        acc.getCastBars().load(account.getSection(INSTANT), false);
                        break;
                    }
                    case ACTION_BAR: 
                    case TITLE: 
                    case SUBTITLE: 
                    case CHAT: {
                        acc.getTextCastingData().load(account.getSection(TEXT_LAYOUT));
                    }
                }
            }
            acc.setHungerValue(account.getDouble(HUNGER, 1.0));
            if (account.has(EXTRA) && account.getSection(EXTRA) != null) {
                acc.getExtraData().applyDefaults(account.getSection(EXTRA));
            }
            acc.endInit();
            DataSection persistent = account.getSection(PERSISTENT);
            if (persistent == null) continue;
            for (String key : persistent.keys()) {
                acc.getAllPersistentData().put(key, persistent.getString(key));
            }
        }
        data.setAccount(file.getInt(ACTIVE, data.getActiveId()), false);
        data.getActiveData().setLastHealth(file.getDouble(HEALTH));
        data.getActiveData().setMana(file.getDouble(MANA, data.getActiveData().getMana()));
        data.isLoaded(true);
        return data;
    }

    public static DataSection save(PlayerAccounts data) {
        try {
            DataSection file = new DataSection();
            file.set(LIMIT, (Object)data.getAccountLimit());
            file.set(ACTIVE, (Object)data.getActiveId());
            file.set(HEALTH, (Object)data.getActiveData().getLastHealth());
            file.set(MANA, (Object)data.getActiveData().getMana());
            DataSection accounts = file.createSection(ACCOUNTS);
            for (Map.Entry<Integer, PlayerData> entry : data.getAllData().entrySet()) {
                Object skill2;
                DataSection account = accounts.createSection(ACCOUNT_PREFIX + String.valueOf(entry.getKey()));
                PlayerData acc = entry.getValue();
                if (Fabled.getSettings().isSharedSkillPoints()) {
                    account.set(SHARED_POINTS, (Object)acc.getPoints());
                } else {
                    account.remove(SHARED_POINTS);
                }
                DataSection classes = account.createSection(CLASSES);
                for (PlayerClass playerClass : acc.getClasses()) {
                    DataSection classSection = classes.createSection(playerClass.getData().getName());
                    classSection.set(LEVEL, (Object)playerClass.getLevel());
                    if (Fabled.getSettings().isSharedSkillPoints()) {
                        classSection.set(POINTS, (Object)playerClass.getEarnedPoints());
                    } else {
                        classSection.set(POINTS, (Object)playerClass.getPoints());
                    }
                    classSection.set(EXP, (Object)playerClass.getExp());
                }
                DataSection skills = account.createSection(SKILLS);
                for (Object skill2 : acc.getSkills()) {
                    if (((PlayerSkill)skill2).isExternal()) continue;
                    DataSection dataSection = skills.createSection(((PlayerSkill)skill2).getData().getName());
                    dataSection.set(LEVEL, (Object)((PlayerSkill)skill2).getLevel());
                    if (!((PlayerSkill)skill2).isOnCooldown()) continue;
                    dataSection.set(COOLDOWN, (Object)((PlayerSkill)skill2).getCooldownLeft());
                }
                DataSection dataSection = account.createSection(BINDS);
                skill2 = acc.getBinds().entrySet().iterator();
                while (skill2.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)skill2.next();
                    if (entry2.getKey() == null || entry2.getValue() == null) continue;
                    dataSection.set(((Material)entry2.getKey()).name(), (Object)((PlayerSkill)entry2.getValue()).getData().getName());
                }
                if ((Fabled.getSettings().isSkillBarEnabled() || Fabled.getSettings().getCastMode().equals((Object)CastMode.COMBAT)) && acc.getSkillBar() != null) {
                    DataSection skillBar = account.createSection(SKILL_BAR);
                    PlayerSkillBar playerSkillBar = acc.getSkillBar();
                    skillBar.set(ENABLED, (Object)playerSkillBar.isEnabled());
                    skillBar.set(SLOTS, new ArrayList<Integer>(playerSkillBar.getData().keySet()));
                    for (Map.Entry entry3 : playerSkillBar.getData().entrySet()) {
                        if (((String)entry3.getValue()).equals(UNASSIGNED)) continue;
                        skillBar.set((String)entry3.getValue(), entry3.getKey());
                    }
                }
                if (Fabled.getSettings().isCustomCombosAllowed()) {
                    DataSection combos = account.createSection(COMBOS);
                    PlayerCombos playerCombos = acc.getComboData();
                    ComboManager cm = Fabled.getComboManager();
                    if (combos != null && playerCombos != null) {
                        HashMap<Integer, String> hashMap = playerCombos.getSkillMap();
                        for (Map.Entry<Integer, String> combo : hashMap.entrySet()) {
                            combos.set(combo.getValue(), (Object)cm.getSaveString(combo.getKey()));
                        }
                    }
                }
                if (Fabled.getSettings().isAttributesEnabled()) {
                    account.set(ATTRIB_POINTS, (Object)acc.getAttributePoints());
                    DataSection attribs = account.createSection(ATTRIBS);
                    DataSection dataSection2 = account.createSection(ATTRSTAGES);
                    for (String string : acc.getAttributeData().keySet()) {
                        attribs.set(string, (Object)acc.getAttributeData().get(string));
                    }
                    for (String string : acc.getAttributeStageData().keySet()) {
                        dataSection2.set(string, (Object)acc.getAttributeStageData().get(string));
                    }
                }
                if (Fabled.getSettings().isCastEnabled()) {
                    switch (Fabled.getSettings().getCastMode()) {
                        case BARS: {
                            acc.getCastBars().save(account.createSection(HOVER), true);
                            acc.getCastBars().save(account.createSection(INSTANT), false);
                            break;
                        }
                        case ACTION_BAR: 
                        case TITLE: 
                        case SUBTITLE: 
                        case CHAT: {
                            acc.getTextCastingData().save(account.createSection(TEXT_LAYOUT));
                        }
                    }
                }
                account.set(HUNGER, (Object)acc.getHungerValue());
                DataSection persistentData = account.createSection(PERSISTENT);
                acc.getAllPersistentData().forEach((arg_0, arg_1) -> ((DataSection)persistentData).set(arg_0, arg_1));
                if (acc.getExtraData().size() <= 0) continue;
                account.set(EXTRA, (Object)acc.getExtraData());
            }
            return file;
        }
        catch (Exception ex) {
            Logger.bug("Failed to save player data for " + data.getPlayer().getName());
            ex.printStackTrace();
            return null;
        }
    }
}

