/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.data.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.mccore.config.CommentedConfig;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.player.PlayerAccounts;
import studio.magemonkey.fabled.data.io.IOManager;
import studio.magemonkey.fabled.data.io.PlayerLoader;
import studio.magemonkey.fabled.log.Logger;

public class ConfigIO
extends IOManager {
    public ConfigIO(Fabled plugin) {
        super(plugin);
    }

    @Override
    public Map<UUID, PlayerAccounts> loadAll() {
        HashMap<UUID, PlayerAccounts> result = new HashMap<UUID, PlayerAccounts>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            result.put(player.getUniqueId(), this.loadData((OfflinePlayer)player));
        }
        return result;
    }

    @Override
    public PlayerAccounts loadData(OfflinePlayer player) {
        String playerKey = player.getUniqueId().toString().toLowerCase();
        CommentedConfig config = new CommentedConfig((JavaPlugin)this.api, "players/" + playerKey);
        CommentedConfig nameConfig = new CommentedConfig((JavaPlugin)this.api, "players/" + player.getName());
        if (!playerKey.equals(player.getName()) && nameConfig.getConfigFile().exists()) {
            DataSection old = nameConfig.getConfig();
            for (String key : old.keys()) {
                config.getConfig().set(key, old.get(key));
            }
            nameConfig.getConfigFile().delete();
        }
        DataSection file = config.getConfig();
        return ConfigIO.load(player, file);
    }

    @Override
    public void saveData(PlayerAccounts data) {
        if (!data.isLoaded()) {
            return;
        }
        try {
            CommentedConfig config = new CommentedConfig((JavaPlugin)this.api, "players/" + data.getOfflinePlayer().getUniqueId().toString().toLowerCase());
            config.clear();
            DataSection file = ConfigIO.save(data);
            config.getConfig().applyDefaults(file);
            config.save();
        }
        catch (Exception ex) {
            Logger.bug("Failed to save data for invalid player");
        }
    }

    @Override
    public void saveAll() {
        Map<UUID, PlayerAccounts> data = PlayerLoader.getAllPlayerAccounts();
        ArrayList<UUID> keys = new ArrayList<UUID>(data.keySet());
        for (UUID key : keys) {
            this.saveData(data.get(key));
        }
    }
}

