/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.java.JavaPlugin;
import studio.magemonkey.codex.mccore.config.CommentedConfig;
import studio.magemonkey.codex.mccore.config.parse.DataSection;
import studio.magemonkey.codex.mccore.config.parse.NumberParser;
import studio.magemonkey.codex.util.StringUT;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.CombatProtection;
import studio.magemonkey.fabled.api.DefaultCombatProtection;
import studio.magemonkey.fabled.api.player.PlayerClass;
import studio.magemonkey.fabled.api.skills.Skill;
import studio.magemonkey.fabled.cast.CastMode;
import studio.magemonkey.fabled.data.Click;
import studio.magemonkey.fabled.data.ExpFormula;
import studio.magemonkey.fabled.data.GroupSettings;
import studio.magemonkey.fabled.data.TitleType;
import studio.magemonkey.fabled.data.formula.Formula;
import studio.magemonkey.fabled.data.formula.value.CustomValue;
import studio.magemonkey.fabled.dynamic.DynamicSkill;
import studio.magemonkey.fabled.gui.tool.GUITool;
import studio.magemonkey.fabled.log.Logger;

public class Settings
extends com.sucy.skill.data.Settings {
    private static final String GUI_BASE = "GUI.";
    private static final String GUI_OLD = "GUI.old-health-bar";
    private static final String GUI_DOWNSCALE = "GUI.downscale-under";
    private static final String GUI_FORCE = "GUI.force-scaling";
    private static final String GUI_LVLBAR = "GUI.level-bar";
    private static final String GUI_FOOD = "GUI.food-bar";
    private static final String GUI_SATURATION = "GUI.block-saturation";
    private static final String GUI_ACTION = "GUI.use-action-bar";
    private static final String GUI_TEXT = "GUI.action-bar-text";
    private static final String GUI_NAME = "GUI.show-class-name";
    private static final String GUI_LEVEL = "GUI.show-class-level";
    private static final String GUI_BINDS = "GUI.show-binds";
    private static final String GUI_BIND_TEXT = "GUI.show-bind-text";
    private static final String GUI_LVLTXT = "GUI.class-level-text";
    private static final String GUI_TITLE = "GUI.title-enabled";
    private static final String GUI_DUR = "GUI.title-duration";
    private static final String GUI_FADEI = "GUI.title-fade-in";
    private static final String GUI_FADEO = "GUI.title-fade-out";
    private static final String GUI_LIST = "GUI.title-messages";
    private static final String DEFAULT_YIELD = "default";
    private static final String ACCOUNT_BASE = "Accounts.";
    private static final String ACCOUNT_MAIN = "Accounts.main-class-group";
    private static final String ACCOUNT_SHARED_SP = "Accounts.shared-skill-points";
    private static final String ACCOUNT_EACH = "Accounts.one-per-class";
    private static final String ACCOUNT_MAX = "Accounts.max-accounts";
    private static final String ACCOUNT_PERM = "Accounts.perm-accounts";
    private static final String TARGET_BASE = "Targeting.";
    private static final String TARGET_MONSTER = "Targeting.monsters-enemy";
    private static final String TARGET_PASSIVE = "Targeting.passive-ally";
    private static final String TARGET_PLAYER = "Targeting.player-ally";
    private static final String TARGET_NPC = "Targeting.affect-npcs";
    private static final String TARGET_STANDS = "Targeting.affect-armor-stands";
    private static final String SAVE_BASE = "Saving.";
    private static final String SAVE_AUTO = "Saving.auto-save";
    private static final String SAVE_MINS = "Saving.minutes";
    private static final String SAVE_SQL = "Saving.sql-database";
    private static final String SAVE_SQLD = "Saving.sql-details";
    private static final String CLASS_BASE = "Classes.";
    private static final String CLASS_MODIFY = "Classes.modify-health";
    private static final String CLASS_HP = "Classes.classless-hp";
    private static final String CLASS_SHOW = "Classes.show-auto-skills";
    private static final String CLASS_ATTRIB = "Classes.attributes-enabled";
    private static final String CLASS_REFUND = "Classes.attributes-downgrade";
    private static final String CLASS_REFUND_PRICE = "Classes.attributes-downgrade-price";
    private static final String CLASS_LEVEL = "Classes.level-up-skill";
    private static final String MANA_BASE = "Mana.";
    private static final String MANA_ENABLED = "Mana.enabled";
    private static final String MANA_FREQ = "Mana.freq";
    private static final String SKILL_BASE = "Skills.";
    private static final String SKILL_DOWNGRADE = "Skills.allow-downgrade";
    private static final String SKILL_MESSAGE = "Skills.show-messages";
    private static final String SKILL_RADIUS = "Skills.message-radius";
    private static final String SKILL_BLOCKS = "Skills.block-filter";
    private static final String SKILL_KNOCKBACK = "Skills.knockback-no-damage";
    private static final String SKILL_REFUND_ON_CHANGE = "Skills.refund-on-change";
    private static final String ITEM_BASE = "Items.";
    private static final String ITEM_LORE = "Items.lore-requirements";
    private static final String ITEM_DROP = "Items.drop-weapon";
    private static final String ITEM_SKILLS = "Items.skill-requirements";
    private static final String ITEM_ATTRIBS = "Items.lore-attributes";
    private static final String ITEM_CLASS = "Items.lore-class-text";
    private static final String ITEM_SKILL = "Items.lore-skill-text";
    private static final String ITEM_LEVEL = "Items.lore-level-text";
    private static final String ITEM_EXCLUDE = "Items.lore-exclude-text";
    private static final String ITEM_ATTR = "Items.lore-attribute-text";
    private static final String ITEM_STATS = "Items.attribute-text";
    private static final String ITEM_SLOTS = "Items.slots";
    private static final String PVP_BASE = "PVP.";
    private static final String PVP_MIN_LEVEL = "PVP.min-level";
    private static final String PVP_LEVEL_RANGE = "PVP.level-range";
    private static final String CAST_BASE = "Casting.";
    private static final String CAST_ENABLED = "Casting.enabled";
    private static final String CAST_MODE = "Casting.mode";
    private static final String CAST_SLOT = "Casting.slot";
    private static final String CAST_ITEM = "Casting.item";
    private static final String CAST_COOLDOWN = "Casting.cooldown";
    private static final String CAST_HOVER = "Casting.hover-item";
    private static final String CAST_INSTANT = "Casting.instant-item";
    private static final String CAST_FORMAT_SKILL = "Casting.message-mode-format.skill";
    private static final String CAST_FORMAT_SEPARATOR = "Casting.message-mode-format.separator";
    private static final String CAST_FORMAT_WHEEL_SELECTED_SKILL = "Casting.wheel.selected-skill";
    private static final String CAST_FORMAT_WHEEL_UNSELECTED_SKILL = "Casting.wheel.unselected-skill";
    private static final String CAST_FORMAT_WHEEL_PREVIOUS_SEPARATOR = "Casting.wheel.previous-separator";
    private static final String CAST_FORMAT_WHEEL_NEXT_SEPARATOR = "Casting.wheel.next-separator";
    private static final String CAST_FORMAT_WHEEL_SNEAK_TO_OFFHAND = "Casting.wheel.sneak-to-offhand";
    private static final String CAST_FORMAT_WHEEL_SNEAK_TO_SCROLL = "Casting.wheel.sneak-to-scroll";
    private static final String CAST_FORMAT_WHEEL_SOUNDS_START_CASTING = "Casting.wheel.sounds.start-casting";
    private static final String CAST_FORMAT_WHEEL_SOUNDS_STOP_CASTING = "Casting.wheel.sounds.stop-casting";
    private static final String CAST_FORMAT_WHEEL_SOUNDS_SCROLL = "Casting.wheel.sounds.scroll";
    private static final String CAST_FORMAT_WHEEL_SOUNDS_VOLUME = "Casting.wheel.sounds.volume";
    private static final String CAST_FORMAT_WHEEL_CAST_KEY = "Casting.wheel.cast-key";
    private static final String INTERACT_BASE = "Interaction";
    private static final String INTERACT_CLICK = "Interaction.interact-is-right-click";
    private static final String ANIMATION_LEFT_CLICK = "Interaction.animation-is-left-click";
    private static final String COMBO_BASE = "Click Combos.";
    private static final String COMBO_ENABLED = "Click Combos.enabled";
    private static final String COMBO_CUSTOM = "Click Combos.allow-custom";
    private static final String COMBO_CLICK = "Click Combos.use-click-";
    private static final String COMBO_SIZE = "Click Combos.combo-size";
    private static final String COMBO_TIME = "Click Combos.click-time";
    private static final String COMBO_AUTO = "Click Combos.auto-assign";
    private static final String EXP_BASE = "Experience.";
    private static final String WORLD_BASE = "Worlds.";
    private static final String WORLD_ENABLE = "Worlds.enable";
    private static final String WORLD_TYPE = "Worlds.use-as-enabling";
    private static final String WORLD_LIST = "Worlds.worlds";
    private static final String WG_SKILLS = "disable-skills";
    private static final String WG_EXP = "disable-exp";
    private final HashMap<String, Double> yields = new HashMap();
    private final HashMap<String, GroupSettings> groups = new HashMap();
    private final Fabled plugin;
    private final DataSection config;
    private final HashMap<String, Integer> permAccounts = new HashMap();
    private final List<String> monsterWorlds = new ArrayList<String>();
    private final List<String> passiveWorlds = new ArrayList<String>();
    private final List<String> playerWorlds = new ArrayList<String>();
    private final boolean[] defaultBarLayout = new boolean[9];
    private final boolean[] lockedSlots = new boolean[9];
    private boolean useBoundingBoxes;
    private Map<String, Map<String, Double>> breakYields;
    private Map<String, Map<String, Double>> placeYields;
    private Map<String, Map<String, Double>> craftYields;
    private boolean trackBreak;
    private boolean yieldsEnabled;
    private boolean onePerClass;
    private String mainGroup;
    private boolean sharedSkillPoints;
    private int maxAccounts;
    private boolean monsterEnemy;
    private boolean passiveAlly;
    private boolean playerAlly;
    private boolean affectNpcs;
    private boolean affectArmorStands;
    private CombatProtection combatProtection = new DefaultCombatProtection();
    private boolean auto;
    private boolean useSql;
    private int minutes;
    private int sqlDelay;
    private String sqlHost;
    private String sqlPort;
    private String sqlDatabase;
    private String sqlUser;
    private String sqlPass;
    private boolean modifyHealth;
    private int defaultHealth;
    private boolean showAutoSkills;
    private boolean attributesEnabled;
    private boolean attributesDowngrade;
    private int attributesDowngradePrice;
    private String levelUpSkill;
    private boolean manaEnabled;
    private int gainFreq;
    private ArrayList<Material> filteredBlocks;
    private boolean allowDowngrade;
    private boolean showSkillMessages;
    private boolean knockback;
    private int messageRadius;
    private boolean skillModelData;
    private boolean checkLore;
    private boolean checkAttributes;
    private boolean checkSkills;
    private boolean dropWeapon;
    private String loreClassText;
    private String loreLevelText;
    private String loreExcludeText;
    private int[] slots;
    private String skillPre;
    private String skillPost;
    private String attrReqPre;
    private String attrReqPost;
    private String attrPre;
    private String attrPost;
    private List<String> titleMessages;
    private boolean oldHealth;
    private boolean downScaling;
    private boolean forceScaling;
    private String levelBar;
    private String foodBar;
    private boolean blockSaturation;
    private boolean refundOnClassChange;
    private String levelText;
    private boolean useActionBar;
    private String actionText;
    private boolean showScoreboard;
    private boolean showClassName;
    private boolean showClassLevel;
    private boolean showBinds;
    private String bindText;
    private boolean useTitle;
    private int titleDuration;
    private int titleFadeIn;
    private int titleFadeOut;
    private int pvpLevelRange;
    private int pvpMinLevel;
    private boolean castEnabled;
    private CastMode castMode;
    private int castSlot;
    private long castCooldown;
    private ItemStack castItem;
    private ItemStack hoverItem;
    private ItemStack instantItem;
    private String messageFormatSkill;
    private String messageFormatSeparator;
    private String wheelFormatSelectedSkill;
    private String wheelFormatUnselectedSkill;
    private String wheelFormatPreviousSeparator;
    private String wheelFormatNextSeparator;
    private boolean wheelSneakToOffhand;
    private boolean wheelSneakToScroll;
    private String wheelSoundsStartCasting;
    private String wheelSoundsStopCasting;
    private String wheelSoundsScroll;
    private int wheelSoundsVolume;
    private String wheelCastKey;
    private boolean[] enabledClicks;
    private boolean combosEnabled;
    private boolean customCombosAllowed;
    private boolean shouldAutoAssignCombos;
    private int comboSize;
    private int clickTime;
    private List<Integer> levelsExp;
    private ExpFormula expFormula;
    private Formula expCustom;
    private boolean useCustomExp;
    private boolean useOrbs;
    private boolean blockSpawner;
    private boolean blockEgg;
    private boolean blockCreative;
    private boolean showExpMessages;
    private boolean showLevelMessages;
    private boolean showLossExpMessages;
    private boolean showLossLevelMessages;
    private Set<String> expLostBlacklist;
    private boolean skillBarEnabled;
    private boolean skillBarCooldowns;
    private ItemStack unassigned;
    private boolean interactRightClick;
    private boolean animationLeftClick;
    private List<String> worlds;
    private boolean worldEnabled;
    private boolean worldEnableList;
    private Set<String> skillDisabledRegions;
    private Set<String> expDisabledRegions;

    public Settings(Fabled plugin) {
        this.plugin = plugin;
        CommentedConfig file = new CommentedConfig((JavaPlugin)plugin, "config");
        file.checkDefaults();
        file.trim();
        file.save();
        this.config = file.getConfig();
    }

    public void reload() {
        try {
            Entity.class.getMethod("getBoundingBox", new Class[0]);
            this.useBoundingBoxes = true;
        }
        catch (NoSuchMethodException e) {
            this.useBoundingBoxes = false;
        }
        this.loadExperienceSettings();
        this.loadAccountSettings();
        this.loadClassSettings();
        this.loadManaSettings();
        this.loadSkillSettings();
        this.loadItemSettings();
        this.loadGUISettings();
        this.loadPVPSettings();
        this.loadCastSettings();
        this.loadInteractionSettings();
        this.loadComboSettings();
        this.loadExpSettings();
        this.loadSkillBarSettings();
        this.loadLoggingSettings();
        this.loadWorldSettings();
        this.loadSaveSettings();
        this.loadTargetingSettings();
        this.loadWorldGuardSettings();
    }

    public void loadExperienceSettings() {
        CommentedConfig file = new CommentedConfig((JavaPlugin)this.plugin, "exp");
        file.checkDefaults();
        file.save();
        DataSection config = file.getConfig();
        DataSection breakData = config.getSection("break");
        this.yieldsEnabled = config.getBoolean("enabled", false);
        this.trackBreak = breakData.getBoolean("allow-replace", true);
        this.breakYields = this.loadYields(breakData.getSection("types"));
        this.placeYields = this.loadYields(config.getSection("place"));
        this.craftYields = this.loadYields(config.getSection("craft"));
    }

    private Map<String, Map<String, Double>> loadYields(DataSection config) {
        HashMap<String, Map<String, Double>> yields = new HashMap<String, Map<String, Double>>();
        for (String className : config.keys()) {
            HashMap<String, Double> map = new HashMap<String, Double>();
            DataSection classYields = config.getSection(className);
            for (String type : classYields.keys()) {
                map.put(type.toUpperCase(Locale.US).replace(" ", "_"), classYields.getDouble(type));
            }
            yields.put(className, map);
        }
        return yields;
    }

    public double getBreakYield(PlayerClass playerClass, Material mat) {
        return this.getYield(this.breakYields, playerClass, mat.name());
    }

    public double getPlaceYield(PlayerClass playerClass, Material mat) {
        return this.getYield(this.placeYields, playerClass, mat.name());
    }

    public double getCraftYield(PlayerClass playerClass, Material mat) {
        return this.getYield(this.craftYields, playerClass, mat.name());
    }

    private double getYield(Map<String, Map<String, Double>> yields, PlayerClass playerClass, String key) {
        double yield = this.getYield(yields.get(playerClass.getData().getName()), key);
        return yield > 0.0 ? yield : this.getYield(yields.get(DEFAULT_YIELD), key);
    }

    private double getYield(Map<String, Double> yields, String key) {
        return yields == null ? 0.0 : (yields.containsKey(key) ? yields.get(key) : 0.0);
    }

    public void loadGroupSettings() {
        CommentedConfig file = new CommentedConfig((JavaPlugin)this.plugin, "groups");
        DataSection config = file.getConfig();
        this.groups.clear();
        for (String key : config.keys()) {
            this.groups.put(key.toLowerCase(), new GroupSettings(config.getSection(key)));
        }
        for (String group : Fabled.getGroups()) {
            if (!this.groups.containsKey(group.toLowerCase())) {
                GroupSettings settings = new GroupSettings();
                this.groups.put(group.toLowerCase(), settings);
                settings.save(config.createSection(group.toLowerCase()));
            }
            config.setComments(group.toLowerCase(), (List)ImmutableList.of((Object)"", (Object)(" Settings for classes with the group " + group), (Object)" If new classes are loaded with different groups,", (Object)" the new groups will show up in this file after the first load."));
        }
        file.save();
    }

    public GroupSettings getGroupSettings(String group) {
        if (!this.groups.containsKey(group.toLowerCase())) {
            return new GroupSettings();
        }
        return this.groups.get(group.toLowerCase());
    }

    public int getMaxAccounts(Player player) {
        if (player == null) {
            return this.getMaxAccounts();
        }
        int max = this.getMaxAccounts();
        for (Map.Entry<String, Integer> entry : this.permAccounts.entrySet()) {
            if (!player.hasPermission(entry.getKey())) continue;
            max = Math.max(max, entry.getValue());
        }
        for (PermissionAttachmentInfo permission : player.getEffectivePermissions()) {
            String permString = permission.getPermission();
            if (!permString.startsWith("fabled.max_accounts")) continue;
            try {
                max = Math.max(max, Integer.parseInt(permString.substring("fabled.max_accounts".length() + 1)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return max;
    }

    private void loadAccountSettings() {
        this.mainGroup = this.config.getString(ACCOUNT_MAIN);
        this.sharedSkillPoints = this.config.getBoolean(ACCOUNT_SHARED_SP);
        this.onePerClass = this.config.getBoolean(ACCOUNT_EACH);
        this.maxAccounts = this.config.getInt(ACCOUNT_MAX);
        List list = this.config.getList(ACCOUNT_PERM);
        for (String item : list) {
            String[] pieces;
            if (!item.contains(":") || (pieces = item.split(":")).length != 2) continue;
            try {
                this.permAccounts.put(pieces[0], Integer.parseInt(pieces[1]));
            }
            catch (Exception exception) {}
        }
    }

    public boolean canAttack(LivingEntity attacker, LivingEntity target) {
        return this.canAttack(attacker, target, EntityDamageEvent.DamageCause.CUSTOM);
    }

    public boolean canAttack(LivingEntity attacker, LivingEntity target, EntityDamageEvent.DamageCause cause) {
        Tameable tameable;
        if (attacker.equals((Object)target)) {
            return true;
        }
        if (attacker instanceof Player && target instanceof Player) {
            if (this.playerAlly) {
                return false;
            }
            if (this.playerWorlds.contains(target.getWorld().getName())) {
                return false;
            }
            return CombatProtection.canAttack(attacker, target, this.passiveAlly, cause);
        }
        if (attacker instanceof Tameable && (tameable = (Tameable)attacker).isTamed() && tameable.getOwner() instanceof LivingEntity) {
            return tameable.getOwner() != target && this.canAttack((LivingEntity)tameable.getOwner(), target);
        }
        if (target instanceof Monster && (this.monsterEnemy || this.monsterWorlds.contains(attacker.getWorld().getName()))) {
            return true;
        }
        if (target instanceof Animals && (this.passiveAlly || this.passiveWorlds.contains(attacker.getWorld().getName()))) {
            return false;
        }
        return CombatProtection.canAttack(attacker, target, this.passiveAlly, cause);
    }

    @Override
    public boolean isAlly(LivingEntity attacker, LivingEntity target) {
        return !this.canAttack(attacker, target) || target instanceof Wolf && ((Wolf)target).isTamed() && attacker.equals((Object)((Wolf)target).getOwner());
    }

    public boolean isValidTarget(LivingEntity target) {
        return !(target.hasMetadata("NPC") && !this.affectNpcs || target.getType().name().equals("ARMOR_STAND") && !this.affectArmorStands);
    }

    private void loadTargetingSettings() {
        if (this.config.isList(TARGET_MONSTER)) {
            this.monsterWorlds.addAll(this.config.getList(TARGET_MONSTER));
            this.monsterEnemy = false;
        } else {
            this.monsterEnemy = this.config.getBoolean(TARGET_MONSTER);
        }
        if (this.config.isList(TARGET_PASSIVE)) {
            this.passiveWorlds.addAll(this.config.getList(TARGET_PASSIVE));
            this.passiveAlly = false;
        } else {
            this.passiveAlly = this.config.getBoolean(TARGET_PASSIVE);
        }
        if (this.config.isList(TARGET_PLAYER)) {
            this.playerWorlds.addAll(this.config.getList(TARGET_PLAYER));
            this.playerAlly = false;
        } else {
            this.playerAlly = this.config.getBoolean(TARGET_PLAYER);
        }
        this.affectArmorStands = this.config.getBoolean(TARGET_STANDS);
        this.affectNpcs = this.config.getBoolean(TARGET_NPC);
    }

    public boolean isAutoSave() {
        return this.auto;
    }

    public int getSaveFreq() {
        return this.minutes * 60 * 20;
    }

    private void loadSaveSettings() {
        this.auto = this.config.getBoolean(SAVE_AUTO);
        this.minutes = this.config.getInt(SAVE_MINS);
        this.useSql = this.config.getBoolean(SAVE_SQL);
        DataSection details = this.config.getSection(SAVE_SQLD);
        this.sqlDelay = details.getInt("delay");
        if (this.useSql) {
            this.sqlHost = details.getString("host");
            this.sqlPort = details.getString("port");
            this.sqlDatabase = details.getString("database");
            this.sqlUser = details.getString("username");
            this.sqlPass = details.getString("password");
        }
    }

    public boolean isShowingAutoSkills() {
        return this.showAutoSkills;
    }

    public boolean hasLevelUpEffect() {
        return this.getLevelUpSkill() != null;
    }

    public DynamicSkill getLevelUpSkill() {
        Skill skill = Fabled.getSkill(this.levelUpSkill);
        return skill instanceof DynamicSkill ? (DynamicSkill)skill : null;
    }

    private void loadClassSettings() {
        this.modifyHealth = this.config.getBoolean(CLASS_MODIFY);
        this.defaultHealth = this.config.getInt(CLASS_HP);
        this.showAutoSkills = this.config.getBoolean(CLASS_SHOW);
        this.attributesEnabled = this.config.getBoolean(CLASS_ATTRIB);
        this.attributesDowngrade = this.config.getBoolean(CLASS_REFUND);
        this.attributesDowngradePrice = this.config.getInt(CLASS_REFUND_PRICE);
        this.levelUpSkill = this.config.getString(CLASS_LEVEL);
    }

    private void loadManaSettings() {
        this.manaEnabled = this.config.getBoolean(MANA_ENABLED);
        this.gainFreq = (int)(this.config.getDouble(MANA_FREQ) * 20.0);
    }

    private void loadSkillSettings() {
        this.allowDowngrade = this.config.getBoolean(SKILL_DOWNGRADE);
        this.showSkillMessages = this.config.getBoolean(SKILL_MESSAGE);
        this.messageRadius = this.config.getInt(SKILL_RADIUS);
        this.knockback = this.config.getBoolean(SKILL_KNOCKBACK);
        this.refundOnClassChange = this.config.getBoolean(SKILL_REFUND_ON_CHANGE);
        this.filteredBlocks = new ArrayList();
        List list = this.config.getList(SKILL_BLOCKS);
        for (String item : list) {
            if ((item = item.toUpperCase(Locale.US).replace(' ', '_')).endsWith("*")) {
                item = item.substring(0, item.length() - 1);
                for (Material mat : Material.values()) {
                    if (!mat.name().contains(item)) continue;
                    this.filteredBlocks.add(mat);
                }
                continue;
            }
            try {
                Material mat = Material.valueOf((String)item);
                this.filteredBlocks.add(mat);
            }
            catch (Exception ex) {
                Logger.invalid("Invalid block type \"" + item + "\"");
            }
        }
    }

    public String getSkillText(String skill) {
        return this.skillPre + skill + this.skillPost;
    }

    public String getAttrReqText(String attr) {
        return this.attrReqPre + attr + this.attrReqPost;
    }

    public String getAttrGiveText(String attr) {
        return this.attrPre + attr + this.attrPost;
    }

    private void loadItemSettings() {
        this.checkLore = this.config.getBoolean(ITEM_LORE);
        this.dropWeapon = this.config.getBoolean(ITEM_DROP);
        this.checkSkills = this.config.getBoolean(ITEM_SKILLS);
        this.checkAttributes = this.config.getBoolean(ITEM_ATTRIBS);
        this.loreClassText = this.config.getString(ITEM_CLASS).toLowerCase();
        this.loreLevelText = this.config.getString(ITEM_LEVEL).toLowerCase();
        this.loreExcludeText = this.config.getString(ITEM_EXCLUDE).toLowerCase();
        String temp = this.config.getString(ITEM_SKILL).toLowerCase();
        int index = temp.indexOf(123);
        this.skillPre = temp.substring(0, index);
        this.skillPost = temp.substring(index + 7);
        temp = this.config.getString(ITEM_ATTR).toLowerCase();
        index = temp.indexOf(123);
        this.attrReqPre = temp.substring(0, index);
        this.attrReqPost = temp.substring(index + 6);
        temp = this.config.getString(ITEM_STATS).toLowerCase();
        index = temp.indexOf(123);
        this.attrPre = temp.substring(0, index);
        this.attrPost = temp.substring(index + 6);
        List slotList = this.config.getList(ITEM_SLOTS);
        this.slots = new int[slotList.size()];
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = NumberParser.parseInt((String)((String)slotList.get(i)));
        }
    }

    public boolean useTitle(TitleType type) {
        return this.useTitle && type != null && this.titleMessages.contains(type.name().toLowerCase());
    }

    private void loadGUISettings() {
        this.oldHealth = this.config.getBoolean(GUI_OLD);
        this.downScaling = this.config.getBoolean(GUI_DOWNSCALE);
        this.forceScaling = this.config.getBoolean(GUI_FORCE);
        this.levelBar = this.config.getString(GUI_LVLBAR);
        this.levelText = StringUT.color((String)this.config.getString(GUI_LVLTXT, "Level"));
        this.foodBar = this.config.getString(GUI_FOOD);
        this.blockSaturation = this.config.getBoolean(GUI_SATURATION, true);
        this.useActionBar = this.config.getBoolean(GUI_ACTION);
        this.actionText = this.config.getString(GUI_TEXT);
        this.showScoreboard = this.config.getBoolean("scoreboard.enabled");
        this.showClassName = this.config.getBoolean(GUI_NAME);
        this.showClassLevel = this.config.getBoolean(GUI_LEVEL);
        this.showBinds = this.config.getBoolean(GUI_BINDS);
        this.bindText = this.config.getString(GUI_BIND_TEXT);
        this.useTitle = this.config.getBoolean(GUI_TITLE);
        this.titleDuration = (int)(20.0f * this.config.getFloat(GUI_DUR));
        this.titleFadeIn = (int)(20.0f * this.config.getFloat(GUI_FADEI));
        this.titleFadeOut = (int)(20.0f * this.config.getFloat(GUI_FADEO));
        this.titleMessages = this.config.getList(GUI_LIST);
    }

    public ItemStack getCastItem() {
        return this.castItem.clone();
    }

    public ItemStack getHoverItem() {
        return this.hoverItem.clone();
    }

    public ItemStack getInstantItem() {
        return this.instantItem.clone();
    }

    private void loadPVPSettings() {
        this.pvpMinLevel = this.config.getInt(PVP_MIN_LEVEL, -1);
        this.pvpLevelRange = this.config.getInt(PVP_LEVEL_RANGE, -1);
    }

    private void loadCastSettings() {
        this.castEnabled = this.config.getBoolean(CAST_ENABLED);
        try {
            this.castMode = CastMode.valueOf(this.config.getString(CAST_MODE).toUpperCase(Locale.US).replace('-', '_'));
        }
        catch (IllegalArgumentException e) {
            this.castMode = CastMode.BARS;
            this.config.set(CAST_MODE, (Object)CastMode.BARS.name().toLowerCase());
        }
        this.castSlot = this.config.getInt(CAST_SLOT) - 1;
        this.castCooldown = (long)(this.config.getDouble(CAST_COOLDOWN) * 1000.0);
        this.castItem = GUITool.markCastItem(GUITool.parseItem(this.config.getSection(CAST_ITEM)));
        this.hoverItem = GUITool.markCastItem(GUITool.parseItem(this.config.getSection(CAST_HOVER)));
        this.instantItem = GUITool.markCastItem(GUITool.parseItem(this.config.getSection(CAST_INSTANT)));
        this.messageFormatSkill = this.config.getString(CAST_FORMAT_SKILL, "&6[%number%] &a%skill%");
        this.messageFormatSeparator = this.config.getString(CAST_FORMAT_SEPARATOR, "&7 - ");
        this.wheelFormatSelectedSkill = this.config.getString(CAST_FORMAT_WHEEL_SELECTED_SKILL, "&6[%number%] &a%skill%");
        this.wheelFormatUnselectedSkill = this.config.getString(CAST_FORMAT_WHEEL_UNSELECTED_SKILL, "&6[%number%] &a%skill%");
        this.wheelFormatPreviousSeparator = this.config.getString(CAST_FORMAT_WHEEL_PREVIOUS_SEPARATOR, "&7<-");
        this.wheelFormatNextSeparator = this.config.getString(CAST_FORMAT_WHEEL_NEXT_SEPARATOR, "&7->");
        this.wheelSneakToOffhand = this.config.getBoolean(CAST_FORMAT_WHEEL_SNEAK_TO_OFFHAND, true);
        this.wheelSneakToScroll = this.config.getBoolean(CAST_FORMAT_WHEEL_SNEAK_TO_SCROLL, true);
        this.wheelSoundsStartCasting = this.config.getString(CAST_FORMAT_WHEEL_SOUNDS_START_CASTING, "None");
        this.wheelSoundsStopCasting = this.config.getString(CAST_FORMAT_WHEEL_SOUNDS_STOP_CASTING, "None");
        this.wheelSoundsScroll = this.config.getString(CAST_FORMAT_WHEEL_SOUNDS_SCROLL, "None");
        this.wheelSoundsVolume = this.config.getInt(CAST_FORMAT_WHEEL_SOUNDS_VOLUME, 100);
        this.wheelCastKey = this.config.getString(CAST_FORMAT_WHEEL_CAST_KEY, "LEFT_CLICK");
        this.castEnabled = this.castEnabled && this.castItem != null;
    }

    private void loadInteractionSettings() {
        this.interactRightClick = this.config.getBoolean(INTERACT_CLICK);
        this.animationLeftClick = this.config.getBoolean(ANIMATION_LEFT_CLICK);
    }

    private void loadComboSettings() {
        this.combosEnabled = this.config.getBoolean(COMBO_ENABLED);
        this.customCombosAllowed = this.combosEnabled && this.config.getBoolean(COMBO_CUSTOM);
        this.shouldAutoAssignCombos = this.combosEnabled && this.config.getBoolean(COMBO_AUTO, true);
        this.comboSize = this.config.getInt(COMBO_SIZE);
        this.clickTime = (int)(1000.0 * this.config.getDouble(COMBO_TIME));
        this.enabledClicks = new boolean[Click.values().length + 1];
        for (int i = 1; i <= Click.values().length; ++i) {
            Click click = Click.getById(i);
            if (click == null) continue;
            String key = COMBO_CLICK + click.name().toLowerCase().replace('_', '-');
            this.enabledClicks[i] = this.config.getBoolean(key);
        }
        if (this.enabledClicks[Click.RIGHT_SHIFT.getId()] || this.enabledClicks[Click.LEFT_SHIFT.getId()]) {
            this.enabledClicks[Click.SHIFT.getId()] = false;
        }
    }

    public int getRequiredExp(int level) {
        if (this.levelsExp != null) {
            return level - 1 >= this.levelsExp.size() ? this.levelsExp.get(this.levelsExp.size() - 1) : this.levelsExp.get(level - 1);
        }
        if (this.useCustomExp) {
            double result = this.expCustom.compute(level, 0.0);
            return (int)result;
        }
        return this.expFormula.calculate(level);
    }

    public double getYield(String mob) {
        if (!this.yields.containsKey(mob = mob.toLowerCase())) {
            return 0.0;
        }
        return this.yields.get(mob);
    }

    public boolean shouldIgnoreExpLoss(World world) {
        return this.expLostBlacklist.contains(world.getName());
    }

    private void loadExpSettings() {
        this.useOrbs = this.config.getBoolean("Experience.use-exp-orbs");
        this.blockSpawner = this.config.getBoolean("Experience.block-mob-spawner");
        this.blockEgg = this.config.getBoolean("Experience.block-mob-egg");
        this.blockCreative = this.config.getBoolean("Experience.block-creative");
        this.showExpMessages = this.config.getBoolean("Experience.exp-message-enabled");
        this.showLevelMessages = this.config.getBoolean("Experience.level-message-enabled");
        this.showLossExpMessages = this.config.getBoolean("Experience.lose-exp-message");
        this.showLossLevelMessages = this.config.getBoolean("Experience.lose-level-message");
        this.expLostBlacklist = new HashSet<String>(this.config.getList("Experience.lose-exp-blacklist"));
        CommentedConfig levelsConfig = Fabled.getConfig("levels");
        levelsConfig.saveDefaultConfig();
        if (this.config.getBoolean("Experience.use-levels", false)) {
            ArrayList<Integer> levelsExp = new ArrayList<Integer>();
            try {
                for (String line : levelsConfig.getConfig().getList("level-exp")) {
                    levelsExp.add(Integer.parseInt(line));
                }
                if (levelsExp.isEmpty()) {
                    throw new IndexOutOfBoundsException();
                }
                this.levelsExp = levelsExp;
            }
            catch (IndexOutOfBoundsException | NumberFormatException e) {
                Fabled.inst().getLogger().warning("Failed to load levels.yml, resorting to exp formula");
            }
        }
        if (this.levelsExp == null) {
            DataSection formula = this.config.getSection("Experience.formula");
            int x = formula.getInt("x");
            int y = formula.getInt("y");
            int z = formula.getInt("z");
            this.expFormula = new ExpFormula(x, y, z);
            this.expCustom = new Formula(this.config.getString("Experience.custom-formula"), new CustomValue("lvl"));
            this.useCustomExp = this.config.getBoolean("Experience.use-custom") && this.expCustom.isValid();
        }
        DataSection yields = this.config.getSection("Experience.yields");
        this.yields.clear();
        for (String key : yields.keys()) {
            this.yields.put(key, yields.getDouble(key));
        }
    }

    private void loadSkillBarSettings() {
        DataSection bar = this.config.getSection("Skill Bar");
        this.skillBarEnabled = bar.getBoolean("enabled", false) && !this.castEnabled;
        this.skillBarCooldowns = bar.getBoolean("show-cooldown", true);
        DataSection icon = bar.getSection("empty-icon");
        Material mat = Material.matchMaterial((String)icon.getString("material", "PUMPKIN_SEEDS"));
        if (mat == null) {
            mat = Material.PUMPKIN_SEEDS;
        }
        this.unassigned = new ItemStack(mat);
        ItemMeta meta = this.unassigned.getItemMeta();
        if (meta != null) {
            int data = icon.getInt("data", 0);
            if (data != 0) {
                meta.setCustomModelData(Integer.valueOf(data));
            }
            if (icon.isList("text")) {
                List format = StringUT.color((List)icon.getList("text"));
                meta.setDisplayName((String)format.remove(0));
                meta.setLore(format);
            } else {
                meta.setDisplayName(StringUT.color((String)icon.getString("text", "&7Unassigned")));
            }
            if (meta instanceof Damageable) {
                ((Damageable)meta).setDamage(icon.getInt("durability", 0));
            }
            this.unassigned.setItemMeta(meta);
            DataSection layout = bar.getSection("layout");
            int skillCount = 0;
            for (int i = 0; i < 9; ++i) {
                DataSection slot = layout.getSection("" + (i + 1));
                this.defaultBarLayout[i] = slot.getBoolean("skill", i <= 5);
                this.lockedSlots[i] = slot.getBoolean("locked", false);
                if (this.castMode.equals((Object)CastMode.COMBAT) && i == this.castSlot) {
                    this.lockedSlots[i] = true;
                    this.defaultBarLayout[i] = false;
                }
                if (!this.defaultBarLayout[i]) continue;
                ++skillCount;
            }
            if (skillCount == 9) {
                Logger.invalid("Invalid Skill Bar Setup - Cannot have all 9 skill slots!");
                Logger.invalid("  -> Setting last slot to be a weapon slot");
                this.defaultBarLayout[8] = false;
            }
        }
    }

    private void loadLoggingSettings() {
        Logger.loadLevels(this.config.getSection("Logging"));
    }

    public boolean isWorldEnabled(World world) {
        return this.isWorldEnabled(world.getName());
    }

    public boolean isWorldEnabled(String world) {
        return !this.worldEnabled || this.worldEnableList == this.worlds.contains(world);
    }

    private void loadWorldSettings() {
        this.worldEnabled = this.config.getBoolean(WORLD_ENABLE);
        this.worldEnableList = this.config.getBoolean(WORLD_TYPE);
        this.worlds = this.config.getList(WORLD_LIST);
    }

    public boolean areSkillsDisabledForRegion(String region) {
        return this.skillDisabledRegions.contains(region);
    }

    public boolean isExpDisabledForRegion(String region) {
        return this.expDisabledRegions.contains(region);
    }

    private void loadWorldGuardSettings() {
        CommentedConfig config = new CommentedConfig((JavaPlugin)this.plugin, "worldGuard");
        config.checkDefaults();
        config.trim();
        config.save();
        DataSection data = config.getConfig();
        this.skillDisabledRegions = ImmutableSet.copyOf((Collection)data.getList(WG_SKILLS));
        this.expDisabledRegions = ImmutableSet.copyOf((Collection)data.getList(WG_EXP));
    }

    public List<String> getScoreboardFormat() {
        return this.config.getList("scoreboard.format");
    }

    public String getScoreboardTitle() {
        return this.config.getString("scoreboard.title");
    }

    @Generated
    public boolean[] getDefaultBarLayout() {
        return this.defaultBarLayout;
    }

    @Generated
    public boolean[] getLockedSlots() {
        return this.lockedSlots;
    }

    @Generated
    public boolean useBoundingBoxes() {
        return this.useBoundingBoxes;
    }

    @Generated
    public boolean isTrackBreak() {
        return this.trackBreak;
    }

    @Generated
    public boolean isYieldsEnabled() {
        return this.yieldsEnabled;
    }

    @Generated
    public boolean isOnePerClass() {
        return this.onePerClass;
    }

    @Generated
    public String getMainGroup() {
        return this.mainGroup;
    }

    @Generated
    public boolean isSharedSkillPoints() {
        return this.sharedSkillPoints;
    }

    @Generated
    public int getMaxAccounts() {
        return this.maxAccounts;
    }

    @Generated
    public boolean isPassiveAlly() {
        return this.passiveAlly;
    }

    @Generated
    public void setPassiveAlly(boolean passiveAlly) {
        this.passiveAlly = passiveAlly;
    }

    @Generated
    public void setCombatProtection(CombatProtection combatProtection) {
        this.combatProtection = combatProtection;
    }

    @Generated
    public boolean isUseSql() {
        return this.useSql;
    }

    @Generated
    public int getSqlDelay() {
        return this.sqlDelay;
    }

    @Generated
    public String getSqlHost() {
        return this.sqlHost;
    }

    @Generated
    public String getSqlPort() {
        return this.sqlPort;
    }

    @Generated
    public String getSqlDatabase() {
        return this.sqlDatabase;
    }

    @Generated
    public String getSqlUser() {
        return this.sqlUser;
    }

    @Generated
    public String getSqlPass() {
        return this.sqlPass;
    }

    @Generated
    public boolean isModifyHealth() {
        return this.modifyHealth;
    }

    @Generated
    public int getDefaultHealth() {
        return this.defaultHealth;
    }

    @Generated
    public boolean isAttributesEnabled() {
        return this.attributesEnabled;
    }

    @Generated
    public boolean isAttributesDowngrade() {
        return this.attributesDowngrade;
    }

    @Generated
    public int getAttributesDowngradePrice() {
        return this.attributesDowngradePrice;
    }

    @Generated
    public boolean isManaEnabled() {
        return this.manaEnabled;
    }

    @Generated
    public int getGainFreq() {
        return this.gainFreq;
    }

    @Generated
    public ArrayList<Material> getFilteredBlocks() {
        return this.filteredBlocks;
    }

    @Generated
    public boolean isAllowDowngrade() {
        return this.allowDowngrade;
    }

    @Generated
    public boolean isShowSkillMessages() {
        return this.showSkillMessages;
    }

    @Generated
    public boolean isKnockback() {
        return this.knockback;
    }

    @Generated
    public int getMessageRadius() {
        return this.messageRadius;
    }

    @Generated
    public boolean isCheckLore() {
        return this.checkLore;
    }

    @Generated
    public boolean isCheckAttributes() {
        return this.checkAttributes;
    }

    @Generated
    public boolean isCheckSkills() {
        return this.checkSkills;
    }

    @Generated
    public boolean isDropWeapon() {
        return this.dropWeapon;
    }

    @Generated
    public String getLoreClassText() {
        return this.loreClassText;
    }

    @Generated
    public String getLoreLevelText() {
        return this.loreLevelText;
    }

    @Generated
    public String getLoreExcludeText() {
        return this.loreExcludeText;
    }

    @Generated
    public int[] getSlots() {
        return this.slots;
    }

    @Generated
    public boolean isOldHealth() {
        return this.oldHealth;
    }

    @Generated
    public boolean isDownScaling() {
        return this.downScaling;
    }

    @Generated
    public boolean isForceScaling() {
        return this.forceScaling;
    }

    @Generated
    public String getLevelBar() {
        return this.levelBar;
    }

    @Generated
    public String getFoodBar() {
        return this.foodBar;
    }

    @Generated
    public boolean isBlockSaturation() {
        return this.blockSaturation;
    }

    @Generated
    public boolean isRefundOnClassChange() {
        return this.refundOnClassChange;
    }

    @Generated
    public String getLevelText() {
        return this.levelText;
    }

    @Generated
    public boolean isUseActionBar() {
        return this.useActionBar;
    }

    @Generated
    public String getActionText() {
        return this.actionText;
    }

    @Generated
    public boolean isShowScoreboard() {
        return this.showScoreboard;
    }

    @Generated
    public boolean isShowClassName() {
        return this.showClassName;
    }

    @Generated
    public boolean isShowClassLevel() {
        return this.showClassLevel;
    }

    @Generated
    public boolean isShowBinds() {
        return this.showBinds;
    }

    @Generated
    public String getBindText() {
        return this.bindText;
    }

    @Generated
    public int getTitleDuration() {
        return this.titleDuration;
    }

    @Generated
    public int getTitleFadeIn() {
        return this.titleFadeIn;
    }

    @Generated
    public int getTitleFadeOut() {
        return this.titleFadeOut;
    }

    @Generated
    public int getPvpLevelRange() {
        return this.pvpLevelRange;
    }

    @Generated
    public int getPvpMinLevel() {
        return this.pvpMinLevel;
    }

    @Generated
    public boolean isCastEnabled() {
        return this.castEnabled;
    }

    @Generated
    public CastMode getCastMode() {
        return this.castMode;
    }

    @Generated
    public int getCastSlot() {
        return this.castSlot;
    }

    @Generated
    public long getCastCooldown() {
        return this.castCooldown;
    }

    @Generated
    public String getMessageFormatSkill() {
        return this.messageFormatSkill;
    }

    @Generated
    public String getMessageFormatSeparator() {
        return this.messageFormatSeparator;
    }

    @Generated
    public String getWheelFormatSelectedSkill() {
        return this.wheelFormatSelectedSkill;
    }

    @Generated
    public String getWheelFormatUnselectedSkill() {
        return this.wheelFormatUnselectedSkill;
    }

    @Generated
    public String getWheelFormatPreviousSeparator() {
        return this.wheelFormatPreviousSeparator;
    }

    @Generated
    public String getWheelFormatNextSeparator() {
        return this.wheelFormatNextSeparator;
    }

    @Generated
    public boolean isWheelSneakToOffhand() {
        return this.wheelSneakToOffhand;
    }

    @Generated
    public boolean isWheelSneakToScroll() {
        return this.wheelSneakToScroll;
    }

    @Generated
    public String getWheelSoundsStartCasting() {
        return this.wheelSoundsStartCasting;
    }

    @Generated
    public String getWheelSoundsStopCasting() {
        return this.wheelSoundsStopCasting;
    }

    @Generated
    public String getWheelSoundsScroll() {
        return this.wheelSoundsScroll;
    }

    @Generated
    public int getWheelSoundsVolume() {
        return this.wheelSoundsVolume;
    }

    @Generated
    public String getWheelCastKey() {
        return this.wheelCastKey;
    }

    @Generated
    public boolean[] getEnabledClicks() {
        return this.enabledClicks;
    }

    @Generated
    public boolean isCombosEnabled() {
        return this.combosEnabled;
    }

    @Generated
    public boolean isCustomCombosAllowed() {
        return this.customCombosAllowed;
    }

    @Generated
    public boolean shouldAutoAssignCombos() {
        return this.shouldAutoAssignCombos;
    }

    @Generated
    public int getComboSize() {
        return this.comboSize;
    }

    @Generated
    public int getClickTime() {
        return this.clickTime;
    }

    @Generated
    public boolean isUseOrbs() {
        return this.useOrbs;
    }

    @Generated
    public boolean isBlockSpawner() {
        return this.blockSpawner;
    }

    @Generated
    public boolean isBlockEgg() {
        return this.blockEgg;
    }

    @Generated
    public boolean isBlockCreative() {
        return this.blockCreative;
    }

    @Generated
    public boolean isShowExpMessages() {
        return this.showExpMessages;
    }

    @Generated
    public boolean isShowLevelMessages() {
        return this.showLevelMessages;
    }

    @Generated
    public boolean isShowLossExpMessages() {
        return this.showLossExpMessages;
    }

    @Generated
    public boolean isShowLossLevelMessages() {
        return this.showLossLevelMessages;
    }

    @Generated
    public boolean isSkillBarEnabled() {
        return this.skillBarEnabled;
    }

    @Generated
    public boolean isSkillBarCooldowns() {
        return this.skillBarCooldowns;
    }

    @Generated
    public ItemStack getUnassigned() {
        return this.unassigned;
    }

    @Generated
    public boolean isInteractRightClick() {
        return this.interactRightClick;
    }

    @Generated
    public boolean isAnimationLeftClick() {
        return this.animationLeftClick;
    }
}

