/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.cmd;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.magemonkey.codex.mccore.commands.CommandManager;
import studio.magemonkey.codex.mccore.commands.ConfigurableCommand;
import studio.magemonkey.codex.mccore.commands.IFunction;
import studio.magemonkey.codex.mccore.config.CustomFilter;
import studio.magemonkey.codex.mccore.config.Filter;
import studio.magemonkey.codex.mccore.config.parse.NumberParser;
import studio.magemonkey.fabled.Fabled;
import studio.magemonkey.fabled.api.enums.ManaSource;
import studio.magemonkey.fabled.api.player.PlayerData;
import studio.magemonkey.fabled.language.RPGFilter;

public class CmdMana
implements IFunction,
TabCompleter {
    private static final String NOT_PLAYER = "not-player";
    private static final String NOT_NUMBER = "not-number";
    private static final String NOT_POSITIVE = "not-positive";
    private static final String GAVE_MANA = "gave-mana";
    private static final String RECEIVED_MANA = "received-mana";
    private static final String DISABLED = "world-disabled";

    public void execute(ConfigurableCommand cmd, Plugin plugin, CommandSender sender, String[] args, boolean silent) {
        if (sender instanceof Player && !Fabled.getSettings().isWorldEnabled(((Player)sender).getWorld()) && args.length == 1) {
            cmd.sendMessage(sender, DISABLED, "&4You cannot use this command in this world", silent, new CustomFilter[0]);
        } else if (args.length >= 1 && (args.length >= 2 || sender instanceof Player)) {
            double amount;
            OfflinePlayer target;
            OfflinePlayer offlinePlayer = target = args.length == 1 ? (OfflinePlayer)sender : Bukkit.getOfflinePlayer((String)args[0]);
            if (target == null) {
                cmd.sendMessage(sender, NOT_PLAYER, String.valueOf(ChatColor.RED) + "That is not a valid player name", silent, new CustomFilter[0]);
                return;
            }
            try {
                amount = NumberParser.parseDouble((String)args[args.length == 1 ? 0 : 1]);
            }
            catch (Exception ex) {
                cmd.sendMessage(sender, NOT_NUMBER, String.valueOf(ChatColor.RED) + "That is not a valid mana amount", silent, new CustomFilter[0]);
                return;
            }
            if (amount <= 0.0) {
                cmd.sendMessage(sender, NOT_POSITIVE, String.valueOf(ChatColor.RED) + "You must give a positive amount of mana", silent, new CustomFilter[0]);
                return;
            }
            PlayerData data = Fabled.getData(target);
            data.giveMana(amount, ManaSource.COMMAND);
            if (target != sender) {
                cmd.sendMessage(sender, GAVE_MANA, String.valueOf(ChatColor.DARK_GREEN) + "You have given " + String.valueOf(ChatColor.GOLD) + "{player} {mana} mana", silent, new CustomFilter[]{Filter.PLAYER.setReplacement(target.getName()), RPGFilter.MANA.setReplacement("" + amount)});
            }
            if (target.isOnline()) {
                cmd.sendMessage((CommandSender)target.getPlayer(), RECEIVED_MANA, String.valueOf(ChatColor.DARK_GREEN) + "You have received " + String.valueOf(ChatColor.GOLD) + "{mana} mana " + String.valueOf(ChatColor.DARK_GREEN) + "from " + String.valueOf(ChatColor.GOLD) + "{player}", silent, new CustomFilter[]{Filter.PLAYER.setReplacement(sender.getName()), RPGFilter.MANA.setReplacement("" + amount)});
            }
        } else {
            CommandManager.displayUsage((ConfigurableCommand)cmd, (CommandSender)sender);
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (args.length == 1) {
            return ConfigurableCommand.getPlayerTabCompletions((CommandSender)commandSender, (String)args[0]);
        }
        return null;
    }
}

