/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.target;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.utilities.reflection.FakeBoundingBox;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;
import studio.magemonkey.fabled.api.target.AABB;
import studio.magemonkey.fabled.hook.DisguiseHook;
import studio.magemonkey.fabled.hook.PluginChecker;

public abstract class TargetHelper {
    private static final int PIXELS_PER_DEGREE = 35;

    public static List<LivingEntity> getLivingTargets(LivingEntity source, double range) {
        return TargetHelper.getLivingTargets(source, range, 4.0);
    }

    public static List<LivingEntity> getLivingTargets(LivingEntity source, double range, double tolerance) {
        List list = source.getNearbyEntities(range, range, range);
        TreeMap<Double, LivingEntity> targets = new TreeMap<Double, LivingEntity>();
        Location location = source.getEyeLocation();
        Vector origin = location.toVector();
        AABB.Ray3D ray = new AABB.Ray3D(location);
        for (Entity entity : list) {
            if (!TargetHelper.isInFront((Entity)source, entity) || !(entity instanceof LivingEntity)) continue;
            AABB aabb = TargetHelper.getAABB(entity);
            aabb.expand(tolerance);
            AABB.Vec3D collision = aabb.intersectsRay(ray, 0.0f, range);
            if (collision == null) continue;
            targets.put(((LivingEntity)entity).getEyeLocation().toVector().distance(origin), (LivingEntity)entity);
        }
        return new ArrayList<LivingEntity>(targets.values());
    }

    public static LivingEntity getLivingTarget(LivingEntity source, double range) {
        return TargetHelper.getLivingTarget(source, range, 4.0);
    }

    public static LivingEntity getLivingTarget(LivingEntity source, double range, double tolerance) {
        List<LivingEntity> targets = TargetHelper.getLivingTargets(source, range, tolerance);
        if (targets.isEmpty()) {
            return null;
        }
        return targets.get(0);
    }

    public static List<LivingEntity> getConeTargets(LivingEntity source, double arc, double range, double rotation, boolean resetY) {
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        List list = source.getNearbyEntities(range, range, range);
        if (arc <= 0.0) {
            return targets;
        }
        Location sourceLocation = source.getEyeLocation();
        Vector dir = sourceLocation.getDirection();
        if (resetY) {
            dir.setY(0);
        }
        if (rotation != 0.0) {
            dir.rotateAroundY(rotation);
        }
        double cos = Math.cos(arc * Math.PI / 180.0);
        double cosSq = cos * cos;
        for (Entity entity : list) {
            if (!(entity instanceof LivingEntity)) continue;
            if (arc >= 360.0) {
                targets.add((LivingEntity)entity);
                continue;
            }
            Vector relative = entity.getLocation().clone().add(0.0, TargetHelper.getHeight(entity) * 0.5, 0.0).subtract(sourceLocation).toVector();
            if (resetY) {
                relative.setY(0);
            }
            double dot = relative.dot(dir);
            double value = dot * dot / relative.lengthSquared();
            if (arc < 180.0 && dot > 0.0 && value >= cosSq) {
                targets.add((LivingEntity)entity);
                continue;
            }
            if (!(arc >= 180.0) || !(dot > 0.0) && !(dot <= cosSq)) continue;
            targets.add((LivingEntity)entity);
        }
        return targets;
    }

    public static boolean isInFront(Entity entity, Entity target) {
        Vector relative;
        Vector facing = entity.getLocation().getDirection();
        return facing.dot(relative = target.getLocation().clone().add(0.0, TargetHelper.getHeight(entity) * -0.5, 0.0).subtract(entity.getLocation()).toVector()) >= 0.0;
    }

    public static boolean isInFront(Entity entity, Entity target, double angle) {
        Vector relative;
        if (angle <= 0.0) {
            return false;
        }
        if (angle >= 360.0) {
            return true;
        }
        double dotTarget = Math.cos(angle);
        Vector facing = entity.getLocation().getDirection();
        return facing.dot(relative = target.getLocation().clone().add(0.0, TargetHelper.getHeight(entity) * -0.5, 0.0).subtract(entity.getLocation()).toVector().normalize()) >= dotTarget;
    }

    public static boolean isBehind(Entity entity, Entity target) {
        return !TargetHelper.isInFront(entity, target);
    }

    public static boolean isBehind(Entity entity, Entity target, double angle) {
        return !TargetHelper.isInFront(entity, target, angle);
    }

    public static boolean isObstructed(Location loc1, Location loc2) {
        if (loc1.getX() == loc2.getX() && loc1.getY() == loc2.getY() && loc1.getZ() == loc2.getZ()) {
            return false;
        }
        Vector slope = loc2.clone().subtract(loc1).toVector();
        int steps = (int)(slope.length() * 4.0) + 1;
        slope.multiply(1.0 / (double)steps);
        Location temp = loc1.clone();
        for (int i = 0; i < steps; ++i) {
            temp.add(slope);
            if (!TargetHelper.isSolid(temp.getBlock().getType())) continue;
            return true;
        }
        return false;
    }

    public static Location getOpenLocation(Location loc1, Location loc2, boolean throughWall) {
        int steps;
        if (loc1.getX() == loc2.getX() && loc1.getY() == loc2.getY() && loc1.getZ() == loc2.getZ()) {
            return loc1;
        }
        Vector slope = loc2.clone().subtract(loc1).toVector();
        slope.multiply(1.0 / (double)steps);
        if (throughWall) {
            Location temp = loc2.clone();
            for (steps = (int)(slope.length() * 4.0) + 1; steps > 0; --steps) {
                if (!TargetHelper.isSolid(temp.getBlock().getType()) && !TargetHelper.isSolid(temp.getBlock().getRelative(BlockFace.UP).getType())) {
                    temp.setX((double)temp.getBlockX() + 0.5);
                    temp.setZ((double)temp.getBlockZ() + 0.5);
                    temp.setY((double)(temp.getBlockY() + 1));
                    return temp;
                }
                temp.subtract(slope);
            }
            return loc1;
        }
        Location temp = loc1.clone();
        Location lastValid = null;
        while (steps > 0 && !TargetHelper.isSolid(temp.getBlock().getType()) && !TargetHelper.isSolid(temp.getBlock().getRelative(BlockFace.UP).getType())) {
            lastValid = temp.clone();
            temp.add(slope);
            --steps;
        }
        if (lastValid != null) {
            lastValid.setX((double)lastValid.getBlockX() + 0.5);
            lastValid.setZ((double)lastValid.getBlockZ() + 0.5);
            lastValid.setY((double)(lastValid.getBlockY() + 1));
            return lastValid;
        }
        return loc1;
    }

    public static boolean isSolid(Material mat) {
        if (!mat.isSolid()) {
            return false;
        }
        return mat.isOccluding() || mat.name().contains("GLASS") || mat.name().contains("FENCE") || mat.name().contains("LEAVES") || mat.name().contains("SLAB") || mat.name().contains("STAIR");
    }

    public static AABB getAABB(Entity entity) {
        AABB.Vec3D origin = AABB.Vec3D.fromLocation(entity.getLocation());
        try {
            if (PluginChecker.isDisguiseActive() && DisguiseAPI.isDisguised((Entity)entity) && DisguiseAPI.getDisguise((Entity)entity).isModifyBoundingBox()) {
                FakeBoundingBox boundingBox = DisguiseHook.getFakeBoundingBox(entity);
                return new AABB(origin.add(new AABB.Vec3D(-boundingBox.getX(), 0.0, -boundingBox.getZ())), origin.add(new AABB.Vec3D(boundingBox.getX(), boundingBox.getY(), boundingBox.getZ())));
            }
        }
        catch (NullPointerException boundingBox) {
            // empty catch block
        }
        double halfWidth = entity.getWidth() / 2.0;
        return new AABB(origin.add(new AABB.Vec3D(-halfWidth, 0.0, -halfWidth)), origin.add(new AABB.Vec3D(halfWidth, entity.getHeight(), halfWidth)));
    }

    public static double getHeight(Entity entity) {
        return PluginChecker.isDisguiseActive() && DisguiseAPI.isDisguised((Entity)entity) ? DisguiseHook.getFakeBoundingBox(entity).getY() : entity.getHeight();
    }
}

