/*
 * Decompiled with CFR 0.152.
 */
package studio.magemonkey.fabled.api.particle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import studio.magemonkey.fabled.api.particle.EffectInstance;
import studio.magemonkey.fabled.api.particle.IParticleEffect;
import studio.magemonkey.fabled.api.particle.target.EffectTarget;

public class EffectData {
    private final Map<String, EffectInstance> effects = new HashMap<String, EffectInstance>();
    private final EffectTarget target;

    public EffectData(EffectTarget target) {
        this.target = target;
    }

    public boolean isEffectActive(String key) {
        return this.effects.containsKey(key);
    }

    public EffectInstance getEffect(String key) {
        return this.effects.get(key);
    }

    public boolean isValid() {
        return !this.effects.isEmpty() && this.target.isValid();
    }

    public void runEffect(IParticleEffect effect, int ticks, int level) {
        EffectInstance instance = new EffectInstance(effect, this.target, level);
        instance.extend(ticks);
        this.effects.put(effect.getName(), instance);
    }

    public void cancel(String key) {
        this.effects.remove(key);
    }

    public void tick() {
        Iterator<EffectInstance> iterator = this.effects.values().iterator();
        while (iterator.hasNext()) {
            EffectInstance effect = iterator.next();
            if (effect.isValid()) {
                effect.tick();
                continue;
            }
            iterator.remove();
        }
    }
}

